/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.prometheus;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.PushGateway;
import java.io.IOException;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class PushGatewayReporter
extends ScheduledReporter {
    private static final Logger LOG = LogManager.getLogger(PushGatewayReporter.class);
    private final PushGateway pushGateway;
    private final DropwizardExports metricExports;
    private final CollectorRegistry collectorRegistry;
    private final String jobName;
    private final boolean deleteShutdown;

    protected PushGatewayReporter(MetricRegistry registry, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, String jobName, String address, boolean deleteShutdown) {
        super(registry, "hudi-push-gateway-reporter", filter, rateUnit, durationUnit);
        this.jobName = jobName;
        this.deleteShutdown = deleteShutdown;
        this.collectorRegistry = new CollectorRegistry();
        this.metricExports = new DropwizardExports(registry);
        this.pushGateway = new PushGateway(address);
        this.metricExports.register(this.collectorRegistry);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            this.pushGateway.pushAdd(this.collectorRegistry, this.jobName);
        }
        catch (IOException e) {
            LOG.warn((Object)"Can't push monitoring information to pushGateway", (Throwable)e);
        }
    }

    public void start(long period, TimeUnit unit) {
        super.start(period, unit);
    }

    public void stop() {
        super.stop();
        try {
            if (this.deleteShutdown) {
                this.collectorRegistry.unregister((Collector)this.metricExports);
                this.pushGateway.delete(this.jobName);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to delete metrics from pushGateway with jobName {" + this.jobName + "}"), (Throwable)e);
        }
    }
}

