/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.MetricRegistry;
import java.io.Closeable;
import java.util.Map;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metrics.HoodieGauge;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.MetricsReporterFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Metrics {
    private static final Logger LOG = LogManager.getLogger(Metrics.class);
    private static volatile boolean initialized = false;
    private static Metrics instance = null;
    private final MetricRegistry registry = new MetricRegistry();
    private MetricsReporter reporter;
    private final String commonMetricPrefix;

    private Metrics(HoodieWriteConfig metricConfig) {
        this.commonMetricPrefix = metricConfig.getTableName();
        this.reporter = MetricsReporterFactory.createReporter(metricConfig, this.registry);
        if (this.reporter == null) {
            throw new RuntimeException("Cannot initialize Reporter.");
        }
        this.reporter.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.reportAndCloseReporter()));
    }

    private void reportAndCloseReporter() {
        try {
            this.registerHoodieCommonMetrics();
            this.reporter.report();
            if (this.getReporter() != null) {
                this.getReporter().close();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while closing reporter", (Throwable)e);
        }
    }

    private void reportAndFlushMetrics() {
        try {
            LOG.info((Object)"Reporting and flushing all metrics");
            this.registerHoodieCommonMetrics();
            this.reporter.report();
            this.registry.getNames().forEach(arg_0 -> ((MetricRegistry)this.registry).remove(arg_0));
        }
        catch (Exception e) {
            LOG.error((Object)"Error while reporting and flushing metrics", (Throwable)e);
        }
    }

    private void registerHoodieCommonMetrics() {
        Metrics.registerGauges(Registry.getAllMetrics((boolean)true, (boolean)true), (Option<String>)Option.of((Object)this.commonMetricPrefix));
    }

    public static Metrics getInstance() {
        assert (initialized);
        return instance;
    }

    public static synchronized void init(HoodieWriteConfig metricConfig) {
        if (initialized) {
            return;
        }
        try {
            instance = new Metrics(metricConfig);
        }
        catch (Exception e) {
            throw new HoodieException((Throwable)e);
        }
        initialized = true;
    }

    public static synchronized void shutdown() {
        if (!initialized) {
            return;
        }
        instance.reportAndCloseReporter();
        initialized = false;
    }

    public static synchronized void flush() {
        if (!initialized) {
            return;
        }
        instance.reportAndFlushMetrics();
    }

    public static void registerGauges(Map<String, Long> metricsMap, Option<String> prefix) {
        String metricPrefix = prefix.isPresent() ? (String)prefix.get() + "." : "";
        metricsMap.forEach((k, v) -> Metrics.registerGauge(metricPrefix + k, v));
    }

    public static void registerGauge(String metricName, long value) {
        try {
            MetricRegistry registry = Metrics.getInstance().getRegistry();
            HoodieGauge guage = (HoodieGauge)registry.gauge(metricName, () -> new HoodieGauge<Long>(value));
            guage.setValue(value);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to send metrics: ", (Throwable)e);
        }
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public Closeable getReporter() {
        return this.reporter.getReporter();
    }
}

