/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieIOHandle;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.table.HoodieTable;

public abstract class HoodieReadHandle<T extends HoodieRecordPayload, I, K, O>
extends HoodieIOHandle<T, I, K, O> {
    protected final Pair<String, String> partitionPathFilePair;

    public HoodieReadHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Pair<String, String> partitionPathFilePair) {
        super(config, instantTime, hoodieTable);
        this.partitionPathFilePair = partitionPathFilePair;
    }

    @Override
    protected FileSystem getFileSystem() {
        return this.hoodieTable.getMetaClient().getFs();
    }

    public Pair<String, String> getPartitionPathFilePair() {
        return this.partitionPathFilePair;
    }

    public String getFileId() {
        return (String)this.partitionPathFilePair.getRight();
    }

    protected HoodieBaseFile getLatestDataFile() {
        return (HoodieBaseFile)this.hoodieTable.getBaseFileOnlyView().getLatestBaseFile((String)this.partitionPathFilePair.getLeft(), (String)this.partitionPathFilePair.getRight()).get();
    }

    protected HoodieFileReader createNewFileReader() throws IOException {
        return HoodieFileReaderFactory.getFileReader((Configuration)this.hoodieTable.getHadoopConf(), (Path)new Path(this.getLatestDataFile().getPath()));
    }
}

