/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.bootstrap.BootstrapMode;
import org.apache.hudi.client.transaction.ConflictResolutionStrategy;
import org.apache.hudi.common.config.DefaultHoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieMemoryConfig;
import org.apache.hudi.config.HoodieMetricsConfig;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.config.HoodieStorageConfig;
import org.apache.hudi.config.HoodieWriteCommitCallbackConfig;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.metrics.datadog.DatadogHttpClient;
import org.apache.hudi.table.action.compact.CompactionTriggerStrategy;
import org.apache.hudi.table.action.compact.strategy.CompactionStrategy;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

@Immutable
public class HoodieWriteConfig
extends DefaultHoodieConfig {
    private static final long serialVersionUID = 0L;
    public static final String TABLE_NAME = "hoodie.table.name";
    public static final String PRECOMBINE_FIELD_PROP = "hoodie.datasource.write.precombine.field";
    public static final String WRITE_PAYLOAD_CLASS = "hoodie.datasource.write.payload.class";
    public static final String DEFAULT_WRITE_PAYLOAD_CLASS = OverwriteWithLatestAvroPayload.class.getName();
    public static final String KEYGENERATOR_CLASS_PROP = "hoodie.datasource.write.keygenerator.class";
    public static final String DEFAULT_KEYGENERATOR_CLASS = SimpleAvroKeyGenerator.class.getName();
    public static final String DEFAULT_ROLLBACK_USING_MARKERS = "false";
    public static final String ROLLBACK_USING_MARKERS = "hoodie.rollback.using.markers";
    public static final String TIMELINE_LAYOUT_VERSION = "hoodie.timeline.layout.version";
    public static final String BASE_PATH_PROP = "hoodie.base.path";
    public static final String AVRO_SCHEMA = "hoodie.avro.schema";
    public static final String AVRO_SCHEMA_VALIDATE = "hoodie.avro.schema.validate";
    public static final String DEFAULT_AVRO_SCHEMA_VALIDATE = "false";
    public static final String DEFAULT_PARALLELISM = "1500";
    public static final String INSERT_PARALLELISM = "hoodie.insert.shuffle.parallelism";
    public static final String BULKINSERT_PARALLELISM = "hoodie.bulkinsert.shuffle.parallelism";
    public static final String BULKINSERT_USER_DEFINED_PARTITIONER_CLASS = "hoodie.bulkinsert.user.defined.partitioner.class";
    public static final String BULKINSERT_INPUT_DATA_SCHEMA_DDL = "hoodie.bulkinsert.schema.ddl";
    public static final String UPSERT_PARALLELISM = "hoodie.upsert.shuffle.parallelism";
    public static final String DELETE_PARALLELISM = "hoodie.delete.shuffle.parallelism";
    public static final String DEFAULT_ROLLBACK_PARALLELISM = "100";
    public static final String ROLLBACK_PARALLELISM = "hoodie.rollback.parallelism";
    public static final String WRITE_BUFFER_LIMIT_BYTES = "hoodie.write.buffer.limit.bytes";
    public static final String DEFAULT_WRITE_BUFFER_LIMIT_BYTES = String.valueOf(0x400000);
    public static final String COMBINE_BEFORE_INSERT_PROP = "hoodie.combine.before.insert";
    public static final String DEFAULT_COMBINE_BEFORE_INSERT = "false";
    public static final String COMBINE_BEFORE_UPSERT_PROP = "hoodie.combine.before.upsert";
    public static final String DEFAULT_COMBINE_BEFORE_UPSERT = "true";
    public static final String COMBINE_BEFORE_DELETE_PROP = "hoodie.combine.before.delete";
    public static final String DEFAULT_COMBINE_BEFORE_DELETE = "true";
    public static final String WRITE_STATUS_STORAGE_LEVEL = "hoodie.write.status.storage.level";
    public static final String DEFAULT_WRITE_STATUS_STORAGE_LEVEL = "MEMORY_AND_DISK_SER";
    public static final String HOODIE_AUTO_COMMIT_PROP = "hoodie.auto.commit";
    public static final String DEFAULT_HOODIE_AUTO_COMMIT = "true";
    public static final String HOODIE_WRITE_STATUS_CLASS_PROP = "hoodie.writestatus.class";
    public static final String DEFAULT_HOODIE_WRITE_STATUS_CLASS = WriteStatus.class.getName();
    public static final String FINALIZE_WRITE_PARALLELISM = "hoodie.finalize.write.parallelism";
    public static final String DEFAULT_FINALIZE_WRITE_PARALLELISM = "1500";
    public static final String MARKERS_DELETE_PARALLELISM = "hoodie.markers.delete.parallelism";
    public static final String DEFAULT_MARKERS_DELETE_PARALLELISM = "100";
    public static final String BULKINSERT_SORT_MODE = "hoodie.bulkinsert.sort.mode";
    public static final String DEFAULT_BULKINSERT_SORT_MODE = BulkInsertSortMode.GLOBAL_SORT.toString();
    public static final String EMBEDDED_TIMELINE_SERVER_ENABLED = "hoodie.embed.timeline.server";
    public static final String DEFAULT_EMBEDDED_TIMELINE_SERVER_ENABLED = "true";
    public static final String EMBEDDED_TIMELINE_SERVER_PORT = "hoodie.embed.timeline.server.port";
    public static final String DEFAULT_EMBEDDED_TIMELINE_SERVER_PORT = "0";
    public static final String EMBEDDED_TIMELINE_SERVER_THREADS = "hoodie.embed.timeline.server.threads";
    public static final String DEFAULT_EMBEDDED_TIMELINE_SERVER_THREADS = "-1";
    public static final String EMBEDDED_TIMELINE_SERVER_COMPRESS_OUTPUT = "hoodie.embed.timeline.server.gzip";
    public static final String DEFAULT_EMBEDDED_TIMELINE_COMPRESS_OUTPUT = "true";
    public static final String EMBEDDED_TIMELINE_SERVER_USE_ASYNC = "hoodie.embed.timeline.server.async";
    public static final String DEFAULT_EMBEDDED_TIMELINE_SERVER_ASYNC = "false";
    public static final String FAIL_ON_TIMELINE_ARCHIVING_ENABLED_PROP = "hoodie.fail.on.timeline.archiving";
    public static final String DEFAULT_FAIL_ON_TIMELINE_ARCHIVING_ENABLED = "true";
    public static final String INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP = "hoodie.consistency.check.initial_interval_ms";
    public static long DEFAULT_INITIAL_CONSISTENCY_CHECK_INTERVAL_MS = 2000L;
    public static final String MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP = "hoodie.consistency.check.max_interval_ms";
    public static long DEFAULT_MAX_CONSISTENCY_CHECK_INTERVAL_MS = 300000L;
    public static final String MAX_CONSISTENCY_CHECKS_PROP = "hoodie.consistency.check.max_checks";
    public static int DEFAULT_MAX_CONSISTENCY_CHECKS = 7;
    private static final String MERGE_DATA_VALIDATION_CHECK_ENABLED = "hoodie.merge.data.validation.enabled";
    private static final String DEFAULT_MERGE_DATA_VALIDATION_CHECK_ENABLED = "false";
    private static final String MERGE_ALLOW_DUPLICATE_ON_INSERTS = "hoodie.merge.allow.duplicate.on.inserts";
    private static final String DEFAULT_MERGE_ALLOW_DUPLICATE_ON_INSERTS = "false";
    public static final String CLIENT_HEARTBEAT_INTERVAL_IN_MS_PROP = "hoodie.client.heartbeat.interval_in_ms";
    public static final Integer DEFAULT_CLIENT_HEARTBEAT_INTERVAL_IN_MS = 60000;
    public static final String CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES_PROP = "hoodie.client.heartbeat.tolerable.misses";
    public static final Integer DEFAULT_CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES = 2;
    public static final String WRITE_CONCURRENCY_MODE_PROP = "hoodie.write.concurrency.mode";
    public static final String DEFAULT_WRITE_CONCURRENCY_MODE = WriteConcurrencyMode.SINGLE_WRITER.name();
    public static final String WRITE_META_KEY_PREFIXES_PROP = "hoodie.write.meta.key.prefixes";
    public static final String DEFAULT_WRITE_META_KEY_PREFIXES = "";
    public static final String ALLOW_MULTI_WRITE_ON_SAME_INSTANT = "_.hoodie.allow.multi.write.on.same.instant";
    public static final String DEFAULT_ALLOW_MULTI_WRITE_ON_SAME_INSTANT = "false";
    public static final String EXTERNAL_RECORD_AND_SCHEMA_TRANSFORMATION = "hoodie.avro.schema.externalTransformation";
    public static final String DEFAULT_EXTERNAL_RECORD_AND_SCHEMA_TRANSFORMATION = "false";
    private ConsistencyGuardConfig consistencyGuardConfig;
    private final FileSystemViewStorageConfig clientSpecifiedViewStorageConfig;
    private FileSystemViewStorageConfig viewStorageConfig;
    private HoodiePayloadConfig hoodiePayloadConfig;
    private HoodieMetadataConfig metadataConfig;
    private EngineType engineType;

    protected HoodieWriteConfig(Properties props) {
        this(EngineType.SPARK, props);
    }

    protected HoodieWriteConfig(EngineType engineType, Properties props) {
        super(props);
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)props);
        this.engineType = engineType;
        this.consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().fromProperties(newProps).build();
        this.viewStorageConfig = this.clientSpecifiedViewStorageConfig = FileSystemViewStorageConfig.newBuilder().fromProperties(newProps).build();
        this.hoodiePayloadConfig = HoodiePayloadConfig.newBuilder().fromProperties(newProps).build();
        this.metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(props).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getBasePath() {
        return this.props.getProperty(BASE_PATH_PROP);
    }

    public String getSchema() {
        return this.props.getProperty(AVRO_SCHEMA);
    }

    public void setSchema(String schemaStr) {
        this.props.setProperty(AVRO_SCHEMA, schemaStr);
    }

    public boolean getAvroSchemaValidate() {
        return Boolean.parseBoolean(this.props.getProperty(AVRO_SCHEMA_VALIDATE));
    }

    public String getTableName() {
        return this.props.getProperty(TABLE_NAME);
    }

    public String getPreCombineField() {
        return this.props.getProperty(PRECOMBINE_FIELD_PROP);
    }

    public String getWritePayloadClass() {
        return this.props.getProperty(WRITE_PAYLOAD_CLASS);
    }

    public String getKeyGeneratorClass() {
        return this.props.getProperty(KEYGENERATOR_CLASS_PROP);
    }

    public Boolean shouldAutoCommit() {
        return Boolean.parseBoolean(this.props.getProperty(HOODIE_AUTO_COMMIT_PROP));
    }

    public Boolean shouldAssumeDatePartitioning() {
        return this.metadataConfig.shouldAssumeDatePartitioning();
    }

    public boolean shouldUseExternalSchemaTransformation() {
        return Boolean.parseBoolean(this.props.getProperty(EXTERNAL_RECORD_AND_SCHEMA_TRANSFORMATION));
    }

    public Integer getTimelineLayoutVersion() {
        return Integer.parseInt(this.props.getProperty(TIMELINE_LAYOUT_VERSION));
    }

    public int getBulkInsertShuffleParallelism() {
        return Integer.parseInt(this.props.getProperty(BULKINSERT_PARALLELISM));
    }

    public String getUserDefinedBulkInsertPartitionerClass() {
        return this.props.getProperty(BULKINSERT_USER_DEFINED_PARTITIONER_CLASS);
    }

    public int getInsertShuffleParallelism() {
        return Integer.parseInt(this.props.getProperty(INSERT_PARALLELISM));
    }

    public int getUpsertShuffleParallelism() {
        return Integer.parseInt(this.props.getProperty(UPSERT_PARALLELISM));
    }

    public int getDeleteShuffleParallelism() {
        return Math.max(Integer.parseInt(this.props.getProperty(DELETE_PARALLELISM)), 1);
    }

    public int getRollbackParallelism() {
        return Integer.parseInt(this.props.getProperty(ROLLBACK_PARALLELISM));
    }

    public int getFileListingParallelism() {
        return this.metadataConfig.getFileListingParallelism();
    }

    public boolean shouldRollbackUsingMarkers() {
        return Boolean.parseBoolean(this.props.getProperty(ROLLBACK_USING_MARKERS));
    }

    public int getWriteBufferLimitBytes() {
        return Integer.parseInt(this.props.getProperty(WRITE_BUFFER_LIMIT_BYTES, DEFAULT_WRITE_BUFFER_LIMIT_BYTES));
    }

    public boolean shouldCombineBeforeInsert() {
        return Boolean.parseBoolean(this.props.getProperty(COMBINE_BEFORE_INSERT_PROP));
    }

    public boolean shouldCombineBeforeUpsert() {
        return Boolean.parseBoolean(this.props.getProperty(COMBINE_BEFORE_UPSERT_PROP));
    }

    public boolean shouldCombineBeforeDelete() {
        return Boolean.parseBoolean(this.props.getProperty(COMBINE_BEFORE_DELETE_PROP));
    }

    public boolean shouldAllowMultiWriteOnSameInstant() {
        return Boolean.parseBoolean(this.props.getProperty(ALLOW_MULTI_WRITE_ON_SAME_INSTANT));
    }

    public String getWriteStatusClassName() {
        return this.props.getProperty(HOODIE_WRITE_STATUS_CLASS_PROP);
    }

    public int getFinalizeWriteParallelism() {
        return Integer.parseInt(this.props.getProperty(FINALIZE_WRITE_PARALLELISM));
    }

    public int getMarkersDeleteParallelism() {
        return Integer.parseInt(this.props.getProperty(MARKERS_DELETE_PARALLELISM));
    }

    public boolean isEmbeddedTimelineServerEnabled() {
        return Boolean.parseBoolean(this.props.getProperty(EMBEDDED_TIMELINE_SERVER_ENABLED));
    }

    public int getEmbeddedTimelineServerPort() {
        return Integer.parseInt(this.props.getProperty(EMBEDDED_TIMELINE_SERVER_PORT, DEFAULT_EMBEDDED_TIMELINE_SERVER_PORT));
    }

    public int getEmbeddedTimelineServerThreads() {
        return Integer.parseInt(this.props.getProperty(EMBEDDED_TIMELINE_SERVER_THREADS, DEFAULT_EMBEDDED_TIMELINE_SERVER_THREADS));
    }

    public boolean getEmbeddedTimelineServerCompressOutput() {
        return Boolean.parseBoolean(this.props.getProperty(EMBEDDED_TIMELINE_SERVER_COMPRESS_OUTPUT, "true"));
    }

    public boolean getEmbeddedTimelineServerUseAsync() {
        return Boolean.parseBoolean(this.props.getProperty(EMBEDDED_TIMELINE_SERVER_USE_ASYNC, "false"));
    }

    public boolean isFailOnTimelineArchivingEnabled() {
        return Boolean.parseBoolean(this.props.getProperty(FAIL_ON_TIMELINE_ARCHIVING_ENABLED_PROP));
    }

    public int getMaxConsistencyChecks() {
        return Integer.parseInt(this.props.getProperty(MAX_CONSISTENCY_CHECKS_PROP));
    }

    public int getInitialConsistencyCheckIntervalMs() {
        return Integer.parseInt(this.props.getProperty(INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP));
    }

    public int getMaxConsistencyCheckIntervalMs() {
        return Integer.parseInt(this.props.getProperty(MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP));
    }

    public BulkInsertSortMode getBulkInsertSortMode() {
        String sortMode = this.props.getProperty(BULKINSERT_SORT_MODE);
        return BulkInsertSortMode.valueOf(sortMode.toUpperCase());
    }

    public boolean isMergeDataValidationCheckEnabled() {
        return Boolean.parseBoolean(this.props.getProperty(MERGE_DATA_VALIDATION_CHECK_ENABLED));
    }

    public boolean allowDuplicateInserts() {
        return Boolean.parseBoolean(this.props.getProperty(MERGE_ALLOW_DUPLICATE_ON_INSERTS));
    }

    public EngineType getEngineType() {
        return this.engineType;
    }

    public HoodieCleaningPolicy getCleanerPolicy() {
        return HoodieCleaningPolicy.valueOf((String)this.props.getProperty("hoodie.cleaner.policy"));
    }

    public int getCleanerFileVersionsRetained() {
        return Integer.parseInt(this.props.getProperty("hoodie.cleaner.fileversions.retained"));
    }

    public int getCleanerCommitsRetained() {
        return Integer.parseInt(this.props.getProperty("hoodie.cleaner.commits.retained"));
    }

    public int getMaxCommitsToKeep() {
        return Integer.parseInt(this.props.getProperty("hoodie.keep.max.commits"));
    }

    public int getMinCommitsToKeep() {
        return Integer.parseInt(this.props.getProperty("hoodie.keep.min.commits"));
    }

    public int getParquetSmallFileLimit() {
        return Integer.parseInt(this.props.getProperty("hoodie.parquet.small.file.limit"));
    }

    public double getRecordSizeEstimationThreshold() {
        return Double.parseDouble(this.props.getProperty("hoodie.record.size.estimation.threshold"));
    }

    public int getCopyOnWriteInsertSplitSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.copyonwrite.insert.split.size"));
    }

    public int getCopyOnWriteRecordSizeEstimate() {
        return Integer.parseInt(this.props.getProperty("hoodie.copyonwrite.record.size.estimate"));
    }

    public boolean shouldAutoTuneInsertSplits() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.copyonwrite.insert.auto.split"));
    }

    public int getCleanerParallelism() {
        return Integer.parseInt(this.props.getProperty("hoodie.cleaner.parallelism"));
    }

    public boolean isAutoClean() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.clean.automatic"));
    }

    public boolean isAsyncClean() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.clean.async"));
    }

    public boolean incrementalCleanerModeEnabled() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.cleaner.incremental.mode"));
    }

    public boolean inlineCompactionEnabled() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.compact.inline"));
    }

    public CompactionTriggerStrategy getInlineCompactTriggerStrategy() {
        return CompactionTriggerStrategy.valueOf(this.props.getProperty("hoodie.compact.inline.trigger.strategy"));
    }

    public int getInlineCompactDeltaCommitMax() {
        return Integer.parseInt(this.props.getProperty("hoodie.compact.inline.max.delta.commits"));
    }

    public int getInlineCompactDeltaSecondsMax() {
        return Integer.parseInt(this.props.getProperty("hoodie.compact.inline.max.delta.seconds"));
    }

    public CompactionStrategy getCompactionStrategy() {
        return (CompactionStrategy)ReflectionUtils.loadClass((String)this.props.getProperty("hoodie.compaction.strategy"));
    }

    public Long getTargetIOPerCompactionInMB() {
        return Long.parseLong(this.props.getProperty("hoodie.compaction.target.io"));
    }

    public Boolean getCompactionLazyBlockReadEnabled() {
        return Boolean.valueOf(this.props.getProperty("hoodie.compaction.lazy.block.read"));
    }

    public Boolean getCompactionReverseLogReadEnabled() {
        return Boolean.valueOf(this.props.getProperty("hoodie.compaction.reverse.log.read"));
    }

    public boolean inlineClusteringEnabled() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.clustering.inline"));
    }

    public boolean isAsyncClusteringEnabled() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.clustering.async.enabled"));
    }

    public boolean isClusteringEnabled() {
        return this.inlineClusteringEnabled() || this.isAsyncClusteringEnabled();
    }

    public int getInlineClusterMaxCommits() {
        return Integer.parseInt(this.props.getProperty("hoodie.clustering.inline.max.commits"));
    }

    public String getPayloadClass() {
        return this.props.getProperty("hoodie.compaction.payload.class");
    }

    public int getTargetPartitionsPerDayBasedCompaction() {
        return Integer.parseInt(this.props.getProperty("hoodie.compaction.daybased.target.partitions"));
    }

    public int getCommitArchivalBatchSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.commits.archival.batch"));
    }

    public Boolean shouldCleanBootstrapBaseFile() {
        return Boolean.valueOf(this.props.getProperty("hoodie.cleaner.delete.bootstrap.base.file"));
    }

    public String getClusteringUpdatesStrategyClass() {
        return this.props.getProperty("hoodie.clustering.updates.strategy");
    }

    public HoodieFailedWritesCleaningPolicy getFailedWritesCleanPolicy() {
        return HoodieFailedWritesCleaningPolicy.valueOf((String)this.props.getProperty("hoodie.cleaner.policy.failed.writes"));
    }

    public String getClusteringPlanStrategyClass() {
        return this.props.getProperty("hoodie.clustering.plan.strategy.class");
    }

    public String getClusteringExecutionStrategyClass() {
        return this.props.getProperty("hoodie.clustering.execution.strategy.class");
    }

    public long getClusteringMaxBytesInGroup() {
        return Long.parseLong(this.props.getProperty("hoodie.clustering.plan.strategy.max.bytes.per.group"));
    }

    public long getClusteringSmallFileLimit() {
        return Long.parseLong(this.props.getProperty("hoodie.clustering.plan.strategy.small.file.limit"));
    }

    public int getClusteringMaxNumGroups() {
        return Integer.parseInt(this.props.getProperty("hoodie.clustering.plan.strategy.max.num.groups"));
    }

    public long getClusteringTargetFileMaxBytes() {
        return Long.parseLong(this.props.getProperty("hoodie.clustering.plan.strategy.target.file.max.bytes"));
    }

    public int getTargetPartitionsForClustering() {
        return Integer.parseInt(this.props.getProperty("hoodie.clustering.plan.strategy.daybased.lookback.partitions"));
    }

    public String getClusteringSortColumns() {
        return this.props.getProperty("hoodie.clustering.plan.strategy.sort.columns");
    }

    public HoodieIndex.IndexType getIndexType() {
        return HoodieIndex.IndexType.valueOf(this.props.getProperty("hoodie.index.type"));
    }

    public String getIndexClass() {
        return this.props.getProperty("hoodie.index.class");
    }

    public int getBloomFilterNumEntries() {
        return Integer.parseInt(this.props.getProperty("hoodie.index.bloom.num_entries"));
    }

    public double getBloomFilterFPP() {
        return Double.parseDouble(this.props.getProperty("hoodie.index.bloom.fpp"));
    }

    public String getHbaseZkQuorum() {
        return this.props.getProperty("hoodie.index.hbase.zkquorum");
    }

    public int getHbaseZkPort() {
        return Integer.parseInt(this.props.getProperty("hoodie.index.hbase.zkport"));
    }

    public String getHBaseZkZnodeParent() {
        return this.props.getProperty("hoodie.index.hbase.zknode.path");
    }

    public String getHbaseTableName() {
        return this.props.getProperty("hoodie.index.hbase.table");
    }

    public int getHbaseIndexGetBatchSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.index.hbase.get.batch.size"));
    }

    public Boolean getHBaseIndexRollbackSync() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.index.hbase.rollback.sync"));
    }

    public int getHbaseIndexPutBatchSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.index.hbase.put.batch.size"));
    }

    public Boolean getHbaseIndexPutBatchSizeAutoCompute() {
        return Boolean.valueOf(this.props.getProperty("hoodie.index.hbase.put.batch.size.autocompute"));
    }

    public String getHBaseQPSResourceAllocatorClass() {
        return this.props.getProperty("hoodie.index.hbase.qps.allocator.class");
    }

    public String getHBaseQPSZKnodePath() {
        return this.props.getProperty("hoodie.index.hbase.zkpath.qps_root");
    }

    public String getHBaseZkZnodeSessionTimeout() {
        return this.props.getProperty("hoodie.index.hbase.zk.session_timeout_ms");
    }

    public String getHBaseZkZnodeConnectionTimeout() {
        return this.props.getProperty("hoodie.index.hbase.zk.connection_timeout_ms");
    }

    public boolean getHBaseIndexShouldComputeQPSDynamically() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.index.hbase.dynamic_qps"));
    }

    public int getHBaseIndexDesiredPutsTime() {
        return Integer.parseInt(this.props.getProperty("hoodie.index.hbase.desired_puts_time_in_secs"));
    }

    public String getBloomFilterType() {
        return this.props.getProperty("hoodie.bloom.index.filter.type");
    }

    public int getDynamicBloomFilterMaxNumEntries() {
        return Integer.parseInt(this.props.getProperty("hoodie.bloom.index.filter.dynamic.max.entries"));
    }

    public float getHbaseIndexQPSFraction() {
        return Float.parseFloat(this.props.getProperty("hoodie.index.hbase.qps.fraction"));
    }

    public float getHBaseIndexMinQPSFraction() {
        return Float.parseFloat(this.props.getProperty("hoodie.index.hbase.min.qps.fraction"));
    }

    public float getHBaseIndexMaxQPSFraction() {
        return Float.parseFloat(this.props.getProperty("hoodie.index.hbase.max.qps.fraction"));
    }

    public int getHbaseIndexMaxQPSPerRegionServer() {
        return Integer.parseInt(this.props.getProperty("hoodie.index.hbase.max.qps.per.region.server"));
    }

    public boolean getHbaseIndexUpdatePartitionPath() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.hbase.index.update.partition.path"));
    }

    public int getBloomIndexParallelism() {
        return Integer.parseInt(this.props.getProperty("hoodie.bloom.index.parallelism"));
    }

    public boolean getBloomIndexPruneByRanges() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.bloom.index.prune.by.ranges"));
    }

    public boolean getBloomIndexUseCaching() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.bloom.index.use.caching"));
    }

    public boolean useBloomIndexTreebasedFilter() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.bloom.index.use.treebased.filter"));
    }

    public boolean useBloomIndexBucketizedChecking() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.bloom.index.bucketized.checking"));
    }

    public int getBloomIndexKeysPerBucket() {
        return Integer.parseInt(this.props.getProperty("hoodie.bloom.index.keys.per.bucket"));
    }

    public boolean getBloomIndexUpdatePartitionPath() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.bloom.index.update.partition.path"));
    }

    public int getSimpleIndexParallelism() {
        return Integer.parseInt(this.props.getProperty("hoodie.simple.index.parallelism"));
    }

    public boolean getSimpleIndexUseCaching() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.simple.index.use.caching"));
    }

    public int getGlobalSimpleIndexParallelism() {
        return Integer.parseInt(this.props.getProperty("hoodie.global.simple.index.parallelism"));
    }

    public boolean getGlobalSimpleIndexUpdatePartitionPath() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.simple.index.update.partition.path"));
    }

    public long getParquetMaxFileSize() {
        return Long.parseLong(this.props.getProperty("hoodie.parquet.max.file.size"));
    }

    public int getParquetBlockSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.parquet.block.size"));
    }

    public int getParquetPageSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.parquet.page.size"));
    }

    public int getLogFileDataBlockMaxSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.logfile.data.block.max.size"));
    }

    public int getLogFileMaxSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.logfile.max.size"));
    }

    public double getParquetCompressionRatio() {
        return Double.parseDouble(this.props.getProperty("hoodie.parquet.compression.ratio"));
    }

    public CompressionCodecName getParquetCompressionCodec() {
        return CompressionCodecName.fromConf((String)this.props.getProperty("hoodie.parquet.compression.codec"));
    }

    public double getLogFileToParquetCompressionRatio() {
        return Double.parseDouble(this.props.getProperty("hoodie.logfile.to.parquet.compression.ratio"));
    }

    public long getHFileMaxFileSize() {
        return Long.parseLong(this.props.getProperty("hoodie.hfile.max.file.size"));
    }

    public int getHFileBlockSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.hfile.block.size"));
    }

    public Compression.Algorithm getHFileCompressionAlgorithm() {
        return Compression.Algorithm.valueOf((String)this.props.getProperty("hoodie.hfile.compression.algorithm"));
    }

    public boolean isMetricsOn() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.metrics.on"));
    }

    public boolean isExecutorMetricsEnabled() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.metrics.executor.enable", "false"));
    }

    public MetricsReporterType getMetricsReporterType() {
        return MetricsReporterType.valueOf(this.props.getProperty("hoodie.metrics.reporter.type"));
    }

    public String getGraphiteServerHost() {
        return this.props.getProperty("hoodie.metrics.graphite.host");
    }

    public int getGraphiteServerPort() {
        return Integer.parseInt(this.props.getProperty("hoodie.metrics.graphite.port"));
    }

    public String getGraphiteMetricPrefix() {
        return this.props.getProperty("hoodie.metrics.graphite.metric.prefix");
    }

    public String getJmxHost() {
        return this.props.getProperty("hoodie.metrics.jmx.host");
    }

    public String getJmxPort() {
        return this.props.getProperty("hoodie.metrics.jmx.port");
    }

    public int getDatadogReportPeriodSeconds() {
        return Integer.parseInt(this.props.getProperty("hoodie.metrics.datadog.report.period.seconds"));
    }

    public DatadogHttpClient.ApiSite getDatadogApiSite() {
        return DatadogHttpClient.ApiSite.valueOf(this.props.getProperty("hoodie.metrics.datadog.api.site"));
    }

    public String getDatadogApiKey() {
        if (this.props.containsKey("hoodie.metrics.datadog.api.key")) {
            return this.props.getProperty("hoodie.metrics.datadog.api.key");
        }
        Supplier apiKeySupplier = (Supplier)ReflectionUtils.loadClass((String)this.props.getProperty("hoodie.metrics.datadog.api.key.supplier"));
        return (String)apiKeySupplier.get();
    }

    public boolean getDatadogApiKeySkipValidation() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.metrics.datadog.api.key.skip.validation"));
    }

    public int getDatadogApiTimeoutSeconds() {
        return Integer.parseInt(this.props.getProperty("hoodie.metrics.datadog.api.timeout.seconds"));
    }

    public String getDatadogMetricPrefix() {
        return this.props.getProperty("hoodie.metrics.datadog.metric.prefix");
    }

    public String getDatadogMetricHost() {
        return this.props.getProperty("hoodie.metrics.datadog.metric.host");
    }

    public List<String> getDatadogMetricTags() {
        return Arrays.stream(this.props.getProperty("hoodie.metrics.datadog.metric.tags", ",").split("\\s*,\\s*")).collect(Collectors.toList());
    }

    public String getMetricReporterClassName() {
        return this.props.getProperty("hoodie.metrics.reporter.class");
    }

    public int getPrometheusPort() {
        return Integer.parseInt(this.props.getProperty("hoodie.metrics.prometheus.port"));
    }

    public String getPushGatewayHost() {
        return this.props.getProperty("hoodie.metrics.pushgateway.host");
    }

    public int getPushGatewayPort() {
        return Integer.parseInt(this.props.getProperty("hoodie.metrics.pushgateway.port"));
    }

    public int getPushGatewayReportPeriodSeconds() {
        return Integer.parseInt(this.props.getProperty("hoodie.metrics.pushgateway.report.period.seconds"));
    }

    public boolean getPushGatewayDeleteOnShutdown() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.metrics.pushgateway.delete.on.shutdown"));
    }

    public String getPushGatewayJobName() {
        return this.props.getProperty("hoodie.metrics.pushgateway.job.name");
    }

    public boolean getPushGatewayRandomJobNameSuffix() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.metrics.pushgateway.random.job.name.suffix"));
    }

    public int getMaxDFSStreamBufferSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.memory.dfs.buffer.max.size"));
    }

    public String getSpillableMapBasePath() {
        return this.props.getProperty("hoodie.memory.spillable.map.path");
    }

    public double getWriteStatusFailureFraction() {
        return Double.parseDouble(this.props.getProperty("hoodie.memory.writestatus.failure.fraction"));
    }

    public ConsistencyGuardConfig getConsistencyGuardConfig() {
        return this.consistencyGuardConfig;
    }

    public void setConsistencyGuardConfig(ConsistencyGuardConfig consistencyGuardConfig) {
        this.consistencyGuardConfig = consistencyGuardConfig;
    }

    public FileSystemViewStorageConfig getViewStorageConfig() {
        return this.viewStorageConfig;
    }

    public void setViewStorageConfig(FileSystemViewStorageConfig viewStorageConfig) {
        this.viewStorageConfig = viewStorageConfig;
    }

    public void resetViewStorageConfig() {
        this.setViewStorageConfig(this.getClientSpecifiedViewStorageConfig());
    }

    public FileSystemViewStorageConfig getClientSpecifiedViewStorageConfig() {
        return this.clientSpecifiedViewStorageConfig;
    }

    public HoodiePayloadConfig getPayloadConfig() {
        return this.hoodiePayloadConfig;
    }

    public HoodieMetadataConfig getMetadataConfig() {
        return this.metadataConfig;
    }

    public boolean writeCommitCallbackOn() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.write.commit.callback.on"));
    }

    public String getCallbackClass() {
        return this.props.getProperty("hoodie.write.commit.callback.class");
    }

    public String getBootstrapSourceBasePath() {
        return this.props.getProperty("hoodie.bootstrap.base.path");
    }

    public String getBootstrapModeSelectorClass() {
        return this.props.getProperty("hoodie.bootstrap.mode.selector");
    }

    public String getFullBootstrapInputProvider() {
        return this.props.getProperty("hoodie.bootstrap.full.input.provider");
    }

    public String getBootstrapKeyGeneratorClass() {
        return this.props.getProperty("hoodie.bootstrap.keygen.class");
    }

    public String getBootstrapModeSelectorRegex() {
        return this.props.getProperty("hoodie.bootstrap.mode.selector.regex");
    }

    public BootstrapMode getBootstrapModeForRegexMatch() {
        return BootstrapMode.valueOf(this.props.getProperty("hoodie.bootstrap.mode.selector.regex.mode"));
    }

    public String getBootstrapPartitionPathTranslatorClass() {
        return this.props.getProperty("hoodie.bootstrap.partitionpath.translator.class");
    }

    public int getBootstrapParallelism() {
        return Integer.parseInt(this.props.getProperty("hoodie.bootstrap.parallelism"));
    }

    public Long getMaxMemoryPerPartitionMerge() {
        return Long.valueOf(this.props.getProperty("hoodie.memory.merge.max.size"));
    }

    public Long getHoodieClientHeartbeatIntervalInMs() {
        return Long.valueOf(this.props.getProperty(CLIENT_HEARTBEAT_INTERVAL_IN_MS_PROP));
    }

    public Integer getHoodieClientHeartbeatTolerableMisses() {
        return Integer.valueOf(this.props.getProperty(CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES_PROP));
    }

    public boolean useFileListingMetadata() {
        return this.metadataConfig.useFileListingMetadata();
    }

    public boolean getFileListingMetadataVerify() {
        return this.metadataConfig.validateFileListingMetadata();
    }

    public int getMetadataInsertParallelism() {
        return Integer.parseInt(this.props.getProperty("hoodie.metadata.insert.parallelism"));
    }

    public int getMetadataCompactDeltaCommitMax() {
        return Integer.parseInt(this.props.getProperty("hoodie.metadata.compact.max.delta.commits"));
    }

    public boolean isMetadataAsyncClean() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.metadata.clean.async"));
    }

    public int getMetadataMaxCommitsToKeep() {
        return Integer.parseInt(this.props.getProperty("hoodie.metadata.keep.max.commits"));
    }

    public int getMetadataMinCommitsToKeep() {
        return Integer.parseInt(this.props.getProperty("hoodie.metadata.keep.min.commits"));
    }

    public int getMetadataCleanerCommitsRetained() {
        return Integer.parseInt(this.props.getProperty("hoodie.metadata.cleaner.commits.retained"));
    }

    public String getLockProviderClass() {
        return this.props.getProperty("hoodie.write.lock.provider");
    }

    public String getLockHiveDatabaseName() {
        return this.props.getProperty("hoodie.write.lock.hivemetastore.database");
    }

    public String getLockHiveTableName() {
        return this.props.getProperty("hoodie.write.lock.hivemetastore.table");
    }

    public ConflictResolutionStrategy getWriteConflictResolutionStrategy() {
        return (ConflictResolutionStrategy)ReflectionUtils.loadClass((String)this.props.getProperty("hoodie.write.lock.conflict.resolution.strategy"));
    }

    public Long getLockAcquireWaitTimeoutInMs() {
        return Long.valueOf(this.props.getProperty("hoodie.write.lock.wait_time_ms"));
    }

    public WriteConcurrencyMode getWriteConcurrencyMode() {
        return WriteConcurrencyMode.fromValue((String)this.props.getProperty(WRITE_CONCURRENCY_MODE_PROP));
    }

    public Boolean inlineTableServices() {
        return this.inlineClusteringEnabled() || this.inlineCompactionEnabled() || this.isAutoClean();
    }

    public String getWriteMetaKeyPrefixes() {
        return this.props.getProperty(WRITE_META_KEY_PREFIXES_PROP);
    }

    public static class Builder {
        protected final Properties props = new Properties();
        protected EngineType engineType = EngineType.SPARK;
        private boolean isIndexConfigSet = false;
        private boolean isStorageConfigSet = false;
        private boolean isCompactionConfigSet = false;
        private boolean isClusteringConfigSet = false;
        private boolean isMetricsConfigSet = false;
        private boolean isBootstrapConfigSet = false;
        private boolean isMemoryConfigSet = false;
        private boolean isViewConfigSet = false;
        private boolean isConsistencyGuardSet = false;
        private boolean isCallbackConfigSet = false;
        private boolean isPayloadConfigSet = false;
        private boolean isMetadataConfigSet = false;
        private boolean isLockConfigSet = false;

        public Builder withEngineType(EngineType engineType) {
            this.engineType = engineType;
            return this;
        }

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromInputStream(InputStream inputStream) throws IOException {
            try {
                this.props.load(inputStream);
                Builder builder = this;
                return builder;
            }
            finally {
                inputStream.close();
            }
        }

        public Builder withProps(Map kvprops) {
            this.props.putAll((Map<?, ?>)kvprops);
            return this;
        }

        public Builder withPath(String basePath) {
            this.props.setProperty(HoodieWriteConfig.BASE_PATH_PROP, basePath);
            return this;
        }

        public Builder withSchema(String schemaStr) {
            this.props.setProperty(HoodieWriteConfig.AVRO_SCHEMA, schemaStr);
            return this;
        }

        public Builder withAvroSchemaValidate(boolean enable) {
            this.props.setProperty(HoodieWriteConfig.AVRO_SCHEMA_VALIDATE, String.valueOf(enable));
            return this;
        }

        public Builder forTable(String tableName) {
            this.props.setProperty(HoodieWriteConfig.TABLE_NAME, tableName);
            return this;
        }

        public Builder withPreCombineField(String preCombineField) {
            this.props.setProperty(HoodieWriteConfig.PRECOMBINE_FIELD_PROP, preCombineField);
            return this;
        }

        public Builder withWritePayLoad(String payload) {
            this.props.setProperty(HoodieWriteConfig.WRITE_PAYLOAD_CLASS, payload);
            return this;
        }

        public Builder withKeyGenerator(String keyGeneratorClass) {
            this.props.setProperty(HoodieWriteConfig.KEYGENERATOR_CLASS_PROP, keyGeneratorClass);
            return this;
        }

        public Builder withTimelineLayoutVersion(int version) {
            this.props.setProperty(HoodieWriteConfig.TIMELINE_LAYOUT_VERSION, String.valueOf(version));
            return this;
        }

        public Builder withBulkInsertParallelism(int bulkInsertParallelism) {
            this.props.setProperty(HoodieWriteConfig.BULKINSERT_PARALLELISM, String.valueOf(bulkInsertParallelism));
            return this;
        }

        public Builder withUserDefinedBulkInsertPartitionerClass(String className) {
            this.props.setProperty(HoodieWriteConfig.BULKINSERT_USER_DEFINED_PARTITIONER_CLASS, className);
            return this;
        }

        public Builder withDeleteParallelism(int parallelism) {
            this.props.setProperty(HoodieWriteConfig.DELETE_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withParallelism(int insertShuffleParallelism, int upsertShuffleParallelism) {
            this.props.setProperty(HoodieWriteConfig.INSERT_PARALLELISM, String.valueOf(insertShuffleParallelism));
            this.props.setProperty(HoodieWriteConfig.UPSERT_PARALLELISM, String.valueOf(upsertShuffleParallelism));
            return this;
        }

        public Builder withRollbackParallelism(int rollbackParallelism) {
            this.props.setProperty(HoodieWriteConfig.ROLLBACK_PARALLELISM, String.valueOf(rollbackParallelism));
            return this;
        }

        public Builder withRollbackUsingMarkers(boolean rollbackUsingMarkers) {
            this.props.setProperty(HoodieWriteConfig.ROLLBACK_USING_MARKERS, String.valueOf(rollbackUsingMarkers));
            return this;
        }

        public Builder withWriteBufferLimitBytes(int writeBufferLimit) {
            this.props.setProperty(HoodieWriteConfig.WRITE_BUFFER_LIMIT_BYTES, String.valueOf(writeBufferLimit));
            return this;
        }

        public Builder combineInput(boolean onInsert, boolean onUpsert) {
            this.props.setProperty(HoodieWriteConfig.COMBINE_BEFORE_INSERT_PROP, String.valueOf(onInsert));
            this.props.setProperty(HoodieWriteConfig.COMBINE_BEFORE_UPSERT_PROP, String.valueOf(onUpsert));
            return this;
        }

        public Builder combineDeleteInput(boolean onDelete) {
            this.props.setProperty(HoodieWriteConfig.COMBINE_BEFORE_DELETE_PROP, String.valueOf(onDelete));
            return this;
        }

        public Builder withWriteStatusStorageLevel(String level) {
            this.props.setProperty(HoodieWriteConfig.WRITE_STATUS_STORAGE_LEVEL, level);
            return this;
        }

        public Builder withIndexConfig(HoodieIndexConfig indexConfig) {
            this.props.putAll((Map<?, ?>)indexConfig.getProps());
            this.isIndexConfigSet = true;
            return this;
        }

        public Builder withStorageConfig(HoodieStorageConfig storageConfig) {
            this.props.putAll((Map<?, ?>)storageConfig.getProps());
            this.isStorageConfigSet = true;
            return this;
        }

        public Builder withCompactionConfig(HoodieCompactionConfig compactionConfig) {
            this.props.putAll((Map<?, ?>)compactionConfig.getProps());
            this.isCompactionConfigSet = true;
            return this;
        }

        public Builder withClusteringConfig(HoodieClusteringConfig clusteringConfig) {
            this.props.putAll((Map<?, ?>)clusteringConfig.getProps());
            this.isClusteringConfigSet = true;
            return this;
        }

        public Builder withLockConfig(HoodieLockConfig lockConfig) {
            this.props.putAll((Map<?, ?>)lockConfig.getProps());
            this.isLockConfigSet = true;
            return this;
        }

        public Builder withMetricsConfig(HoodieMetricsConfig metricsConfig) {
            this.props.putAll((Map<?, ?>)metricsConfig.getProps());
            this.isMetricsConfigSet = true;
            return this;
        }

        public Builder withMemoryConfig(HoodieMemoryConfig memoryConfig) {
            this.props.putAll((Map<?, ?>)memoryConfig.getProps());
            this.isMemoryConfigSet = true;
            return this;
        }

        public Builder withBootstrapConfig(HoodieBootstrapConfig bootstrapConfig) {
            this.props.putAll((Map<?, ?>)bootstrapConfig.getProps());
            this.isBootstrapConfigSet = true;
            return this;
        }

        public Builder withPayloadConfig(HoodiePayloadConfig payloadConfig) {
            this.props.putAll((Map<?, ?>)payloadConfig.getProps());
            this.isPayloadConfigSet = true;
            return this;
        }

        public Builder withMetadataConfig(HoodieMetadataConfig metadataConfig) {
            this.props.putAll((Map<?, ?>)metadataConfig.getProps());
            this.isMetadataConfigSet = true;
            return this;
        }

        public Builder withAutoCommit(boolean autoCommit) {
            this.props.setProperty(HoodieWriteConfig.HOODIE_AUTO_COMMIT_PROP, String.valueOf(autoCommit));
            return this;
        }

        public Builder withWriteStatusClass(Class<? extends WriteStatus> writeStatusClass) {
            this.props.setProperty(HoodieWriteConfig.HOODIE_WRITE_STATUS_CLASS_PROP, writeStatusClass.getName());
            return this;
        }

        public Builder withFileSystemViewConfig(FileSystemViewStorageConfig viewStorageConfig) {
            this.props.putAll((Map<?, ?>)viewStorageConfig.getProps());
            this.isViewConfigSet = true;
            return this;
        }

        public Builder withConsistencyGuardConfig(ConsistencyGuardConfig consistencyGuardConfig) {
            this.props.putAll((Map<?, ?>)consistencyGuardConfig.getProps());
            this.isConsistencyGuardSet = true;
            return this;
        }

        public Builder withCallbackConfig(HoodieWriteCommitCallbackConfig callbackConfig) {
            this.props.putAll((Map<?, ?>)callbackConfig.getProps());
            this.isCallbackConfigSet = true;
            return this;
        }

        public Builder withFinalizeWriteParallelism(int parallelism) {
            this.props.setProperty(HoodieWriteConfig.FINALIZE_WRITE_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withMarkersDeleteParallelism(int parallelism) {
            this.props.setProperty(HoodieWriteConfig.MARKERS_DELETE_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withEmbeddedTimelineServerEnabled(boolean enabled) {
            this.props.setProperty(HoodieWriteConfig.EMBEDDED_TIMELINE_SERVER_ENABLED, String.valueOf(enabled));
            return this;
        }

        public Builder withEmbeddedTimelineServerPort(int port) {
            this.props.setProperty(HoodieWriteConfig.EMBEDDED_TIMELINE_SERVER_PORT, String.valueOf(port));
            return this;
        }

        public Builder withBulkInsertSortMode(String mode) {
            this.props.setProperty(HoodieWriteConfig.BULKINSERT_SORT_MODE, mode);
            return this;
        }

        public Builder withAllowMultiWriteOnSameInstant(boolean allow) {
            this.props.setProperty(HoodieWriteConfig.ALLOW_MULTI_WRITE_ON_SAME_INSTANT, String.valueOf(allow));
            return this;
        }

        public Builder withExternalSchemaTrasformation(boolean enabled) {
            this.props.setProperty(HoodieWriteConfig.EXTERNAL_RECORD_AND_SCHEMA_TRANSFORMATION, String.valueOf(enabled));
            return this;
        }

        public Builder withMergeDataValidationCheckEnabled(boolean enabled) {
            this.props.setProperty(HoodieWriteConfig.MERGE_DATA_VALIDATION_CHECK_ENABLED, String.valueOf(enabled));
            return this;
        }

        public Builder withMergeAllowDuplicateOnInserts(boolean routeInsertsToNewFiles) {
            this.props.setProperty(HoodieWriteConfig.MERGE_ALLOW_DUPLICATE_ON_INSERTS, String.valueOf(routeInsertsToNewFiles));
            return this;
        }

        public Builder withHeartbeatIntervalInMs(Integer heartbeatIntervalInMs) {
            this.props.setProperty(HoodieWriteConfig.CLIENT_HEARTBEAT_INTERVAL_IN_MS_PROP, String.valueOf(heartbeatIntervalInMs));
            return this;
        }

        public Builder withHeartbeatTolerableMisses(Integer heartbeatTolerableMisses) {
            this.props.setProperty(HoodieWriteConfig.CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES_PROP, String.valueOf(heartbeatTolerableMisses));
            return this;
        }

        public Builder withWriteConcurrencyMode(WriteConcurrencyMode concurrencyMode) {
            this.props.setProperty(HoodieWriteConfig.WRITE_CONCURRENCY_MODE_PROP, concurrencyMode.value());
            return this;
        }

        public Builder withWriteMetaKeyPrefixes(String writeMetaKeyPrefixes) {
            this.props.setProperty(HoodieWriteConfig.WRITE_META_KEY_PREFIXES_PROP, writeMetaKeyPrefixes);
            return this;
        }

        public Builder withProperties(Properties properties) {
            this.props.putAll((Map<?, ?>)properties);
            return this;
        }

        protected void setDefaults() {
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.INSERT_PARALLELISM) ? 1 : 0) != 0, (String)HoodieWriteConfig.INSERT_PARALLELISM, (String)"1500");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.BULKINSERT_PARALLELISM) ? 1 : 0) != 0, (String)HoodieWriteConfig.BULKINSERT_PARALLELISM, (String)"1500");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.UPSERT_PARALLELISM) ? 1 : 0) != 0, (String)HoodieWriteConfig.UPSERT_PARALLELISM, (String)"1500");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.DELETE_PARALLELISM) ? 1 : 0) != 0, (String)HoodieWriteConfig.DELETE_PARALLELISM, (String)"1500");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.ROLLBACK_PARALLELISM) ? 1 : 0) != 0, (String)HoodieWriteConfig.ROLLBACK_PARALLELISM, (String)"100");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.KEYGENERATOR_CLASS_PROP) ? 1 : 0) != 0, (String)HoodieWriteConfig.KEYGENERATOR_CLASS_PROP, (String)DEFAULT_KEYGENERATOR_CLASS);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.WRITE_PAYLOAD_CLASS) ? 1 : 0) != 0, (String)HoodieWriteConfig.WRITE_PAYLOAD_CLASS, (String)DEFAULT_WRITE_PAYLOAD_CLASS);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.ROLLBACK_USING_MARKERS) ? 1 : 0) != 0, (String)HoodieWriteConfig.ROLLBACK_USING_MARKERS, (String)"false");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.COMBINE_BEFORE_INSERT_PROP) ? 1 : 0) != 0, (String)HoodieWriteConfig.COMBINE_BEFORE_INSERT_PROP, (String)"false");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.COMBINE_BEFORE_UPSERT_PROP) ? 1 : 0) != 0, (String)HoodieWriteConfig.COMBINE_BEFORE_UPSERT_PROP, (String)"true");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.COMBINE_BEFORE_DELETE_PROP) ? 1 : 0) != 0, (String)HoodieWriteConfig.COMBINE_BEFORE_DELETE_PROP, (String)"true");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.ALLOW_MULTI_WRITE_ON_SAME_INSTANT) ? 1 : 0) != 0, (String)HoodieWriteConfig.ALLOW_MULTI_WRITE_ON_SAME_INSTANT, (String)"false");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.WRITE_STATUS_STORAGE_LEVEL) ? 1 : 0) != 0, (String)HoodieWriteConfig.WRITE_STATUS_STORAGE_LEVEL, (String)HoodieWriteConfig.DEFAULT_WRITE_STATUS_STORAGE_LEVEL);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.HOODIE_AUTO_COMMIT_PROP) ? 1 : 0) != 0, (String)HoodieWriteConfig.HOODIE_AUTO_COMMIT_PROP, (String)"true");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.HOODIE_WRITE_STATUS_CLASS_PROP) ? 1 : 0) != 0, (String)HoodieWriteConfig.HOODIE_WRITE_STATUS_CLASS_PROP, (String)DEFAULT_HOODIE_WRITE_STATUS_CLASS);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.FINALIZE_WRITE_PARALLELISM) ? 1 : 0) != 0, (String)HoodieWriteConfig.FINALIZE_WRITE_PARALLELISM, (String)"1500");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.MARKERS_DELETE_PARALLELISM) ? 1 : 0) != 0, (String)HoodieWriteConfig.MARKERS_DELETE_PARALLELISM, (String)"100");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.EMBEDDED_TIMELINE_SERVER_ENABLED) ? 1 : 0) != 0, (String)HoodieWriteConfig.EMBEDDED_TIMELINE_SERVER_ENABLED, (String)"true");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP) ? 1 : 0) != 0, (String)HoodieWriteConfig.INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP, (String)String.valueOf(DEFAULT_INITIAL_CONSISTENCY_CHECK_INTERVAL_MS));
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP) ? 1 : 0) != 0, (String)HoodieWriteConfig.MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP, (String)String.valueOf(DEFAULT_MAX_CONSISTENCY_CHECK_INTERVAL_MS));
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.MAX_CONSISTENCY_CHECKS_PROP) ? 1 : 0) != 0, (String)HoodieWriteConfig.MAX_CONSISTENCY_CHECKS_PROP, (String)String.valueOf(DEFAULT_MAX_CONSISTENCY_CHECKS));
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.FAIL_ON_TIMELINE_ARCHIVING_ENABLED_PROP) ? 1 : 0) != 0, (String)HoodieWriteConfig.FAIL_ON_TIMELINE_ARCHIVING_ENABLED_PROP, (String)"true");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.AVRO_SCHEMA_VALIDATE) ? 1 : 0) != 0, (String)HoodieWriteConfig.AVRO_SCHEMA_VALIDATE, (String)"false");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.BULKINSERT_SORT_MODE) ? 1 : 0) != 0, (String)HoodieWriteConfig.BULKINSERT_SORT_MODE, (String)DEFAULT_BULKINSERT_SORT_MODE);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.MERGE_DATA_VALIDATION_CHECK_ENABLED) ? 1 : 0) != 0, (String)HoodieWriteConfig.MERGE_DATA_VALIDATION_CHECK_ENABLED, (String)"false");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.MERGE_ALLOW_DUPLICATE_ON_INSERTS) ? 1 : 0) != 0, (String)HoodieWriteConfig.MERGE_ALLOW_DUPLICATE_ON_INSERTS, (String)"false");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.CLIENT_HEARTBEAT_INTERVAL_IN_MS_PROP) ? 1 : 0) != 0, (String)HoodieWriteConfig.CLIENT_HEARTBEAT_INTERVAL_IN_MS_PROP, (String)String.valueOf(DEFAULT_CLIENT_HEARTBEAT_INTERVAL_IN_MS));
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES_PROP) ? 1 : 0) != 0, (String)HoodieWriteConfig.CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES_PROP, (String)String.valueOf(DEFAULT_CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES));
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.WRITE_CONCURRENCY_MODE_PROP) ? 1 : 0) != 0, (String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE_PROP, (String)DEFAULT_WRITE_CONCURRENCY_MODE);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.WRITE_META_KEY_PREFIXES_PROP) ? 1 : 0) != 0, (String)HoodieWriteConfig.WRITE_META_KEY_PREFIXES_PROP, (String)HoodieWriteConfig.DEFAULT_WRITE_META_KEY_PREFIXES);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.isIndexConfigSet ? 1 : 0) != 0, (DefaultHoodieConfig)HoodieIndexConfig.newBuilder().withEngineType(this.engineType).fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.isStorageConfigSet ? 1 : 0) != 0, (DefaultHoodieConfig)HoodieStorageConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.isCompactionConfigSet ? 1 : 0) != 0, (DefaultHoodieConfig)HoodieCompactionConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.isClusteringConfigSet ? 1 : 0) != 0, (DefaultHoodieConfig)HoodieClusteringConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.isMetricsConfigSet ? 1 : 0) != 0, (DefaultHoodieConfig)HoodieMetricsConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.isBootstrapConfigSet ? 1 : 0) != 0, (DefaultHoodieConfig)HoodieBootstrapConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.isMemoryConfigSet ? 1 : 0) != 0, (DefaultHoodieConfig)HoodieMemoryConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.isViewConfigSet ? 1 : 0) != 0, (DefaultHoodieConfig)FileSystemViewStorageConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.isConsistencyGuardSet ? 1 : 0) != 0, (DefaultHoodieConfig)ConsistencyGuardConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.isCallbackConfigSet ? 1 : 0) != 0, (DefaultHoodieConfig)HoodieWriteCommitCallbackConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.isPayloadConfigSet ? 1 : 0) != 0, (DefaultHoodieConfig)HoodiePayloadConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.isMetadataConfigSet ? 1 : 0) != 0, (DefaultHoodieConfig)HoodieMetadataConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.isLockConfigSet ? 1 : 0) != 0, (DefaultHoodieConfig)HoodieLockConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.EXTERNAL_RECORD_AND_SCHEMA_TRANSFORMATION) ? 1 : 0) != 0, (String)HoodieWriteConfig.EXTERNAL_RECORD_AND_SCHEMA_TRANSFORMATION, (String)"false");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieWriteConfig.TIMELINE_LAYOUT_VERSION) ? 1 : 0) != 0, (String)HoodieWriteConfig.TIMELINE_LAYOUT_VERSION, (String)String.valueOf(TimelineLayoutVersion.CURR_VERSION));
        }

        private void validate() {
            String layoutVersion = this.props.getProperty(HoodieWriteConfig.TIMELINE_LAYOUT_VERSION);
            new TimelineLayoutVersion(Integer.valueOf(Integer.parseInt(layoutVersion)));
            Objects.requireNonNull(this.props.getProperty(HoodieWriteConfig.BASE_PATH_PROP));
            if (this.props.getProperty(HoodieWriteConfig.WRITE_CONCURRENCY_MODE_PROP).equalsIgnoreCase(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.name())) {
                ValidationUtils.checkArgument((this.props.getProperty("hoodie.cleaner.policy.failed.writes") != HoodieFailedWritesCleaningPolicy.EAGER.name() ? 1 : 0) != 0, (String)"To enable optimistic concurrency control, set hoodie.cleaner.policy.failed.writes=LAZY");
            }
        }

        public HoodieWriteConfig build() {
            this.setDefaults();
            this.validate();
            HoodieWriteConfig config = new HoodieWriteConfig(this.engineType, this.props);
            return config;
        }
    }
}

