/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.DefaultHoodieConfig;

@Immutable
public class HoodieMetricsDatadogConfig
extends DefaultHoodieConfig {
    public static final String DATADOG_PREFIX = "hoodie.metrics.datadog";
    public static final String DATADOG_REPORT_PERIOD_SECONDS = "hoodie.metrics.datadog.report.period.seconds";
    public static final int DEFAULT_DATADOG_REPORT_PERIOD_SECONDS = 30;
    public static final String DATADOG_API_SITE = "hoodie.metrics.datadog.api.site";
    public static final String DATADOG_API_KEY = "hoodie.metrics.datadog.api.key";
    public static final String DATADOG_API_KEY_SKIP_VALIDATION = "hoodie.metrics.datadog.api.key.skip.validation";
    public static final boolean DEFAULT_DATADOG_API_KEY_SKIP_VALIDATION = false;
    public static final String DATADOG_API_KEY_SUPPLIER = "hoodie.metrics.datadog.api.key.supplier";
    public static final String DATADOG_API_TIMEOUT_SECONDS = "hoodie.metrics.datadog.api.timeout.seconds";
    public static final int DEFAULT_DATADOG_API_TIMEOUT_SECONDS = 3;
    public static final String DATADOG_METRIC_PREFIX = "hoodie.metrics.datadog.metric.prefix";
    public static final String DATADOG_METRIC_HOST = "hoodie.metrics.datadog.metric.host";
    public static final String DATADOG_METRIC_TAGS = "hoodie.metrics.datadog.metric.tags";

    private HoodieMetricsDatadogConfig(Properties props) {
        super(props);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Properties props = new Properties();

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withDatadogReportPeriodSeconds(int period) {
            this.props.setProperty(HoodieMetricsDatadogConfig.DATADOG_REPORT_PERIOD_SECONDS, String.valueOf(period));
            return this;
        }

        public Builder withDatadogApiSite(String apiSite) {
            this.props.setProperty(HoodieMetricsDatadogConfig.DATADOG_API_SITE, apiSite);
            return this;
        }

        public Builder withDatadogApiKey(String apiKey) {
            this.props.setProperty(HoodieMetricsDatadogConfig.DATADOG_API_KEY, apiKey);
            return this;
        }

        public Builder withDatadogApiKeySkipValidation(boolean skip) {
            this.props.setProperty(HoodieMetricsDatadogConfig.DATADOG_API_KEY_SKIP_VALIDATION, String.valueOf(skip));
            return this;
        }

        public Builder withDatadogApiKeySupplier(String apiKeySupplier) {
            this.props.setProperty(HoodieMetricsDatadogConfig.DATADOG_API_KEY_SUPPLIER, apiKeySupplier);
            return this;
        }

        public Builder withDatadogApiTimeoutSeconds(int timeout) {
            this.props.setProperty(HoodieMetricsDatadogConfig.DATADOG_API_TIMEOUT_SECONDS, String.valueOf(timeout));
            return this;
        }

        public Builder withDatadogPrefix(String prefix) {
            this.props.setProperty(HoodieMetricsDatadogConfig.DATADOG_METRIC_PREFIX, prefix);
            return this;
        }

        public Builder withDatadogHost(String host) {
            this.props.setProperty(HoodieMetricsDatadogConfig.DATADOG_METRIC_HOST, host);
            return this;
        }

        public Builder withDatadogTags(String tags) {
            this.props.setProperty(HoodieMetricsDatadogConfig.DATADOG_METRIC_TAGS, tags);
            return this;
        }

        public HoodieMetricsDatadogConfig build() {
            HoodieMetricsDatadogConfig config = new HoodieMetricsDatadogConfig(this.props);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieMetricsDatadogConfig.DATADOG_REPORT_PERIOD_SECONDS) ? 1 : 0) != 0, (String)HoodieMetricsDatadogConfig.DATADOG_REPORT_PERIOD_SECONDS, (String)String.valueOf(30));
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieMetricsDatadogConfig.DATADOG_API_KEY_SKIP_VALIDATION) ? 1 : 0) != 0, (String)HoodieMetricsDatadogConfig.DATADOG_API_KEY_SKIP_VALIDATION, (String)String.valueOf(false));
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieMetricsDatadogConfig.DATADOG_API_TIMEOUT_SECONDS) ? 1 : 0) != 0, (String)HoodieMetricsDatadogConfig.DATADOG_API_TIMEOUT_SECONDS, (String)String.valueOf(3));
            return config;
        }
    }
}

