/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.client.ReplaceArchivalHelper;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CompactionUtils;

public class MetadataConversionUtils {
    public static HoodieArchivedMetaEntry createMetaWrapper(HoodieInstant hoodieInstant, HoodieTableMetaClient metaClient) throws IOException {
        HoodieArchivedMetaEntry archivedMetaWrapper = new HoodieArchivedMetaEntry();
        archivedMetaWrapper.setCommitTime(hoodieInstant.getTimestamp());
        archivedMetaWrapper.setActionState(hoodieInstant.getState().name());
        switch (hoodieInstant.getAction()) {
            case "clean": {
                if (hoodieInstant.isCompleted()) {
                    archivedMetaWrapper.setHoodieCleanMetadata(CleanerUtils.getCleanerMetadata((HoodieTableMetaClient)metaClient, (HoodieInstant)hoodieInstant));
                } else {
                    archivedMetaWrapper.setHoodieCleanerPlan(CleanerUtils.getCleanerPlan((HoodieTableMetaClient)metaClient, (HoodieInstant)hoodieInstant));
                }
                archivedMetaWrapper.setActionType(ActionType.clean.name());
                break;
            }
            case "commit": 
            case "deltacommit": {
                org.apache.hudi.common.model.HoodieCommitMetadata commitMetadata = (org.apache.hudi.common.model.HoodieCommitMetadata)org.apache.hudi.common.model.HoodieCommitMetadata.fromBytes((byte[])((byte[])metaClient.getActiveTimeline().getInstantDetails(hoodieInstant).get()), org.apache.hudi.common.model.HoodieCommitMetadata.class);
                archivedMetaWrapper.setHoodieCommitMetadata(MetadataConversionUtils.convertCommitMetadata(commitMetadata));
                archivedMetaWrapper.setActionType(ActionType.commit.name());
                break;
            }
            case "replacecommit": {
                if (hoodieInstant.isCompleted()) {
                    HoodieReplaceCommitMetadata replaceCommitMetadata = (HoodieReplaceCommitMetadata)HoodieReplaceCommitMetadata.fromBytes((byte[])((byte[])metaClient.getActiveTimeline().getInstantDetails(hoodieInstant).get()), HoodieReplaceCommitMetadata.class);
                    archivedMetaWrapper.setHoodieReplaceCommitMetadata(ReplaceArchivalHelper.convertReplaceCommitMetadata(replaceCommitMetadata));
                } else {
                    HoodieRequestedReplaceMetadata requestedReplaceMetadata = (HoodieRequestedReplaceMetadata)ClusteringUtils.getRequestedReplaceMetadata((HoodieTableMetaClient)metaClient, (HoodieInstant)hoodieInstant).get();
                    archivedMetaWrapper.setHoodieRequestedReplaceMetadata(requestedReplaceMetadata);
                }
                archivedMetaWrapper.setActionType(ActionType.replacecommit.name());
                break;
            }
            case "rollback": {
                archivedMetaWrapper.setHoodieRollbackMetadata((HoodieRollbackMetadata)TimelineMetadataUtils.deserializeAvroMetadata((byte[])((byte[])metaClient.getActiveTimeline().getInstantDetails(hoodieInstant).get()), HoodieRollbackMetadata.class));
                archivedMetaWrapper.setActionType(ActionType.rollback.name());
                break;
            }
            case "savepoint": {
                archivedMetaWrapper.setHoodieSavePointMetadata((HoodieSavepointMetadata)TimelineMetadataUtils.deserializeAvroMetadata((byte[])((byte[])metaClient.getActiveTimeline().getInstantDetails(hoodieInstant).get()), HoodieSavepointMetadata.class));
                archivedMetaWrapper.setActionType(ActionType.savepoint.name());
                break;
            }
            case "compaction": {
                HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan((HoodieTableMetaClient)metaClient, (String)hoodieInstant.getTimestamp());
                archivedMetaWrapper.setHoodieCompactionPlan(plan);
                archivedMetaWrapper.setActionType(ActionType.compaction.name());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Action not fully supported yet");
            }
        }
        return archivedMetaWrapper;
    }

    public static HoodieArchivedMetaEntry createMetaWrapper(HoodieInstant hoodieInstant, org.apache.hudi.common.model.HoodieCommitMetadata hoodieCommitMetadata) {
        HoodieArchivedMetaEntry archivedMetaWrapper = new HoodieArchivedMetaEntry();
        archivedMetaWrapper.setCommitTime(hoodieInstant.getTimestamp());
        archivedMetaWrapper.setActionState(hoodieInstant.getState().name());
        archivedMetaWrapper.setHoodieCommitMetadata(MetadataConversionUtils.convertCommitMetadata(hoodieCommitMetadata));
        archivedMetaWrapper.setActionType(ActionType.commit.name());
        return archivedMetaWrapper;
    }

    public static HoodieCommitMetadata convertCommitMetadata(org.apache.hudi.common.model.HoodieCommitMetadata hoodieCommitMetadata) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        HoodieCommitMetadata avroMetaData = (HoodieCommitMetadata)mapper.convertValue((Object)hoodieCommitMetadata, HoodieCommitMetadata.class);
        if (hoodieCommitMetadata.getCompacted().booleanValue()) {
            avroMetaData.setOperationType(WriteOperationType.COMPACT.name());
        }
        avroMetaData.getExtraMetadata().put("ROLLING_STAT", "");
        return avroMetaData;
    }
}

