/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.embedded;

import java.io.IOException;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class EmbeddedTimelineServerHelper {
    private static final Logger LOG = LogManager.getLogger(EmbeddedTimelineService.class);

    public static Option<EmbeddedTimelineService> createEmbeddedTimelineService(HoodieEngineContext context, HoodieWriteConfig config) throws IOException {
        Option timelineServer = Option.empty();
        if (config.isEmbeddedTimelineServerEnabled()) {
            LOG.info((Object)"Starting Timeline service !!");
            Option hostAddr = context.getProperty(EngineProperty.EMBEDDED_SERVER_HOST);
            timelineServer = Option.of((Object)new EmbeddedTimelineService(context, (String)hostAddr.orElse(null), config.getEmbeddedTimelineServerPort(), config.getMetadataConfig(), config.getClientSpecifiedViewStorageConfig(), config.getBasePath(), config.getEmbeddedTimelineServerThreads(), config.getEmbeddedTimelineServerCompressOutput(), config.getEmbeddedTimelineServerUseAsync()));
            ((EmbeddedTimelineService)timelineServer.get()).startServer();
            EmbeddedTimelineServerHelper.updateWriteConfigWithTimelineServer((EmbeddedTimelineService)timelineServer.get(), config);
        }
        return timelineServer;
    }

    public static void updateWriteConfigWithTimelineServer(EmbeddedTimelineService timelineServer, HoodieWriteConfig config) {
        if (config.isEmbeddedTimelineServerEnabled()) {
            config.setViewStorageConfig(timelineServer.getRemoteFileSystemViewConfig());
        }
    }
}

