/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackActionExecutor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseMergeOnReadRollbackActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseRollbackActionExecutor<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(BaseMergeOnReadRollbackActionExecutor.class);

    public BaseMergeOnReadRollbackActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, HoodieInstant commitInstant, boolean deleteInstants) {
        super(context, config, table, instantTime, commitInstant, deleteInstants);
    }

    public BaseMergeOnReadRollbackActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, HoodieInstant commitInstant, boolean deleteInstants, boolean skipTimelinePublish, boolean useMarkerBasedStrategy) {
        super(context, config, table, instantTime, commitInstant, deleteInstants, skipTimelinePublish, useMarkerBasedStrategy);
    }

    @Override
    protected List<HoodieRollbackStat> executeRollback() {
        HoodieTimer rollbackTimer = new HoodieTimer();
        rollbackTimer.startTimer();
        LOG.info((Object)("Rolling back instant " + this.instantToRollback));
        HoodieInstant resolvedInstant = this.instantToRollback;
        if (this.instantToRollback.isCompleted()) {
            LOG.info((Object)("Un-publishing instant " + this.instantToRollback + ", deleteInstants=" + this.deleteInstants));
            resolvedInstant = this.table.getActiveTimeline().revertToInflight(this.instantToRollback);
            this.table.getMetaClient().reloadActiveTimeline();
        }
        ArrayList<HoodieRollbackStat> allRollbackStats = new ArrayList();
        if (!resolvedInstant.isRequested()) {
            LOG.info((Object)("Unpublished " + resolvedInstant));
            allRollbackStats = this.getRollbackStrategy().execute(resolvedInstant);
        }
        this.dropBootstrapIndexIfNeeded(resolvedInstant);
        this.deleteInflightAndRequestedInstant(this.deleteInstants, this.table.getActiveTimeline(), resolvedInstant);
        LOG.info((Object)("Time(in ms) taken to finish rollback " + rollbackTimer.endTimer()));
        return allRollbackStats;
    }
}

