/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster.strategy;

import java.io.Serializable;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class ClusteringExecutionStrategy<T extends HoodieRecordPayload, I, K, O>
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(ClusteringExecutionStrategy.class);
    private final HoodieTable<T, I, K, O> hoodieTable;
    private final HoodieEngineContext engineContext;
    private final HoodieWriteConfig writeConfig;

    public ClusteringExecutionStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        this.writeConfig = writeConfig;
        this.hoodieTable = table;
        this.engineContext = engineContext;
    }

    public abstract O performClustering(I var1, int var2, String var3, Map<String, String> var4, Schema var5);

    protected HoodieTable<T, I, K, O> getHoodieTable() {
        return this.hoodieTable;
    }

    protected HoodieEngineContext getEngineContext() {
        return this.engineContext;
    }

    protected HoodieWriteConfig getWriteConfig() {
        return this.writeConfig;
    }
}

