/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;

public abstract class BaseClusteringPlanActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseActionExecutor<T, I, K, O, Option<HoodieClusteringPlan>> {
    private final Option<Map<String, String>> extraMetadata;

    public BaseClusteringPlanActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, Option<Map<String, String>> extraMetadata) {
        super(context, config, table, instantTime);
        this.extraMetadata = extraMetadata;
    }

    protected abstract Option<HoodieClusteringPlan> createClusteringPlan();

    @Override
    public Option<HoodieClusteringPlan> execute() {
        Option<HoodieClusteringPlan> planOption = this.createClusteringPlan();
        if (planOption.isPresent()) {
            HoodieInstant clusteringInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "replacecommit", this.instantTime);
            try {
                HoodieRequestedReplaceMetadata requestedReplaceMetadata = HoodieRequestedReplaceMetadata.newBuilder().setOperationType(WriteOperationType.CLUSTER.name()).setExtraMetadata((Map)this.extraMetadata.orElse(Collections.emptyMap())).setClusteringPlan((HoodieClusteringPlan)planOption.get()).build();
                this.table.getActiveTimeline().saveToPendingReplaceCommit(clusteringInstant, TimelineMetadataUtils.serializeRequestedReplaceMetadata((HoodieRequestedReplaceMetadata)requestedReplaceMetadata));
            }
            catch (IOException ioe) {
                throw new HoodieIOException("Exception scheduling clustering", ioe);
            }
        }
        return planOption;
    }
}

