/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.keygen.parser.AbstractHoodieDateTimeParser;

public class KeyGenUtils {
    protected static final String NULL_RECORDKEY_PLACEHOLDER = "__null__";
    protected static final String EMPTY_RECORDKEY_PLACEHOLDER = "__empty__";
    protected static final String DEFAULT_PARTITION_PATH = "default";
    protected static final String DEFAULT_PARTITION_PATH_SEPARATOR = "/";

    public static String getRecordKey(GenericRecord record, List<String> recordKeyFields) {
        boolean keyIsNullEmpty = true;
        StringBuilder recordKey = new StringBuilder();
        for (String recordKeyField : recordKeyFields) {
            String recordKeyValue = HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)recordKeyField, (boolean)true);
            if (recordKeyValue == null) {
                recordKey.append(recordKeyField + ":" + NULL_RECORDKEY_PLACEHOLDER + ",");
                continue;
            }
            if (recordKeyValue.isEmpty()) {
                recordKey.append(recordKeyField + ":" + EMPTY_RECORDKEY_PLACEHOLDER + ",");
                continue;
            }
            recordKey.append(recordKeyField + ":" + recordKeyValue + ",");
            keyIsNullEmpty = false;
        }
        recordKey.deleteCharAt(recordKey.length() - 1);
        if (keyIsNullEmpty) {
            throw new HoodieKeyException("recordKey values: \"" + recordKey + "\" for fields: " + recordKeyFields.toString() + " cannot be entirely null or empty.");
        }
        return recordKey.toString();
    }

    public static String getRecordPartitionPath(GenericRecord record, List<String> partitionPathFields, boolean hiveStylePartitioning, boolean encodePartitionPath) {
        if (partitionPathFields.isEmpty()) {
            return "";
        }
        StringBuilder partitionPath = new StringBuilder();
        for (String partitionPathField : partitionPathFields) {
            String fieldVal = HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)partitionPathField, (boolean)true);
            if (fieldVal == null || fieldVal.isEmpty()) {
                partitionPath.append(hiveStylePartitioning ? partitionPathField + "=" + DEFAULT_PARTITION_PATH : DEFAULT_PARTITION_PATH);
            } else {
                if (encodePartitionPath) {
                    try {
                        fieldVal = URLEncoder.encode(fieldVal, StandardCharsets.UTF_8.toString());
                    }
                    catch (UnsupportedEncodingException uoe) {
                        throw new HoodieException(uoe.getMessage(), (Throwable)uoe);
                    }
                }
                partitionPath.append(hiveStylePartitioning ? partitionPathField + "=" + fieldVal : fieldVal);
            }
            partitionPath.append(DEFAULT_PARTITION_PATH_SEPARATOR);
        }
        partitionPath.deleteCharAt(partitionPath.length() - 1);
        return partitionPath.toString();
    }

    public static String getRecordKey(GenericRecord record, String recordKeyField) {
        String recordKey = HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)recordKeyField, (boolean)true);
        if (recordKey == null || recordKey.isEmpty()) {
            throw new HoodieKeyException("recordKey value: \"" + recordKey + "\" for field: \"" + recordKeyField + "\" cannot be null or empty.");
        }
        return recordKey;
    }

    public static String getPartitionPath(GenericRecord record, String partitionPathField, boolean hiveStylePartitioning, boolean encodePartitionPath) {
        String partitionPath = HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)partitionPathField, (boolean)true);
        if (partitionPath == null || partitionPath.isEmpty()) {
            partitionPath = DEFAULT_PARTITION_PATH;
        }
        if (encodePartitionPath) {
            try {
                partitionPath = URLEncoder.encode(partitionPath, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException uoe) {
                throw new HoodieException(uoe.getMessage(), (Throwable)uoe);
            }
        }
        if (hiveStylePartitioning) {
            partitionPath = partitionPathField + "=" + partitionPath;
        }
        return partitionPath;
    }

    public static AbstractHoodieDateTimeParser createDateTimeParser(TypedProperties props, String parserClass) throws IOException {
        try {
            return (AbstractHoodieDateTimeParser)ReflectionUtils.loadClass((String)parserClass, (Object[])new Object[]{props});
        }
        catch (Throwable e) {
            throw new IOException("Could not load date time parser class " + parserClass, e);
        }
    }

    public static void checkRequiredProperties(TypedProperties props, List<String> checkPropNames) {
        checkPropNames.forEach(prop -> {
            if (!props.containsKey(prop)) {
                throw new HoodieNotSupportedException("Required property " + prop + " is missing");
            }
        });
    }
}

