/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.HoodieIOHandle;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.MarkerFiles;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class HoodieWriteHandle<T extends HoodieRecordPayload, I, K, O>
extends HoodieIOHandle<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(HoodieWriteHandle.class);
    protected final Schema writerSchema;
    protected final Schema writerSchemaWithMetafields;
    protected HoodieTimer timer;
    protected WriteStatus writeStatus;
    protected final String partitionPath;
    protected final String fileId;
    protected final String writeToken;
    protected final TaskContextSupplier taskContextSupplier;

    public HoodieWriteHandle(HoodieWriteConfig config, String instantTime, String partitionPath, String fileId, HoodieTable<T, I, K, O> hoodieTable, TaskContextSupplier taskContextSupplier) {
        this(config, instantTime, partitionPath, fileId, hoodieTable, HoodieWriteHandle.getWriterSchemaIncludingAndExcludingMetadataPair(config), taskContextSupplier);
    }

    protected HoodieWriteHandle(HoodieWriteConfig config, String instantTime, String partitionPath, String fileId, HoodieTable<T, I, K, O> hoodieTable, Pair<Schema, Schema> writerSchemaIncludingAndExcludingMetadataPair, TaskContextSupplier taskContextSupplier) {
        super(config, instantTime, hoodieTable);
        this.partitionPath = partitionPath;
        this.fileId = fileId;
        this.writerSchema = (Schema)writerSchemaIncludingAndExcludingMetadataPair.getKey();
        this.writerSchemaWithMetafields = (Schema)writerSchemaIncludingAndExcludingMetadataPair.getValue();
        this.timer = new HoodieTimer().startTimer();
        this.writeStatus = (WriteStatus)ReflectionUtils.loadClass((String)config.getWriteStatusClassName(), (Object[])new Object[]{!hoodieTable.getIndex().isImplicitWithStorage(), config.getWriteStatusFailureFraction()});
        this.taskContextSupplier = taskContextSupplier;
        this.writeToken = this.makeWriteToken();
    }

    protected static Pair<Schema, Schema> getWriterSchemaIncludingAndExcludingMetadataPair(HoodieWriteConfig config) {
        Schema originalSchema = new Schema.Parser().parse(config.getSchema());
        Schema hoodieSchema = HoodieAvroUtils.addMetadataFields((Schema)originalSchema);
        return Pair.of((Object)originalSchema, (Object)hoodieSchema);
    }

    private String makeWriteToken() {
        return FSUtils.makeWriteToken((int)this.getPartitionId(), (int)this.getStageId(), (long)this.getAttemptId());
    }

    public Path makeNewPath(String partitionPath) {
        Path path = FSUtils.getPartitionPath((String)this.config.getBasePath(), (String)partitionPath);
        try {
            this.fs.mkdirs(path);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to make dir " + path, e);
        }
        return new Path(path.toString(), FSUtils.makeDataFileName((String)this.instantTime, (String)this.writeToken, (String)this.fileId, (String)this.hoodieTable.getMetaClient().getTableConfig().getBaseFileFormat().getFileExtension()));
    }

    protected void createMarkerFile(String partitionPath, String dataFileName) {
        MarkerFiles markerFiles = new MarkerFiles(this.hoodieTable, this.instantTime);
        markerFiles.create(partitionPath, dataFileName, this.getIOType());
    }

    public Schema getWriterSchemaWithMetafields() {
        return this.writerSchemaWithMetafields;
    }

    public boolean canWrite(HoodieRecord record) {
        return false;
    }

    public void write(HoodieRecord record, Option<IndexedRecord> insertValue) {
    }

    public void write(HoodieRecord record, Option<IndexedRecord> avroRecord, Option<Exception> exception) {
        Option recordMetadata = record.getData().getMetadata();
        if (exception.isPresent() && exception.get() instanceof Throwable) {
            this.writeStatus.markFailure(record, (Throwable)exception.get(), (Option<Map<String, String>>)recordMetadata);
            LOG.error((Object)("Error writing record " + record), (Throwable)exception.get());
        } else {
            this.write(record, avroRecord);
        }
    }

    protected GenericRecord rewriteRecord(GenericRecord record) {
        return HoodieAvroUtils.rewriteRecord((GenericRecord)record, (Schema)this.writerSchemaWithMetafields);
    }

    public abstract List<WriteStatus> close();

    public List<WriteStatus> writeStatuses() {
        return Collections.singletonList(this.writeStatus);
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public abstract IOType getIOType();

    @Override
    protected FileSystem getFileSystem() {
        return this.hoodieTable.getMetaClient().getFs();
    }

    protected int getPartitionId() {
        return (Integer)this.taskContextSupplier.getPartitionIdSupplier().get();
    }

    protected int getStageId() {
        return (Integer)this.taskContextSupplier.getStageIdSupplier().get();
    }

    protected long getAttemptId() {
        return (Long)this.taskContextSupplier.getAttemptIdSupplier().get();
    }

    protected HoodieFileWriter createNewFileWriter(String instantTime, Path path, HoodieTable<T, I, K, O> hoodieTable, HoodieWriteConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        return HoodieFileWriterFactory.getFileWriter(instantTime, path, hoodieTable, config, schema, taskContextSupplier);
    }
}

