/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCorruptedDataException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.io.IOUtils;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieMergeHandle<T extends HoodieRecordPayload, I, K, O>
extends HoodieWriteHandle<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(HoodieMergeHandle.class);
    protected Map<String, HoodieRecord<T>> keyToNewRecords;
    protected Set<String> writtenRecordKeys;
    private HoodieFileWriter<IndexedRecord> fileWriter;
    private Path newFilePath;
    private Path oldFilePath;
    private long recordsWritten = 0L;
    private long recordsDeleted = 0L;
    private long updatedRecordsWritten = 0L;
    protected long insertRecordsWritten = 0L;
    protected boolean useWriterSchema;
    private HoodieBaseFile baseFileToMerge;

    public HoodieMergeHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier) {
        super(config, instantTime, partitionPath, fileId, hoodieTable, taskContextSupplier);
        this.init(fileId, recordItr);
        this.init(fileId, partitionPath, (HoodieBaseFile)hoodieTable.getBaseFileOnlyView().getLatestBaseFile(partitionPath, fileId).get());
    }

    public HoodieMergeHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Map<String, HoodieRecord<T>> keyToNewRecords, String partitionPath, String fileId, HoodieBaseFile dataFileToBeMerged, TaskContextSupplier taskContextSupplier) {
        super(config, instantTime, partitionPath, fileId, hoodieTable, taskContextSupplier);
        this.keyToNewRecords = keyToNewRecords;
        this.useWriterSchema = true;
        this.init(fileId, this.partitionPath, dataFileToBeMerged);
    }

    @Override
    public Schema getWriterSchemaWithMetafields() {
        return this.writerSchemaWithMetafields;
    }

    public Schema getWriterSchema() {
        return this.writerSchema;
    }

    private void init(String fileId, String partitionPath, HoodieBaseFile baseFileToMerge) {
        LOG.info((Object)("partitionPath:" + partitionPath + ", fileId to be merged:" + fileId));
        this.baseFileToMerge = baseFileToMerge;
        this.writtenRecordKeys = new HashSet<String>();
        this.writeStatus.setStat(new HoodieWriteStat());
        try {
            String latestValidFilePath = baseFileToMerge.getFileName();
            this.writeStatus.getStat().setPrevCommit(FSUtils.getCommitTime((String)latestValidFilePath));
            HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(this.fs, this.instantTime, new Path(this.config.getBasePath()), FSUtils.getPartitionPath((String)this.config.getBasePath(), (String)partitionPath));
            partitionMetadata.trySave(this.getPartitionId());
            this.oldFilePath = new Path(this.config.getBasePath() + "/" + partitionPath + "/" + latestValidFilePath);
            String newFileName = FSUtils.makeDataFileName((String)this.instantTime, (String)this.writeToken, (String)fileId, (String)this.hoodieTable.getBaseFileExtension());
            String relativePath = new Path((partitionPath.isEmpty() ? "" : partitionPath + "/") + newFileName).toString();
            this.newFilePath = new Path(this.config.getBasePath(), relativePath);
            LOG.info((Object)String.format("Merging new data into oldPath %s, as newPath %s", this.oldFilePath.toString(), this.newFilePath.toString()));
            this.writeStatus.setFileId(fileId);
            this.writeStatus.setPartitionPath(partitionPath);
            this.writeStatus.getStat().setPartitionPath(partitionPath);
            this.writeStatus.getStat().setFileId(fileId);
            this.writeStatus.getStat().setPath(new Path(this.config.getBasePath()), this.newFilePath);
            this.createMarkerFile(partitionPath, newFileName);
            this.fileWriter = this.createNewFileWriter(this.instantTime, this.newFilePath, this.hoodieTable, this.config, this.writerSchemaWithMetafields, this.taskContextSupplier);
        }
        catch (IOException io) {
            LOG.error((Object)("Error in update task at commit " + this.instantTime), (Throwable)io);
            this.writeStatus.setGlobalError(io);
            throw new HoodieUpsertException("Failed to initialize HoodieUpdateHandle for FileId: " + fileId + " on commit " + this.instantTime + " on path " + this.hoodieTable.getMetaClient().getBasePath(), io);
        }
    }

    private void init(String fileId, Iterator<HoodieRecord<T>> newRecordsItr) {
        try {
            long memoryForMerge = IOUtils.getMaxMemoryPerPartitionMerge(this.taskContextSupplier, this.config.getProps());
            LOG.info((Object)("MaxMemoryPerPartitionMerge => " + memoryForMerge));
            this.keyToNewRecords = new ExternalSpillableMap(Long.valueOf(memoryForMerge), this.config.getSpillableMapBasePath(), (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(this.writerSchema));
        }
        catch (IOException io) {
            throw new HoodieIOException("Cannot instantiate an ExternalSpillableMap", io);
        }
        while (newRecordsItr.hasNext()) {
            HoodieRecord<T> record = newRecordsItr.next();
            record.unseal();
            record.setNewLocation(new HoodieRecordLocation(this.instantTime, fileId));
            record.seal();
            this.keyToNewRecords.put(record.getRecordKey(), record);
        }
        LOG.info((Object)("Number of entries in MemoryBasedMap => " + ((ExternalSpillableMap)this.keyToNewRecords).getInMemoryMapNumEntries() + "Total size in bytes of MemoryBasedMap => " + ((ExternalSpillableMap)this.keyToNewRecords).getCurrentInMemoryMapSize() + "Number of entries in DiskBasedMap => " + ((ExternalSpillableMap)this.keyToNewRecords).getDiskBasedMapNumEntries() + "Size of file spilled to disk => " + ((ExternalSpillableMap)this.keyToNewRecords).getSizeOfFileOnDiskInBytes()));
    }

    private boolean writeUpdateRecord(HoodieRecord<T> hoodieRecord, Option<IndexedRecord> indexedRecord) {
        if (indexedRecord.isPresent()) {
            ++this.updatedRecordsWritten;
        }
        return this.writeRecord(hoodieRecord, indexedRecord);
    }

    protected boolean writeRecord(HoodieRecord<T> hoodieRecord, Option<IndexedRecord> indexedRecord) {
        Option recordMetadata = hoodieRecord.getData().getMetadata();
        if (!this.partitionPath.equals(hoodieRecord.getPartitionPath())) {
            HoodieUpsertException failureEx = new HoodieUpsertException("mismatched partition path, record partition: " + hoodieRecord.getPartitionPath() + " but trying to insert into partition: " + this.partitionPath);
            this.writeStatus.markFailure(hoodieRecord, (Throwable)((Object)failureEx), (Option<Map<String, String>>)recordMetadata);
            return false;
        }
        try {
            if (indexedRecord.isPresent()) {
                GenericRecord recordWithMetadataInSchema = this.rewriteRecord((GenericRecord)indexedRecord.get());
                this.fileWriter.writeAvroWithMetadata((IndexedRecord)recordWithMetadataInSchema, hoodieRecord);
                ++this.recordsWritten;
            } else {
                ++this.recordsDeleted;
            }
            this.writeStatus.markSuccess(hoodieRecord, (Option<Map<String, String>>)recordMetadata);
            hoodieRecord.deflate();
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)("Error writing record  " + hoodieRecord), (Throwable)e);
            this.writeStatus.markFailure(hoodieRecord, e, (Option<Map<String, String>>)recordMetadata);
            return false;
        }
    }

    public void write(GenericRecord oldRecord) {
        String key = oldRecord.get("_hoodie_record_key").toString();
        boolean copyOldRecord = true;
        if (this.keyToNewRecords.containsKey(key)) {
            HoodieRecord hoodieRecord = new HoodieRecord(this.keyToNewRecords.get(key));
            try {
                Option combinedAvroRecord = hoodieRecord.getData().combineAndGetUpdateValue((IndexedRecord)oldRecord, this.useWriterSchema ? this.writerSchemaWithMetafields : this.writerSchema, this.config.getPayloadConfig().getProps());
                if (this.writeUpdateRecord(hoodieRecord, (Option<IndexedRecord>)combinedAvroRecord)) {
                    copyOldRecord = false;
                }
                this.writtenRecordKeys.add(key);
            }
            catch (Exception e) {
                throw new HoodieUpsertException("Failed to combine/merge new record with old value in storage, for new record {" + this.keyToNewRecords.get(key) + "}, old value {" + oldRecord + "}", e);
            }
        }
        if (copyOldRecord) {
            try {
                this.fileWriter.writeAvro(key, (IndexedRecord)oldRecord);
            }
            catch (IOException | RuntimeException e) {
                String errMsg = String.format("Failed to merge old record into new file for key %s from old file %s to new file %s with writerSchema %s", key, this.getOldFilePath(), this.newFilePath, this.writerSchemaWithMetafields.toString(true));
                LOG.debug((Object)("Old record is " + oldRecord));
                throw new HoodieUpsertException(errMsg, e);
            }
            ++this.recordsWritten;
        }
    }

    @Override
    public List<WriteStatus> close() {
        try {
            Iterator<HoodieRecord<T>> newRecordsItr;
            Iterator<HoodieRecord<T>> iterator = newRecordsItr = this.keyToNewRecords instanceof ExternalSpillableMap ? ((ExternalSpillableMap)this.keyToNewRecords).iterator() : this.keyToNewRecords.values().iterator();
            while (newRecordsItr.hasNext()) {
                HoodieRecord<T> hoodieRecord = newRecordsItr.next();
                if (this.writtenRecordKeys.contains(hoodieRecord.getRecordKey())) continue;
                if (this.useWriterSchema) {
                    this.writeRecord(hoodieRecord, (Option<IndexedRecord>)hoodieRecord.getData().getInsertValue(this.writerSchemaWithMetafields));
                } else {
                    this.writeRecord(hoodieRecord, (Option<IndexedRecord>)hoodieRecord.getData().getInsertValue(this.writerSchema));
                }
                ++this.insertRecordsWritten;
            }
            ((ExternalSpillableMap)this.keyToNewRecords).close();
            this.writtenRecordKeys.clear();
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
            long fileSizeInBytes = FSUtils.getFileSize((FileSystem)this.fs, (Path)this.newFilePath);
            HoodieWriteStat stat = this.writeStatus.getStat();
            stat.setTotalWriteBytes(fileSizeInBytes);
            stat.setFileSizeInBytes(fileSizeInBytes);
            stat.setNumWrites(this.recordsWritten);
            stat.setNumDeletes(this.recordsDeleted);
            stat.setNumUpdateWrites(this.updatedRecordsWritten);
            stat.setNumInserts(this.insertRecordsWritten);
            stat.setTotalWriteErrors(this.writeStatus.getTotalErrorRecords());
            HoodieWriteStat.RuntimeStats runtimeStats = new HoodieWriteStat.RuntimeStats();
            runtimeStats.setTotalUpsertTime(this.timer.endTimer());
            stat.setRuntimeStats(runtimeStats);
            this.performMergeDataValidationCheck(this.writeStatus);
            LOG.info((Object)String.format("MergeHandle for partitionPath %s fileID %s, took %d ms.", stat.getPartitionPath(), stat.getFileId(), runtimeStats.getTotalUpsertTime()));
            return Collections.singletonList(this.writeStatus);
        }
        catch (IOException e) {
            throw new HoodieUpsertException("Failed to close UpdateHandle", e);
        }
    }

    public void performMergeDataValidationCheck(WriteStatus writeStatus) {
        if (!this.config.isMergeDataValidationCheckEnabled()) {
            return;
        }
        long oldNumWrites = 0L;
        try {
            HoodieFileReader reader = HoodieFileReaderFactory.getFileReader((Configuration)this.hoodieTable.getHadoopConf(), (Path)this.oldFilePath);
            oldNumWrites = reader.getTotalRecords();
        }
        catch (IOException e) {
            throw new HoodieUpsertException("Failed to check for merge data validation", e);
        }
        if (writeStatus.getStat().getNumWrites() + writeStatus.getStat().getNumDeletes() < oldNumWrites) {
            throw new HoodieCorruptedDataException(String.format("Record write count decreased for file: %s, Partition Path: %s (%s:%d + %d < %s:%d)", writeStatus.getFileId(), writeStatus.getPartitionPath(), this.instantTime, writeStatus.getStat().getNumWrites(), writeStatus.getStat().getNumDeletes(), FSUtils.getCommitTime((String)this.oldFilePath.toString()), oldNumWrites));
        }
    }

    public Path getOldFilePath() {
        return this.oldFilePath;
    }

    @Override
    public IOType getIOType() {
        return IOType.MERGE;
    }

    public HoodieBaseFile baseFileForMerge() {
        return this.baseFileToMerge;
    }
}

