/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.DefaultHoodieConfig;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.table.action.compact.strategy.CompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.LogFileSizeBasedCompactionStrategy;

@Immutable
public class HoodieCompactionConfig
extends DefaultHoodieConfig {
    public static final String CLEANER_POLICY_PROP = "hoodie.cleaner.policy";
    public static final String AUTO_CLEAN_PROP = "hoodie.clean.automatic";
    public static final String ASYNC_CLEAN_PROP = "hoodie.clean.async";
    public static final String INLINE_COMPACT_PROP = "hoodie.compact.inline";
    public static final String INLINE_COMPACT_NUM_DELTA_COMMITS_PROP = "hoodie.compact.inline.max.delta.commits";
    public static final String CLEANER_FILE_VERSIONS_RETAINED_PROP = "hoodie.cleaner.fileversions.retained";
    public static final String CLEANER_COMMITS_RETAINED_PROP = "hoodie.cleaner.commits.retained";
    public static final String CLEANER_INCREMENTAL_MODE = "hoodie.cleaner.incremental.mode";
    public static final String MAX_COMMITS_TO_KEEP_PROP = "hoodie.keep.max.commits";
    public static final String MIN_COMMITS_TO_KEEP_PROP = "hoodie.keep.min.commits";
    public static final String COMMITS_ARCHIVAL_BATCH_SIZE_PROP = "hoodie.commits.archival.batch";
    public static final String CLEANER_BOOTSTRAP_BASE_FILE_ENABLED = "hoodie.cleaner.delete.bootstrap.base.file";
    public static final String PARQUET_SMALL_FILE_LIMIT_BYTES = "hoodie.parquet.small.file.limit";
    public static final String DEFAULT_PARQUET_SMALL_FILE_LIMIT_BYTES = String.valueOf(0x6400000);
    public static final String RECORD_SIZE_ESTIMATION_THRESHOLD_PROP = "hoodie.record.size.estimation.threshold";
    public static final String DEFAULT_RECORD_SIZE_ESTIMATION_THRESHOLD = "1.0";
    public static final String COPY_ON_WRITE_TABLE_INSERT_SPLIT_SIZE = "hoodie.copyonwrite.insert.split.size";
    public static final String DEFAULT_COPY_ON_WRITE_TABLE_INSERT_SPLIT_SIZE = String.valueOf(500000);
    public static final String COPY_ON_WRITE_TABLE_AUTO_SPLIT_INSERTS = "hoodie.copyonwrite.insert.auto.split";
    public static final String DEFAULT_COPY_ON_WRITE_TABLE_AUTO_SPLIT_INSERTS = String.valueOf(true);
    public static final String COPY_ON_WRITE_TABLE_RECORD_SIZE_ESTIMATE = "hoodie.copyonwrite.record.size.estimate";
    public static final String DEFAULT_COPY_ON_WRITE_TABLE_RECORD_SIZE_ESTIMATE = String.valueOf(1024);
    public static final String CLEANER_PARALLELISM = "hoodie.cleaner.parallelism";
    public static final String DEFAULT_CLEANER_PARALLELISM = String.valueOf(200);
    public static final String TARGET_IO_PER_COMPACTION_IN_MB_PROP = "hoodie.compaction.target.io";
    public static final String DEFAULT_TARGET_IO_PER_COMPACTION_IN_MB = String.valueOf(512000);
    public static final String COMPACTION_STRATEGY_PROP = "hoodie.compaction.strategy";
    public static final String DEFAULT_COMPACTION_STRATEGY = LogFileSizeBasedCompactionStrategy.class.getName();
    public static final String DEFAULT_PAYLOAD_CLASS = OverwriteWithLatestAvroPayload.class.getName();
    public static final String PAYLOAD_CLASS_PROP = "hoodie.compaction.payload.class";
    public static final String COMPACTION_LAZY_BLOCK_READ_ENABLED_PROP = "hoodie.compaction.lazy.block.read";
    public static final String DEFAULT_COMPACTION_LAZY_BLOCK_READ_ENABLED = "false";
    public static final String COMPACTION_REVERSE_LOG_READ_ENABLED_PROP = "hoodie.compaction.reverse.log.read";
    public static final String DEFAULT_COMPACTION_REVERSE_LOG_READ_ENABLED = "false";
    private static final String DEFAULT_CLEANER_POLICY = HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name();
    private static final String DEFAULT_AUTO_CLEAN = "true";
    private static final String DEFAULT_ASYNC_CLEAN = "false";
    private static final String DEFAULT_INLINE_COMPACT = "false";
    private static final String DEFAULT_INCREMENTAL_CLEANER = "true";
    private static final String DEFAULT_INLINE_COMPACT_NUM_DELTA_COMMITS = "5";
    private static final String DEFAULT_CLEANER_FILE_VERSIONS_RETAINED = "3";
    private static final String DEFAULT_CLEANER_COMMITS_RETAINED = "10";
    private static final String DEFAULT_MAX_COMMITS_TO_KEEP = "30";
    private static final String DEFAULT_MIN_COMMITS_TO_KEEP = "20";
    private static final String DEFAULT_COMMITS_ARCHIVAL_BATCH_SIZE = String.valueOf(10);
    private static final String DEFAULT_CLEANER_BOOTSTRAP_BASE_FILE_ENABLED = "false";
    public static final String TARGET_PARTITIONS_PER_DAYBASED_COMPACTION_PROP = "hoodie.compaction.daybased.target.partitions";
    public static final String DEFAULT_TARGET_PARTITIONS_PER_DAYBASED_COMPACTION = String.valueOf(10);

    private HoodieCompactionConfig(Properties props) {
        super(props);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Properties props = new Properties();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withAutoClean(Boolean autoClean) {
            this.props.setProperty(HoodieCompactionConfig.AUTO_CLEAN_PROP, String.valueOf(autoClean));
            return this;
        }

        public Builder withAsyncClean(Boolean asyncClean) {
            this.props.setProperty(HoodieCompactionConfig.ASYNC_CLEAN_PROP, String.valueOf(asyncClean));
            return this;
        }

        public Builder withIncrementalCleaningMode(Boolean incrementalCleaningMode) {
            this.props.setProperty(HoodieCompactionConfig.CLEANER_INCREMENTAL_MODE, String.valueOf(incrementalCleaningMode));
            return this;
        }

        public Builder withInlineCompaction(Boolean inlineCompaction) {
            this.props.setProperty(HoodieCompactionConfig.INLINE_COMPACT_PROP, String.valueOf(inlineCompaction));
            return this;
        }

        public Builder withCleanerPolicy(HoodieCleaningPolicy policy) {
            this.props.setProperty(HoodieCompactionConfig.CLEANER_POLICY_PROP, policy.name());
            return this;
        }

        public Builder retainFileVersions(int fileVersionsRetained) {
            this.props.setProperty(HoodieCompactionConfig.CLEANER_FILE_VERSIONS_RETAINED_PROP, String.valueOf(fileVersionsRetained));
            return this;
        }

        public Builder retainCommits(int commitsRetained) {
            this.props.setProperty(HoodieCompactionConfig.CLEANER_COMMITS_RETAINED_PROP, String.valueOf(commitsRetained));
            return this;
        }

        public Builder archiveCommitsWith(int minToKeep, int maxToKeep) {
            this.props.setProperty(HoodieCompactionConfig.MIN_COMMITS_TO_KEEP_PROP, String.valueOf(minToKeep));
            this.props.setProperty(HoodieCompactionConfig.MAX_COMMITS_TO_KEEP_PROP, String.valueOf(maxToKeep));
            return this;
        }

        public Builder compactionSmallFileSize(long smallFileLimitBytes) {
            this.props.setProperty(HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT_BYTES, String.valueOf(smallFileLimitBytes));
            return this;
        }

        public Builder compactionRecordSizeEstimateThreshold(double threshold) {
            this.props.setProperty(HoodieCompactionConfig.RECORD_SIZE_ESTIMATION_THRESHOLD_PROP, String.valueOf(threshold));
            return this;
        }

        public Builder insertSplitSize(int insertSplitSize) {
            this.props.setProperty(HoodieCompactionConfig.COPY_ON_WRITE_TABLE_INSERT_SPLIT_SIZE, String.valueOf(insertSplitSize));
            return this;
        }

        public Builder autoTuneInsertSplits(boolean autoTuneInsertSplits) {
            this.props.setProperty(HoodieCompactionConfig.COPY_ON_WRITE_TABLE_AUTO_SPLIT_INSERTS, String.valueOf(autoTuneInsertSplits));
            return this;
        }

        public Builder approxRecordSize(int recordSizeEstimate) {
            this.props.setProperty(HoodieCompactionConfig.COPY_ON_WRITE_TABLE_RECORD_SIZE_ESTIMATE, String.valueOf(recordSizeEstimate));
            return this;
        }

        public Builder withCleanerParallelism(int cleanerParallelism) {
            this.props.setProperty(HoodieCompactionConfig.CLEANER_PARALLELISM, String.valueOf(cleanerParallelism));
            return this;
        }

        public Builder withCompactionStrategy(CompactionStrategy compactionStrategy) {
            this.props.setProperty(HoodieCompactionConfig.COMPACTION_STRATEGY_PROP, compactionStrategy.getClass().getName());
            return this;
        }

        public Builder withPayloadClass(String payloadClassName) {
            this.props.setProperty(HoodieCompactionConfig.PAYLOAD_CLASS_PROP, payloadClassName);
            return this;
        }

        public Builder withTargetIOPerCompactionInMB(long targetIOPerCompactionInMB) {
            this.props.setProperty(HoodieCompactionConfig.TARGET_IO_PER_COMPACTION_IN_MB_PROP, String.valueOf(targetIOPerCompactionInMB));
            return this;
        }

        public Builder withMaxNumDeltaCommitsBeforeCompaction(int maxNumDeltaCommitsBeforeCompaction) {
            this.props.setProperty(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS_PROP, String.valueOf(maxNumDeltaCommitsBeforeCompaction));
            return this;
        }

        public Builder withCompactionLazyBlockReadEnabled(Boolean compactionLazyBlockReadEnabled) {
            this.props.setProperty(HoodieCompactionConfig.COMPACTION_LAZY_BLOCK_READ_ENABLED_PROP, String.valueOf(compactionLazyBlockReadEnabled));
            return this;
        }

        public Builder withCompactionReverseLogReadEnabled(Boolean compactionReverseLogReadEnabled) {
            this.props.setProperty(HoodieCompactionConfig.COMPACTION_REVERSE_LOG_READ_ENABLED_PROP, String.valueOf(compactionReverseLogReadEnabled));
            return this;
        }

        public Builder withTargetPartitionsPerDayBasedCompaction(int targetPartitionsPerCompaction) {
            this.props.setProperty(HoodieCompactionConfig.TARGET_PARTITIONS_PER_DAYBASED_COMPACTION_PROP, String.valueOf(targetPartitionsPerCompaction));
            return this;
        }

        public Builder withCommitsArchivalBatchSize(int batchSize) {
            this.props.setProperty(HoodieCompactionConfig.COMMITS_ARCHIVAL_BATCH_SIZE_PROP, String.valueOf(batchSize));
            return this;
        }

        public Builder withCleanBootstrapBaseFileEnabled(Boolean cleanBootstrapSourceFileEnabled) {
            this.props.setProperty(HoodieCompactionConfig.CLEANER_BOOTSTRAP_BASE_FILE_ENABLED, String.valueOf(cleanBootstrapSourceFileEnabled));
            return this;
        }

        public HoodieCompactionConfig build() {
            HoodieCompactionConfig config = new HoodieCompactionConfig(this.props);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.AUTO_CLEAN_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.AUTO_CLEAN_PROP, (String)"true");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.ASYNC_CLEAN_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.ASYNC_CLEAN_PROP, (String)"false");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.CLEANER_INCREMENTAL_MODE) ? 1 : 0) != 0, (String)HoodieCompactionConfig.CLEANER_INCREMENTAL_MODE, (String)"true");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.INLINE_COMPACT_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.INLINE_COMPACT_PROP, (String)"false");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS_PROP, (String)HoodieCompactionConfig.DEFAULT_INLINE_COMPACT_NUM_DELTA_COMMITS);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.CLEANER_POLICY_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.CLEANER_POLICY_PROP, (String)DEFAULT_CLEANER_POLICY);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.CLEANER_FILE_VERSIONS_RETAINED_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.CLEANER_FILE_VERSIONS_RETAINED_PROP, (String)HoodieCompactionConfig.DEFAULT_CLEANER_FILE_VERSIONS_RETAINED);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.CLEANER_COMMITS_RETAINED_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.CLEANER_COMMITS_RETAINED_PROP, (String)HoodieCompactionConfig.DEFAULT_CLEANER_COMMITS_RETAINED);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.MAX_COMMITS_TO_KEEP_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.MAX_COMMITS_TO_KEEP_PROP, (String)HoodieCompactionConfig.DEFAULT_MAX_COMMITS_TO_KEEP);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.MIN_COMMITS_TO_KEEP_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.MIN_COMMITS_TO_KEEP_PROP, (String)HoodieCompactionConfig.DEFAULT_MIN_COMMITS_TO_KEEP);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT_BYTES) ? 1 : 0) != 0, (String)HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT_BYTES, (String)DEFAULT_PARQUET_SMALL_FILE_LIMIT_BYTES);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.RECORD_SIZE_ESTIMATION_THRESHOLD_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.RECORD_SIZE_ESTIMATION_THRESHOLD_PROP, (String)HoodieCompactionConfig.DEFAULT_RECORD_SIZE_ESTIMATION_THRESHOLD);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.COPY_ON_WRITE_TABLE_INSERT_SPLIT_SIZE) ? 1 : 0) != 0, (String)HoodieCompactionConfig.COPY_ON_WRITE_TABLE_INSERT_SPLIT_SIZE, (String)DEFAULT_COPY_ON_WRITE_TABLE_INSERT_SPLIT_SIZE);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.COPY_ON_WRITE_TABLE_AUTO_SPLIT_INSERTS) ? 1 : 0) != 0, (String)HoodieCompactionConfig.COPY_ON_WRITE_TABLE_AUTO_SPLIT_INSERTS, (String)DEFAULT_COPY_ON_WRITE_TABLE_AUTO_SPLIT_INSERTS);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.COPY_ON_WRITE_TABLE_RECORD_SIZE_ESTIMATE) ? 1 : 0) != 0, (String)HoodieCompactionConfig.COPY_ON_WRITE_TABLE_RECORD_SIZE_ESTIMATE, (String)DEFAULT_COPY_ON_WRITE_TABLE_RECORD_SIZE_ESTIMATE);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.CLEANER_PARALLELISM) ? 1 : 0) != 0, (String)HoodieCompactionConfig.CLEANER_PARALLELISM, (String)DEFAULT_CLEANER_PARALLELISM);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.COMPACTION_STRATEGY_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.COMPACTION_STRATEGY_PROP, (String)DEFAULT_COMPACTION_STRATEGY);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.PAYLOAD_CLASS_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.PAYLOAD_CLASS_PROP, (String)DEFAULT_PAYLOAD_CLASS);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.TARGET_IO_PER_COMPACTION_IN_MB_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.TARGET_IO_PER_COMPACTION_IN_MB_PROP, (String)DEFAULT_TARGET_IO_PER_COMPACTION_IN_MB);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.COMPACTION_LAZY_BLOCK_READ_ENABLED_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.COMPACTION_LAZY_BLOCK_READ_ENABLED_PROP, (String)"false");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.COMPACTION_REVERSE_LOG_READ_ENABLED_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.COMPACTION_REVERSE_LOG_READ_ENABLED_PROP, (String)"false");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.TARGET_PARTITIONS_PER_DAYBASED_COMPACTION_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.TARGET_PARTITIONS_PER_DAYBASED_COMPACTION_PROP, (String)DEFAULT_TARGET_PARTITIONS_PER_DAYBASED_COMPACTION);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.COMMITS_ARCHIVAL_BATCH_SIZE_PROP) ? 1 : 0) != 0, (String)HoodieCompactionConfig.COMMITS_ARCHIVAL_BATCH_SIZE_PROP, (String)DEFAULT_COMMITS_ARCHIVAL_BATCH_SIZE);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieCompactionConfig.CLEANER_BOOTSTRAP_BASE_FILE_ENABLED) ? 1 : 0) != 0, (String)HoodieCompactionConfig.CLEANER_BOOTSTRAP_BASE_FILE_ENABLED, (String)"false");
            HoodieCleaningPolicy.valueOf((String)this.props.getProperty(HoodieCompactionConfig.CLEANER_POLICY_PROP));
            int minInstantsToKeep = Integer.parseInt(this.props.getProperty(HoodieCompactionConfig.MIN_COMMITS_TO_KEEP_PROP));
            int maxInstantsToKeep = Integer.parseInt(this.props.getProperty(HoodieCompactionConfig.MAX_COMMITS_TO_KEEP_PROP));
            int cleanerCommitsRetained = Integer.parseInt(this.props.getProperty(HoodieCompactionConfig.CLEANER_COMMITS_RETAINED_PROP));
            ValidationUtils.checkArgument((maxInstantsToKeep > minInstantsToKeep ? 1 : 0) != 0, (String)String.format("Increase %s=%d to be greater than %s=%d.", HoodieCompactionConfig.MAX_COMMITS_TO_KEEP_PROP, maxInstantsToKeep, HoodieCompactionConfig.MIN_COMMITS_TO_KEEP_PROP, minInstantsToKeep));
            ValidationUtils.checkArgument((minInstantsToKeep > cleanerCommitsRetained ? 1 : 0) != 0, (String)String.format("Increase %s=%d to be greater than %s=%d. Otherwise, there is risk of incremental pull missing data from few instants.", HoodieCompactionConfig.MIN_COMMITS_TO_KEEP_PROP, minInstantsToKeep, HoodieCompactionConfig.CLEANER_COMMITS_RETAINED_PROP, cleanerCommitsRetained));
            return config;
        }
    }
}

