/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.DefaultHoodieConfig;

public class HoodieClusteringConfig
extends DefaultHoodieConfig {
    public static final String CLUSTERING_PLAN_STRATEGY_CLASS = "hoodie.clustering.plan.strategy.class";
    public static final String DEFAULT_CLUSTERING_PLAN_STRATEGY_CLASS = "org.apache.hudi.client.clustering.plan.strategy.SparkRecentDaysClusteringPlanStrategy";
    public static final String CLUSTERING_EXECUTION_STRATEGY_CLASS = "hoodie.clustering.execution.strategy.class";
    public static final String DEFAULT_CLUSTERING_EXECUTION_STRATEGY_CLASS = "org.apache.hudi.client.clustering.run.strategy.SparkSortAndSizeExecutionStrategy";
    public static final String INLINE_CLUSTERING_PROP = "hoodie.clustering.inline";
    private static final String DEFAULT_INLINE_CLUSTERING = "false";
    public static final String INLINE_CLUSTERING_MAX_COMMIT_PROP = "hoodie.clustering.inline.max.commits";
    private static final String DEFAULT_INLINE_CLUSTERING_NUM_COMMITS = "4";
    public static final String CLUSTERING_STRATEGY_PARAM_PREFIX = "hoodie.clustering.plan.strategy.";
    public static final String CLUSTERING_TARGET_PARTITIONS = "hoodie.clustering.plan.strategy.daybased.lookback.partitions";
    public static final String DEFAULT_CLUSTERING_TARGET_PARTITIONS = String.valueOf(2);
    public static final String CLUSTERING_PLAN_SMALL_FILE_LIMIT = "hoodie.clustering.plan.strategy.small.file.limit";
    public static final String DEFAULT_CLUSTERING_PLAN_SMALL_FILE_LIMIT = String.valueOf(629145600L);
    public static final String CLUSTERING_MAX_BYTES_PER_GROUP = "hoodie.clustering.plan.strategy.max.bytes.per.group";
    public static final String DEFAULT_CLUSTERING_MAX_GROUP_SIZE = String.valueOf(0x80000000L);
    public static final String CLUSTERING_MAX_NUM_GROUPS = "hoodie.clustering.plan.strategy.max.num.groups";
    public static final String DEFAULT_CLUSTERING_MAX_NUM_GROUPS = "30";
    public static final String CLUSTERING_TARGET_FILE_MAX_BYTES = "hoodie.clustering.plan.strategy.target.file.max.bytes";
    public static final String DEFAULT_CLUSTERING_TARGET_FILE_MAX_BYTES = String.valueOf(0x40000000L);
    public static final String CLUSTERING_SORT_COLUMNS_PROPERTY = "hoodie.clustering.plan.strategy.sort.columns";
    public static final String CLUSTERING_UPDATES_STRATEGY_PROP = "hoodie.clustering.updates.strategy";
    public static final String DEFAULT_CLUSTERING_UPDATES_STRATEGY = "org.apache.hudi.client.clustering.update.strategy.SparkRejectUpdateStrategy";
    public static final String ASYNC_CLUSTERING_ENABLE_OPT_KEY = "hoodie.clustering.async.enabled";
    public static final String DEFAULT_ASYNC_CLUSTERING_ENABLE_OPT_VAL = "false";

    public HoodieClusteringConfig(Properties props) {
        super(props);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Properties props = new Properties();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder withClusteringPlanStrategyClass(String clusteringStrategyClass) {
            this.props.setProperty(HoodieClusteringConfig.CLUSTERING_PLAN_STRATEGY_CLASS, clusteringStrategyClass);
            return this;
        }

        public Builder withClusteringExecutionStrategyClass(String runClusteringStrategyClass) {
            this.props.setProperty(HoodieClusteringConfig.CLUSTERING_EXECUTION_STRATEGY_CLASS, runClusteringStrategyClass);
            return this;
        }

        public Builder withClusteringTargetPartitions(int clusteringTargetPartitions) {
            this.props.setProperty(HoodieClusteringConfig.CLUSTERING_TARGET_PARTITIONS, String.valueOf(clusteringTargetPartitions));
            return this;
        }

        public Builder withClusteringPlanSmallFileLimit(long clusteringSmallFileLimit) {
            this.props.setProperty(HoodieClusteringConfig.CLUSTERING_PLAN_SMALL_FILE_LIMIT, String.valueOf(clusteringSmallFileLimit));
            return this;
        }

        public Builder withClusteringSortColumns(String sortColumns) {
            this.props.setProperty(HoodieClusteringConfig.CLUSTERING_SORT_COLUMNS_PROPERTY, sortColumns);
            return this;
        }

        public Builder withClusteringMaxBytesInGroup(long clusteringMaxGroupSize) {
            this.props.setProperty(HoodieClusteringConfig.CLUSTERING_MAX_BYTES_PER_GROUP, String.valueOf(clusteringMaxGroupSize));
            return this;
        }

        public Builder withClusteringMaxNumGroups(int maxNumGroups) {
            this.props.setProperty(HoodieClusteringConfig.CLUSTERING_MAX_NUM_GROUPS, String.valueOf(maxNumGroups));
            return this;
        }

        public Builder withClusteringTargetFileMaxBytes(long targetFileSize) {
            this.props.setProperty(HoodieClusteringConfig.CLUSTERING_TARGET_FILE_MAX_BYTES, String.valueOf(targetFileSize));
            return this;
        }

        public Builder withInlineClustering(Boolean inlineClustering) {
            this.props.setProperty(HoodieClusteringConfig.INLINE_CLUSTERING_PROP, String.valueOf(inlineClustering));
            return this;
        }

        public Builder withInlineClusteringNumCommits(int numCommits) {
            this.props.setProperty(HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMIT_PROP, String.valueOf(numCommits));
            return this;
        }

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withClusteringUpdatesStrategy(String updatesStrategyClass) {
            this.props.setProperty(HoodieClusteringConfig.CLUSTERING_UPDATES_STRATEGY_PROP, updatesStrategyClass);
            return this;
        }

        public Builder withAsyncClustering(Boolean asyncClustering) {
            this.props.setProperty(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE_OPT_KEY, String.valueOf(asyncClustering));
            return this;
        }

        public HoodieClusteringConfig build() {
            HoodieClusteringConfig config = new HoodieClusteringConfig(this.props);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieClusteringConfig.CLUSTERING_PLAN_STRATEGY_CLASS) ? 1 : 0) != 0, (String)HoodieClusteringConfig.CLUSTERING_PLAN_STRATEGY_CLASS, (String)HoodieClusteringConfig.DEFAULT_CLUSTERING_PLAN_STRATEGY_CLASS);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieClusteringConfig.CLUSTERING_EXECUTION_STRATEGY_CLASS) ? 1 : 0) != 0, (String)HoodieClusteringConfig.CLUSTERING_EXECUTION_STRATEGY_CLASS, (String)HoodieClusteringConfig.DEFAULT_CLUSTERING_EXECUTION_STRATEGY_CLASS);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieClusteringConfig.CLUSTERING_MAX_BYTES_PER_GROUP) ? 1 : 0) != 0, (String)HoodieClusteringConfig.CLUSTERING_MAX_BYTES_PER_GROUP, (String)DEFAULT_CLUSTERING_MAX_GROUP_SIZE);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieClusteringConfig.CLUSTERING_MAX_NUM_GROUPS) ? 1 : 0) != 0, (String)HoodieClusteringConfig.CLUSTERING_MAX_NUM_GROUPS, (String)HoodieClusteringConfig.DEFAULT_CLUSTERING_MAX_NUM_GROUPS);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieClusteringConfig.CLUSTERING_TARGET_FILE_MAX_BYTES) ? 1 : 0) != 0, (String)HoodieClusteringConfig.CLUSTERING_TARGET_FILE_MAX_BYTES, (String)DEFAULT_CLUSTERING_TARGET_FILE_MAX_BYTES);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieClusteringConfig.INLINE_CLUSTERING_PROP) ? 1 : 0) != 0, (String)HoodieClusteringConfig.INLINE_CLUSTERING_PROP, (String)"false");
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMIT_PROP) ? 1 : 0) != 0, (String)HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMIT_PROP, (String)HoodieClusteringConfig.DEFAULT_INLINE_CLUSTERING_NUM_COMMITS);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieClusteringConfig.CLUSTERING_TARGET_PARTITIONS) ? 1 : 0) != 0, (String)HoodieClusteringConfig.CLUSTERING_TARGET_PARTITIONS, (String)DEFAULT_CLUSTERING_TARGET_PARTITIONS);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieClusteringConfig.CLUSTERING_PLAN_SMALL_FILE_LIMIT) ? 1 : 0) != 0, (String)HoodieClusteringConfig.CLUSTERING_PLAN_SMALL_FILE_LIMIT, (String)DEFAULT_CLUSTERING_PLAN_SMALL_FILE_LIMIT);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieClusteringConfig.CLUSTERING_UPDATES_STRATEGY_PROP) ? 1 : 0) != 0, (String)HoodieClusteringConfig.CLUSTERING_UPDATES_STRATEGY_PROP, (String)HoodieClusteringConfig.DEFAULT_CLUSTERING_UPDATES_STRATEGY);
            DefaultHoodieConfig.setDefaultOnCondition((Properties)this.props, (!this.props.containsKey(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE_OPT_KEY) ? 1 : 0) != 0, (String)HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE_OPT_KEY, (String)"false");
            return config;
        }
    }
}

