/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hudi.async.HoodieAsyncService;
import org.apache.hudi.client.AbstractHoodieWriteClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

class AsyncCleanerService
extends HoodieAsyncService {
    private static final Logger LOG = LogManager.getLogger(AsyncCleanerService.class);
    private final AbstractHoodieWriteClient writeClient;
    private final String cleanInstantTime;
    private final transient ExecutorService executor = Executors.newSingleThreadExecutor();

    protected AsyncCleanerService(AbstractHoodieWriteClient writeClient, String cleanInstantTime) {
        this.writeClient = writeClient;
        this.cleanInstantTime = cleanInstantTime;
    }

    @Override
    protected Pair<CompletableFuture, ExecutorService> startService() {
        return Pair.of(CompletableFuture.supplyAsync(() -> {
            this.writeClient.clean(this.cleanInstantTime);
            return true;
        }), (Object)this.executor);
    }

    public static AsyncCleanerService startAsyncCleaningIfEnabled(AbstractHoodieWriteClient writeClient) {
        AsyncCleanerService asyncCleanerService = null;
        if (writeClient.getConfig().isAutoClean() && writeClient.getConfig().isAsyncClean()) {
            String instantTime = HoodieActiveTimeline.createNewInstantTime();
            LOG.info((Object)("Auto cleaning is enabled. Running cleaner async to write operation at instant time " + instantTime));
            asyncCleanerService = new AsyncCleanerService(writeClient, instantTime);
            asyncCleanerService.start(null);
        } else {
            LOG.info((Object)"Auto cleaning is not enabled. Not running cleaner now");
        }
        return asyncCleanerService;
    }

    public static void waitForCompletion(AsyncCleanerService asyncCleanerService) {
        if (asyncCleanerService != null) {
            LOG.info((Object)"Waiting for async cleaner to finish");
            try {
                asyncCleanerService.waitForShutdown();
            }
            catch (Exception e) {
                throw new HoodieException("Error waiting for async cleaning to finish", (Throwable)e);
            }
        }
    }

    public static void forceShutdown(AsyncCleanerService asyncCleanerService) {
        if (asyncCleanerService != null) {
            LOG.info((Object)"Shutting down async cleaner");
            asyncCleanerService.shutdown(true);
        }
    }
}

