/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.prometheus;

import com.codahale.metrics.MetricRegistry;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.dropwizard.samplebuilder.DefaultSampleBuilder;
import io.prometheus.client.dropwizard.samplebuilder.SampleBuilder;
import io.prometheus.client.exporter.HTTPServer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusReporter
extends MetricsReporter {
    private static final Pattern LABEL_PATTERN = Pattern.compile("\\s*,\\s*");
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusReporter.class);
    private static final Map<Integer, CollectorRegistry> PORT_TO_COLLECTOR_REGISTRY = new HashMap<Integer, CollectorRegistry>();
    private static final Map<Integer, HTTPServer> PORT_TO_SERVER = new HashMap<Integer, HTTPServer>();
    private final DropwizardExports metricExports;
    private final CollectorRegistry collectorRegistry;
    private final int serverPort;

    public PrometheusReporter(HoodieWriteConfig config, MetricRegistry registry) {
        this.serverPort = config.getPrometheusPort();
        if (!PORT_TO_SERVER.containsKey(this.serverPort) || !PORT_TO_COLLECTOR_REGISTRY.containsKey(this.serverPort)) {
            PrometheusReporter.startHttpServer(this.serverPort);
        }
        ArrayList<String> labelNames = new ArrayList<String>();
        ArrayList<String> labelValues = new ArrayList<String>();
        if (StringUtils.nonEmpty((String)config.getPushGatewayLabels())) {
            LABEL_PATTERN.splitAsStream(config.getPushGatewayLabels().trim()).map(s -> s.split(":", 2)).forEach(parts -> {
                labelNames.add(parts[0]);
                labelValues.add(parts[1]);
            });
        }
        this.metricExports = new DropwizardExports(registry, (SampleBuilder)new LabeledSampleBuilder(labelNames, labelValues));
        this.collectorRegistry = PORT_TO_COLLECTOR_REGISTRY.get(this.serverPort);
        this.metricExports.register(this.collectorRegistry);
    }

    private static synchronized void startHttpServer(int serverPort) {
        if (!PORT_TO_COLLECTOR_REGISTRY.containsKey(serverPort)) {
            PORT_TO_COLLECTOR_REGISTRY.put(serverPort, new CollectorRegistry());
        }
        if (!PORT_TO_SERVER.containsKey(serverPort)) {
            try {
                HTTPServer server = new HTTPServer(new InetSocketAddress(serverPort), PORT_TO_COLLECTOR_REGISTRY.get(serverPort));
                PORT_TO_SERVER.put(serverPort, server);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> ((HTTPServer)server).stop()));
            }
            catch (Exception e) {
                String msg = "Could not start PrometheusReporter HTTP server on port " + serverPort;
                LOG.error(msg, (Throwable)e);
                throw new HoodieException(msg, (Throwable)e);
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void report() {
    }

    @Override
    public void stop() {
        this.collectorRegistry.unregister((Collector)this.metricExports);
        HTTPServer httpServer = PORT_TO_SERVER.remove(this.serverPort);
        if (httpServer != null) {
            httpServer.stop();
        }
        PORT_TO_COLLECTOR_REGISTRY.remove(this.serverPort);
    }

    private static class LabeledSampleBuilder
    implements SampleBuilder {
        private final DefaultSampleBuilder defaultMetricSampleBuilder = new DefaultSampleBuilder();
        private final List<String> labelNames;
        private final List<String> labelValues;

        public LabeledSampleBuilder(List<String> labelNames, List<String> labelValues) {
            this.labelNames = labelNames;
            this.labelValues = labelValues;
        }

        public Collector.MetricFamilySamples.Sample createSample(String dropwizardName, String nameSuffix, List<String> additionalLabelNames, List<String> additionalLabelValues, double value) {
            return this.defaultMetricSampleBuilder.createSample(dropwizardName, nameSuffix, this.labelNames, this.labelValues, value);
        }
    }
}

