/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.cdc.HoodieCDCOperation;
import org.apache.hudi.common.table.cdc.HoodieCDCSupplementalLoggingMode;
import org.apache.hudi.common.table.cdc.HoodieCDCUtils;
import org.apache.hudi.common.table.log.AppendResult;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieCDCDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieUpsertException;

public class HoodieCDCLogger
implements Closeable {
    private final String commitTime;
    private final String keyField;
    private final String partitionPath;
    private final FileSystem fs;
    private final Schema dataSchema;
    private final HoodieLogFormat.Writer cdcWriter;
    private final HoodieCDCSupplementalLoggingMode cdcSupplementalLoggingMode;
    private final Schema cdcSchema;
    private final ExternalSpillableMap<String, HoodieAvroPayload> cdcData;
    private final Map<HoodieLogBlock.HeaderMetadataType, String> cdcDataBlockHeader;
    private final CDCTransformer transformer;
    private final long maxBlockSize;
    private long averageCDCRecordSize = 0L;
    private AtomicInteger numOfCDCRecordsInMemory = new AtomicInteger();
    private final SizeEstimator<HoodieAvroPayload> sizeEstimator;
    private final List<Path> cdcAbsPaths;

    public HoodieCDCLogger(String commitTime, HoodieWriteConfig config, HoodieTableConfig tableConfig, String partitionPath, FileSystem fs, Schema schema, HoodieLogFormat.Writer cdcWriter, long maxInMemorySizeInBytes) {
        try {
            this.commitTime = commitTime;
            this.keyField = config.populateMetaFields() ? HoodieRecord.RECORD_KEY_METADATA_FIELD : tableConfig.getRecordKeyFieldProp();
            this.partitionPath = partitionPath;
            this.fs = fs;
            this.dataSchema = HoodieAvroUtils.removeMetadataFields((Schema)schema);
            this.cdcWriter = cdcWriter;
            this.cdcSupplementalLoggingMode = tableConfig.cdcSupplementalLoggingMode();
            this.cdcSchema = HoodieCDCUtils.schemaBySupplementalLoggingMode((HoodieCDCSupplementalLoggingMode)this.cdcSupplementalLoggingMode, (Schema)this.dataSchema);
            this.cdcDataBlockHeader = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
            this.cdcDataBlockHeader.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, commitTime);
            this.cdcDataBlockHeader.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, this.cdcSchema.toString());
            this.sizeEstimator = new DefaultSizeEstimator();
            this.cdcData = new ExternalSpillableMap(Long.valueOf(maxInMemorySizeInBytes), config.getSpillableMapBasePath(), (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new DefaultSizeEstimator(), config.getCommonConfig().getSpillableDiskMapType(), config.getCommonConfig().isBitCaskDiskMapCompressionEnabled());
            this.transformer = this.getTransformer();
            this.maxBlockSize = config.getLogFileDataBlockMaxSize();
            this.cdcAbsPaths = new ArrayList<Path>();
        }
        catch (IOException e) {
            throw new HoodieUpsertException("Failed to initialize HoodieCDCLogger", e);
        }
    }

    public void put(HoodieRecord hoodieRecord, GenericRecord oldRecord, Option<IndexedRecord> newRecord) {
        GenericData.Record cdcRecord;
        String recordKey = hoodieRecord.getRecordKey();
        if (newRecord.isPresent()) {
            GenericRecord record = (GenericRecord)newRecord.get();
            cdcRecord = oldRecord == null ? this.transformer.transform(HoodieCDCOperation.INSERT, recordKey, null, record) : this.transformer.transform(HoodieCDCOperation.UPDATE, recordKey, oldRecord, record);
        } else {
            cdcRecord = this.transformer.transform(HoodieCDCOperation.DELETE, recordKey, oldRecord, null);
        }
        this.flushIfNeeded(false);
        HoodieAvroPayload payload = new HoodieAvroPayload(Option.of((Object)cdcRecord));
        if (this.cdcData.isEmpty()) {
            this.averageCDCRecordSize = this.sizeEstimator.sizeEstimate((Object)payload);
        }
        this.cdcData.put((Serializable)((Object)recordKey), (Serializable)payload);
        this.numOfCDCRecordsInMemory.incrementAndGet();
    }

    private void flushIfNeeded(Boolean force) {
        if (force.booleanValue() || (long)this.numOfCDCRecordsInMemory.get() * this.averageCDCRecordSize >= this.maxBlockSize) {
            try {
                ArrayList<HoodieAvroIndexedRecord> records = new ArrayList<HoodieAvroIndexedRecord>();
                for (HoodieAvroPayload record : this.cdcData) {
                    try {
                        records.add(new HoodieAvroIndexedRecord((IndexedRecord)record.getInsertValue(this.cdcSchema).get()));
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to get cdc record", e);
                    }
                }
                HoodieCDCDataBlock block = new HoodieCDCDataBlock(records, this.cdcDataBlockHeader, this.keyField);
                AppendResult result = this.cdcWriter.appendBlocks(Collections.singletonList(block));
                Path cdcAbsPath = result.logFile().getPath();
                if (!this.cdcAbsPaths.contains(cdcAbsPath)) {
                    this.cdcAbsPaths.add(cdcAbsPath);
                }
                this.cdcData.clear();
                this.numOfCDCRecordsInMemory = new AtomicInteger();
            }
            catch (Exception e) {
                throw new HoodieException("Failed to write the cdc data to " + this.cdcWriter.getLogFile().getPath(), (Throwable)e);
            }
        }
    }

    public Map<String, Long> getCDCWriteStats() {
        HashMap<String, Long> stats = new HashMap<String, Long>();
        try {
            for (Path cdcAbsPath : this.cdcAbsPaths) {
                String cdcFileName = cdcAbsPath.getName();
                String cdcPath = StringUtils.isNullOrEmpty((String)this.partitionPath) ? cdcFileName : this.partitionPath + "/" + cdcFileName;
                stats.put(cdcPath, FSUtils.getFileSize((FileSystem)this.fs, (Path)cdcAbsPath));
            }
        }
        catch (IOException e) {
            throw new HoodieUpsertException("Failed to get cdc write stat", e);
        }
        return stats;
    }

    @Override
    public void close() {
        try {
            this.flushIfNeeded(true);
            if (this.cdcWriter != null) {
                this.cdcWriter.close();
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to close HoodieCDCLogger", e);
        }
        finally {
            this.cdcData.clear();
        }
    }

    private CDCTransformer getTransformer() {
        if (this.cdcSupplementalLoggingMode == HoodieCDCSupplementalLoggingMode.DATA_BEFORE_AFTER) {
            return (operation, recordKey, oldRecord, newRecord) -> HoodieCDCUtils.cdcRecord((Schema)this.cdcSchema, (String)operation.getValue(), (String)this.commitTime, (GenericRecord)this.removeCommitMetadata(oldRecord), (GenericRecord)this.removeCommitMetadata(newRecord));
        }
        if (this.cdcSupplementalLoggingMode == HoodieCDCSupplementalLoggingMode.DATA_BEFORE) {
            return (operation, recordKey, oldRecord, newRecord) -> HoodieCDCUtils.cdcRecord((Schema)this.cdcSchema, (String)operation.getValue(), (String)recordKey, (GenericRecord)this.removeCommitMetadata(oldRecord));
        }
        return (operation, recordKey, oldRecord, newRecord) -> HoodieCDCUtils.cdcRecord((Schema)this.cdcSchema, (String)operation.getValue(), (String)recordKey);
    }

    private GenericRecord removeCommitMetadata(GenericRecord record) {
        return record == null ? null : HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)record, (Schema)this.dataSchema, Collections.emptyMap());
    }

    private static interface CDCTransformer {
        public GenericData.Record transform(HoodieCDCOperation var1, String var2, GenericRecord var3, GenericRecord var4);
    }
}

