/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.lock.LockState;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieLockException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InProcessLockProvider
implements LockProvider<ReentrantReadWriteLock>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(InProcessLockProvider.class);
    private static final Map<String, ReentrantReadWriteLock> LOCK_INSTANCE_PER_BASEPATH = new ConcurrentHashMap<String, ReentrantReadWriteLock>();
    private final ReentrantReadWriteLock lock;
    private final String basePath;
    private final long maxWaitTimeMillis;

    public InProcessLockProvider(LockConfiguration lockConfiguration, Configuration conf) {
        TypedProperties typedProperties = lockConfiguration.getConfig();
        this.basePath = lockConfiguration.getConfig().getProperty(HoodieWriteConfig.BASE_PATH.key());
        ValidationUtils.checkArgument((this.basePath != null ? 1 : 0) != 0);
        this.lock = LOCK_INSTANCE_PER_BASEPATH.computeIfAbsent(this.basePath, ignore -> new ReentrantReadWriteLock());
        this.maxWaitTimeMillis = typedProperties.getLong("hoodie.write.lock.wait_time_ms", 60000L);
    }

    public void lock() {
        LOG.info(this.getLogMessage(LockState.ACQUIRING));
        if (this.lock.isWriteLockedByCurrentThread()) {
            throw new HoodieLockException(this.getLogMessage(LockState.ALREADY_ACQUIRED));
        }
        this.lock.writeLock().lock();
        LOG.info(this.getLogMessage(LockState.ACQUIRED));
    }

    public boolean tryLock() {
        return this.tryLock(this.maxWaitTimeMillis, TimeUnit.MILLISECONDS);
    }

    public boolean tryLock(long time, @NotNull TimeUnit unit) {
        boolean isLockAcquired;
        LOG.info(this.getLogMessage(LockState.ACQUIRING));
        if (this.lock.isWriteLockedByCurrentThread()) {
            throw new HoodieLockException(this.getLogMessage(LockState.ALREADY_ACQUIRED));
        }
        try {
            isLockAcquired = this.lock.writeLock().tryLock(time, unit);
        }
        catch (InterruptedException e) {
            throw new HoodieLockException(this.getLogMessage(LockState.FAILED_TO_ACQUIRE));
        }
        LOG.info(this.getLogMessage(isLockAcquired ? LockState.ACQUIRED : LockState.FAILED_TO_ACQUIRE));
        return isLockAcquired;
    }

    public void unlock() {
        LOG.info(this.getLogMessage(LockState.RELEASING));
        try {
            if (this.lock.isWriteLockedByCurrentThread()) {
                this.lock.writeLock().unlock();
                LOG.info(this.getLogMessage(LockState.RELEASED));
            } else {
                LOG.warn("Cannot unlock because the current thread does not hold the lock.");
            }
        }
        catch (Exception e) {
            throw new HoodieLockException(this.getLogMessage(LockState.FAILED_TO_RELEASE), (Throwable)e);
        }
    }

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public void close() {
        if (this.lock.isWriteLockedByCurrentThread()) {
            this.lock.writeLock().unlock();
        }
        LOG.info(this.getLogMessage(LockState.ALREADY_RELEASED));
    }

    private String getLogMessage(LockState state) {
        return String.format("Base Path %s, Lock Instance %s, Thread %s, In-process lock state %s", this.basePath, this.getLock().toString(), Thread.currentThread().getName(), state.name());
    }
}

