/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.bootstrap;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.common.bootstrap.FileStatusUtils;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.collection.Pair;

public class BootstrapUtils {
    public static List<Pair<String, List<HoodieFileStatus>>> getAllLeafFoldersWithFiles(HoodieTableMetaClient metaClient, FileSystem fs, String basePathStr, HoodieEngineContext context) throws IOException {
        Path basePath = new Path(basePathStr);
        String baseFileExtension = metaClient.getTableConfig().getBaseFileFormat().getFileExtension();
        HashMap levelToPartitions = new HashMap();
        HashMap partitionToFiles = new HashMap();
        PathFilter filePathFilter = BootstrapUtils.getFilePathFilter(baseFileExtension);
        PathFilter metaPathFilter = BootstrapUtils.getExcludeMetaPathFilter();
        FileStatus[] topLevelStatuses = fs.listStatus(basePath);
        ArrayList<String> subDirectories = new ArrayList<String>();
        ArrayList<Pair> result = new ArrayList<Pair>();
        for (FileStatus topLevelStatus : topLevelStatuses) {
            if (topLevelStatus.isFile() && filePathFilter.accept(topLevelStatus.getPath())) {
                String relativePath = FSUtils.getRelativePartitionPath((Path)basePath, (Path)topLevelStatus.getPath().getParent());
                Integer level = (int)relativePath.chars().filter(ch -> ch == 47).count();
                HoodieFileStatus hoodieFileStatus = FileStatusUtils.fromFileStatus((FileStatus)topLevelStatus);
                result.add(Pair.of((Object)hoodieFileStatus, (Object)Pair.of((Object)level, (Object)relativePath)));
                continue;
            }
            if (!topLevelStatus.isDirectory() || !metaPathFilter.accept(topLevelStatus.getPath())) continue;
            subDirectories.add(topLevelStatus.getPath().toString());
        }
        if (subDirectories.size() > 0) {
            result.addAll(context.flatMap(subDirectories, (SerializableFunction & Serializable)directory -> {
                PathFilter pathFilter = BootstrapUtils.getFilePathFilter(baseFileExtension);
                Path path = new Path(directory);
                FileSystem fileSystem = path.getFileSystem(new Configuration());
                RemoteIterator itr = fileSystem.listFiles(path, true);
                ArrayList<Pair> res = new ArrayList<Pair>();
                while (itr.hasNext()) {
                    FileStatus status = (FileStatus)itr.next();
                    if (!pathFilter.accept(status.getPath())) continue;
                    String relativePath = FSUtils.getRelativePartitionPath((Path)new Path(basePathStr), (Path)status.getPath().getParent());
                    Integer level = (int)relativePath.chars().filter(ch -> ch == 47).count();
                    HoodieFileStatus hoodieFileStatus = FileStatusUtils.fromFileStatus((FileStatus)status);
                    res.add(Pair.of((Object)hoodieFileStatus, (Object)Pair.of((Object)level, (Object)relativePath)));
                }
                return res.stream();
            }, subDirectories.size()));
        }
        result.forEach(val -> {
            String relativePath = (String)((Pair)val.getRight()).getRight();
            ArrayList<Object> statusList = (ArrayList<Object>)partitionToFiles.get(relativePath);
            if (null == statusList) {
                Integer level = (Integer)((Pair)val.getRight()).getLeft();
                ArrayList<String> dirs = (ArrayList<String>)levelToPartitions.get(level);
                if (null == dirs) {
                    dirs = new ArrayList<String>();
                    levelToPartitions.put(level, dirs);
                }
                dirs.add(relativePath);
                statusList = new ArrayList<Object>();
                partitionToFiles.put(relativePath, statusList);
            }
            statusList.add(val.getLeft());
        });
        OptionalInt maxLevelOpt = levelToPartitions.keySet().stream().mapToInt(x -> x).max();
        int maxLevel = maxLevelOpt.orElse(-1);
        return maxLevel >= 0 ? ((List)levelToPartitions.get(maxLevel)).stream().map(d -> Pair.of((Object)d, partitionToFiles.get(d))).collect(Collectors.toList()) : new ArrayList<Pair<String, List<HoodieFileStatus>>>();
    }

    private static PathFilter getFilePathFilter(String baseFileExtension) {
        return path -> path.getName().endsWith(baseFileExtension);
    }

    private static PathFilter getExcludeMetaPathFilter() {
        return path -> !path.toString().contains(".hoodie");
    }
}

