/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.util.Arrays;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;

@ConfigClassProperty(name="Error table Configs", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configurations that are required for Error table configs")
@Immutable
public class HoodieErrorTableConfig {
    public static final ConfigProperty<Boolean> ERROR_TABLE_ENABLED = ConfigProperty.key((String)"hoodie.errortable.enable").defaultValue((Object)false).withDocumentation("Config to enable error table. If the config is enabled, all the records with processing error in DeltaStreamer are transferred to error table.");
    public static final ConfigProperty<String> ERROR_TABLE_BASE_PATH = ConfigProperty.key((String)"hoodie.errortable.base.path").noDefaultValue().withDocumentation("Base path for error table under which all error records would be stored.");
    public static final ConfigProperty<String> ERROR_TARGET_TABLE = ConfigProperty.key((String)"hoodie.errortable.target.table.name").noDefaultValue().withDocumentation("Table name to be used for the error table");
    public static final ConfigProperty<Integer> ERROR_TABLE_UPSERT_PARALLELISM_VALUE = ConfigProperty.key((String)"hoodie.errortable.upsert.shuffle.parallelism").defaultValue((Object)200).withDocumentation("Config to set upsert shuffle parallelism. The config is similar to hoodie.upsert.shuffle.parallelism config but applies to the error table.");
    public static final ConfigProperty<Integer> ERROR_TABLE_INSERT_PARALLELISM_VALUE = ConfigProperty.key((String)"hoodie.errortable.insert.shuffle.parallelism").defaultValue((Object)200).withDocumentation("Config to set insert shuffle parallelism. The config is similar to hoodie.insert.shuffle.parallelism config but applies to the error table.");
    public static final ConfigProperty<String> ERROR_TABLE_WRITE_CLASS = ConfigProperty.key((String)"hoodie.errortable.write.class").noDefaultValue().withDocumentation("Class which handles the error table writes. This config is used to configure a custom implementation for Error Table Writer. Specify the full class name of the custom error table writer as a value for this config");
    public static final ConfigProperty<Boolean> ERROR_ENABLE_VALIDATE_TARGET_SCHEMA = ConfigProperty.key((String)"hoodie.errortable.validate.targetschema.enable").defaultValue((Object)false).withDocumentation("Records with schema mismatch with Target Schema are sent to Error Table.");
    public static final ConfigProperty<String> ERROR_TABLE_WRITE_FAILURE_STRATEGY = ConfigProperty.key((String)"hoodie.errortable.write.failure.strategy").defaultValue((Object)ErrorWriteFailureStrategy.ROLLBACK_COMMIT.name()).withDocumentation("The config specifies the failure strategy if error table write fails. Use one of - " + Arrays.toString((Object[])ErrorWriteFailureStrategy.values()));

    public static enum ErrorWriteFailureStrategy {
        ROLLBACK_COMMIT("Rollback the corresponding base table write commit for which the error events were triggered"),
        LOG_ERROR("Error is logged but the base table write succeeds");

        private final String description;

        private ErrorWriteFailureStrategy(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return super.toString() + " (" + this.description + ")\n";
        }
    }
}

