/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.client.transaction.lock.metrics.HoodieLockMetrics;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieLockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManager
implements Serializable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(LockManager.class);
    private final HoodieWriteConfig writeConfig;
    private final LockConfiguration lockConfiguration;
    private final SerializableConfiguration hadoopConf;
    private final int maxRetries;
    private final long maxWaitTimeInMs;
    private transient HoodieLockMetrics metrics;
    private volatile LockProvider lockProvider;

    public LockManager(HoodieWriteConfig writeConfig, FileSystem fs) {
        this(writeConfig, fs, writeConfig.getProps());
    }

    public LockManager(HoodieWriteConfig writeConfig, FileSystem fs, TypedProperties lockProps) {
        this.writeConfig = writeConfig;
        this.hadoopConf = new SerializableConfiguration(fs.getConf());
        this.lockConfiguration = new LockConfiguration((Properties)lockProps);
        this.maxRetries = this.lockConfiguration.getConfig().getInteger("hoodie.write.lock.client.num_retries", Integer.parseInt((String)HoodieLockConfig.LOCK_ACQUIRE_CLIENT_NUM_RETRIES.defaultValue()));
        this.maxWaitTimeInMs = this.lockConfiguration.getConfig().getLong("hoodie.write.lock.client.wait_time_ms_between_retry", Long.parseLong((String)HoodieLockConfig.LOCK_ACQUIRE_CLIENT_RETRY_WAIT_TIME_IN_MILLIS.defaultValue()));
        this.metrics = new HoodieLockMetrics(writeConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        LockProvider lockProvider = this.getLockProvider();
        int retryCount = 0;
        boolean acquired = false;
        while (retryCount <= this.maxRetries) {
            try {
                this.metrics.startLockApiTimerContext();
                acquired = lockProvider.tryLock(this.writeConfig.getLockAcquireWaitTimeoutInMs().longValue(), TimeUnit.MILLISECONDS);
                if (acquired) {
                    this.metrics.updateLockAcquiredMetric();
                    break;
                }
                this.metrics.updateLockNotAcquiredMetric();
                LOG.info("Retrying to acquire lock. Current lock owner information : " + lockProvider.getCurrentOwnerLockInfo());
                Thread.sleep(this.maxWaitTimeInMs);
            }
            catch (InterruptedException | HoodieLockException e) {
                this.metrics.updateLockNotAcquiredMetric();
                if (retryCount >= this.maxRetries) {
                    throw new HoodieLockException("Unable to acquire lock, lock object " + lockProvider.getLock(), e);
                }
                try {
                    Thread.sleep(this.maxWaitTimeInMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                ++retryCount;
            }
        }
        if (!acquired) {
            throw new HoodieLockException("Unable to acquire lock, lock object " + lockProvider.getLock());
        }
    }

    public void unlock() {
        this.getLockProvider().unlock();
        this.metrics.updateLockHeldTimerMetrics();
        this.close();
    }

    public synchronized LockProvider getLockProvider() {
        if (this.lockProvider == null) {
            LOG.info("LockProvider " + this.writeConfig.getLockProviderClass());
            this.lockProvider = (LockProvider)ReflectionUtils.loadClass((String)this.writeConfig.getLockProviderClass(), (Object[])new Object[]{this.lockConfiguration, this.hadoopConf.get()});
        }
        return this.lockProvider;
    }

    @Override
    public void close() {
        this.closeQuietly();
    }

    private void closeQuietly() {
        try {
            if (this.lockProvider != null) {
                this.lockProvider.close();
                LOG.info("Released connection created for acquiring lock");
                this.lockProvider = null;
            }
        }
        catch (Exception e) {
            LOG.error("Unable to close and release connection created for acquiring lock", (Throwable)e);
        }
    }
}

