/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.io.HoodieReadHandle;
import org.apache.hudi.io.IOUtils;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.table.HoodieTable;

public class HoodieMergedReadHandle<T, I, K, O>
extends HoodieReadHandle<T, I, K, O> {
    protected final Schema readerSchema;

    public HoodieMergedReadHandle(HoodieWriteConfig config, Option<String> instantTime, HoodieTable<T, I, K, O> hoodieTable, Pair<String, String> partitionPathFileIDPair) {
        super(config, instantTime, hoodieTable, partitionPathFileIDPair);
        this.readerSchema = HoodieAvroUtils.addMetadataFields((Schema)new Schema.Parser().parse(config.getSchema()), (boolean)config.allowOperationMetadataField());
    }

    public List<HoodieRecord<T>> getMergedRecords() {
        Option<FileSlice> fileSliceOpt = this.getLatestFileSlice();
        if (!fileSliceOpt.isPresent()) {
            return Collections.emptyList();
        }
        ValidationUtils.checkState((boolean)StringUtils.nonEmpty((String)this.instantTime), (String)String.format("Expected a valid instant time but got `%s`", this.instantTime));
        FileSlice fileSlice = (FileSlice)fileSliceOpt.get();
        HoodieRecordLocation currentLocation = new HoodieRecordLocation(this.instantTime, fileSlice.getFileId());
        Option<HoodieFileReader> baseFileReader = Option.empty();
        HoodieMergedLogRecordScanner logRecordScanner = null;
        try {
            baseFileReader = this.getBaseFileReader(fileSlice);
            logRecordScanner = this.getLogRecordScanner(fileSlice);
            ArrayList mergedRecords = new ArrayList();
            this.doMergedRead(baseFileReader, logRecordScanner).forEach(r -> {
                r.unseal();
                r.setCurrentLocation(currentLocation);
                r.seal();
                mergedRecords.add((HoodieRecord)r);
            });
            ArrayList arrayList = mergedRecords;
            return arrayList;
        }
        catch (IOException e) {
            throw new HoodieIndexException("Error in reading " + fileSlice, (Throwable)e);
        }
        finally {
            if (baseFileReader.isPresent()) {
                ((HoodieFileReader)baseFileReader.get()).close();
            }
            if (logRecordScanner != null) {
                logRecordScanner.close();
            }
        }
    }

    private Option<FileSlice> getLatestFileSlice() {
        if (StringUtils.nonEmpty((String)this.instantTime) && this.hoodieTable.getMetaClient().getCommitsTimeline().filterCompletedInstants().lastInstant().isPresent()) {
            return Option.fromJavaOptional(this.hoodieTable.getHoodieView().getLatestMergedFileSlicesBeforeOrOn((String)this.partitionPathFileIDPair.getLeft(), this.instantTime).filter(fileSlice -> fileSlice.getFileId().equals(this.partitionPathFileIDPair.getRight())).findFirst());
        }
        return Option.empty();
    }

    private Option<HoodieFileReader> getBaseFileReader(FileSlice fileSlice) throws IOException {
        if (fileSlice.getBaseFile().isPresent()) {
            return Option.of((Object)this.createNewFileReader((HoodieBaseFile)fileSlice.getBaseFile().get()));
        }
        return Option.empty();
    }

    private HoodieMergedLogRecordScanner getLogRecordScanner(FileSlice fileSlice) {
        List logFilePaths = fileSlice.getLogFiles().sorted(HoodieLogFile.getLogFileComparator()).map(l -> l.getPath().toString()).collect(Collectors.toList());
        return HoodieMergedLogRecordScanner.newBuilder().withFileSystem((FileSystem)this.hoodieTable.getMetaClient().getFs()).withBasePath(this.hoodieTable.getMetaClient().getBasePathV2().toString()).withLogFilePaths(logFilePaths).withReaderSchema(this.readerSchema).withLatestInstantTime(this.instantTime).withMaxMemorySizeInBytes(Long.valueOf(IOUtils.getMaxMemoryPerCompaction(this.hoodieTable.getTaskContextSupplier(), this.config))).withReadBlocksLazily(this.config.getCompactionLazyBlockReadEnabled().booleanValue()).withReverseReader(this.config.getCompactionReverseLogReadEnabled().booleanValue()).withBufferSize(this.config.getMaxDFSStreamBufferSize()).withSpillableMapBasePath(this.config.getSpillableMapBasePath()).withPartition(fileSlice.getPartitionPath()).withOptimizedLogBlocksScan(this.config.enableOptimizedLogBlocksScan()).withDiskMapType(this.config.getCommonConfig().getSpillableDiskMapType()).withBitCaskDiskMapCompressionEnabled(this.config.getCommonConfig().isBitCaskDiskMapCompressionEnabled()).withRecordMerger(this.config.getRecordMerger()).build();
    }

    private List<HoodieRecord<T>> doMergedRead(Option<HoodieFileReader> baseFileReaderOpt, HoodieMergedLogRecordScanner logRecordScanner) throws IOException {
        ArrayList<HoodieRecord<T>> mergedRecords = new ArrayList<HoodieRecord<T>>();
        Map deltaRecordMap = logRecordScanner.getRecords();
        HashSet deltaRecordKeys = new HashSet(deltaRecordMap.keySet());
        if (baseFileReaderOpt.isPresent()) {
            Option simpleKeyGenFieldsOpt;
            HoodieFileReader baseFileReader = (HoodieFileReader)baseFileReaderOpt.get();
            HoodieRecordMerger recordMerger = this.config.getRecordMerger();
            ClosableIterator baseFileItr = baseFileReader.getRecordIterator(this.readerSchema);
            HoodieTableConfig tableConfig = this.hoodieTable.getMetaClient().getTableConfig();
            Option option = simpleKeyGenFieldsOpt = tableConfig.populateMetaFields() ? Option.empty() : Option.of((Object)Pair.of((Object)tableConfig.getRecordKeyFieldProp(), (Object)tableConfig.getPartitionFieldProp()));
            while (baseFileItr.hasNext()) {
                HoodieRecord record = ((HoodieRecord)baseFileItr.next()).wrapIntoHoodieRecordPayloadWithParams(this.readerSchema, (Properties)this.config.getProps(), simpleKeyGenFieldsOpt, Boolean.valueOf(logRecordScanner.isWithOperationField()), logRecordScanner.getPartitionNameOverride(), Boolean.valueOf(false), Option.empty());
                String key = record.getRecordKey();
                if (deltaRecordMap.containsKey(key)) {
                    deltaRecordKeys.remove(key);
                    Option mergeResult = recordMerger.merge(record, this.readerSchema, (HoodieRecord)deltaRecordMap.get(key), this.readerSchema, this.config.getPayloadConfig().getProps());
                    if (!mergeResult.isPresent()) continue;
                    HoodieRecord r = ((HoodieRecord)((Pair)mergeResult.get()).getLeft()).wrapIntoHoodieRecordPayloadWithParams(this.readerSchema, (Properties)this.config.getProps(), simpleKeyGenFieldsOpt, Boolean.valueOf(logRecordScanner.isWithOperationField()), logRecordScanner.getPartitionNameOverride(), Boolean.valueOf(false), Option.empty());
                    mergedRecords.add(r);
                    continue;
                }
                mergedRecords.add(record.copy());
            }
        }
        for (String key : deltaRecordKeys) {
            mergedRecords.add((HoodieRecord<T>)deltaRecordMap.get(key));
        }
        return mergedRecords;
    }
}

