/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieCreateHandle;
import org.apache.hudi.table.HoodieTable;

public class HoodieBootstrapHandle<T, I, K, O>
extends HoodieCreateHandle<T, I, K, O> {
    public static final Schema METADATA_BOOTSTRAP_RECORD_SCHEMA = HoodieBootstrapHandle.createMetadataBootstrapRecordSchema();

    public HoodieBootstrapHandle(HoodieWriteConfig config, String commitTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier) {
        super(config, commitTime, hoodieTable, partitionPath, fileId, (Option<Schema>)Option.of((Object)METADATA_BOOTSTRAP_RECORD_SCHEMA), taskContextSupplier);
    }

    @Override
    public boolean canWrite(HoodieRecord record) {
        return true;
    }

    private static Schema createMetadataBootstrapRecordSchema() {
        List fields = HoodieRecord.HOODIE_META_COLUMNS.stream().map(metaField -> new Schema.Field(metaField, AvroSchemaUtils.createNullableSchema((Schema.Type)Schema.Type.STRING), "", (Object)JsonProperties.NULL_VALUE)).collect(Collectors.toList());
        return Schema.createRecord((String)"HoodieRecordKey", (String)"", (String)"", (boolean)false, fields);
    }
}

