/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieIndexCommitMetadata;
import org.apache.hudi.avro.model.HoodieIndexPlan;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.callback.HoodieWriteCommitCallback;
import org.apache.hudi.callback.common.HoodieWriteCommitCallbackMessage;
import org.apache.hudi.callback.util.HoodieCommitCallbackFactory;
import org.apache.hudi.client.BaseHoodieClient;
import org.apache.hudi.client.BaseHoodieTableServiceClient;
import org.apache.hudi.client.RunsTableService;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.heartbeat.HeartbeatUtils;
import org.apache.hudi.client.utils.TransactionUtils;
import org.apache.hudi.common.HoodiePendingRollbackInfo;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieRestoreException;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.action.InternalSchemaChangeApplier;
import org.apache.hudi.internal.schema.action.TableChange;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.io.FileBasedInternalSchemaStorageManager;
import org.apache.hudi.internal.schema.utils.AvroSchemaEvolutionUtils;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.restore.RestoreUtils;
import org.apache.hudi.table.action.savepoint.SavepointHelpers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHoodieWriteClient<T, I, K, O>
extends BaseHoodieClient
implements RunsTableService {
    protected static final String LOOKUP_STR = "lookup";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(BaseHoodieWriteClient.class);
    private final transient HoodieIndex<?, ?> index;
    private final SupportsUpgradeDowngrade upgradeDowngradeHelper;
    private transient WriteOperationType operationType;
    private transient HoodieWriteCommitCallback commitCallback;
    protected transient Timer.Context writeTimer = null;
    protected Option<Pair<HoodieInstant, Map<String, String>>> lastCompletedTxnAndMetadata = Option.empty();
    protected Set<String> pendingInflightAndRequestedInstants = Collections.emptySet();
    protected BaseHoodieTableServiceClient<?, ?, O> tableServiceClient;

    @Deprecated
    public BaseHoodieWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        this(context, writeConfig, (Option<EmbeddedTimelineService>)Option.empty(), upgradeDowngradeHelper);
    }

    @Deprecated
    public BaseHoodieWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, Option<EmbeddedTimelineService> timelineService, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        super(context, writeConfig, timelineService);
        this.index = this.createIndex(writeConfig);
        this.upgradeDowngradeHelper = upgradeDowngradeHelper;
    }

    protected abstract HoodieIndex<?, ?> createIndex(HoodieWriteConfig var1);

    public void setOperationType(WriteOperationType operationType) {
        this.operationType = operationType;
    }

    public WriteOperationType getOperationType() {
        return this.operationType;
    }

    public BaseHoodieTableServiceClient<?, ?, O> getTableServiceClient() {
        return this.tableServiceClient;
    }

    public boolean commit(String instantTime, O writeStatuses) {
        return this.commit(instantTime, writeStatuses, (Option<Map<String, String>>)Option.empty());
    }

    public boolean commit(String instantTime, O writeStatuses, Option<Map<String, String>> extraMetadata) {
        HoodieTableMetaClient metaClient = this.createMetaClient(false);
        String actionType = metaClient.getCommitActionType();
        return this.commit(instantTime, writeStatuses, extraMetadata, actionType, Collections.emptyMap());
    }

    public boolean commit(String instantTime, O writeStatuses, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplacedFileIds) {
        return this.commit(instantTime, writeStatuses, extraMetadata, commitActionType, partitionToReplacedFileIds, (Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>>)Option.empty());
    }

    public abstract boolean commit(String var1, O var2, Option<Map<String, String>> var3, String var4, Map<String, List<String>> var5, Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> var6);

    public boolean commitStats(String instantTime, HoodieData<WriteStatus> writeStatuses, List<HoodieWriteStat> stats, Option<Map<String, String>> extraMetadata, String commitActionType) {
        return this.commitStats(instantTime, writeStatuses, stats, extraMetadata, commitActionType, Collections.emptyMap(), (Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>>)Option.empty());
    }

    public boolean commitStats(String instantTime, HoodieData<WriteStatus> writeStatuses, List<HoodieWriteStat> stats, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplaceFileIds, Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> extraPreCommitFunc) {
        if (!this.config.allowEmptyCommit() && stats.isEmpty()) {
            return true;
        }
        LOG.info("Committing " + instantTime + " action " + commitActionType);
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        HoodieCommitMetadata metadata = CommitUtils.buildMetadata(stats, partitionToReplaceFileIds, extraMetadata, (WriteOperationType)this.operationType, (String)this.config.getWriteSchema(), (String)commitActionType);
        HoodieInstant inflightInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, commitActionType, instantTime);
        HeartbeatUtils.abortIfHeartbeatExpired(instantTime, table, this.heartbeatClient, this.config);
        this.txnManager.beginTransaction((Option<HoodieInstant>)Option.of((Object)inflightInstant), (Option<HoodieInstant>)(this.lastCompletedTxnAndMetadata.isPresent() ? Option.of((Object)((Pair)this.lastCompletedTxnAndMetadata.get()).getLeft()) : Option.empty()));
        try {
            this.preCommit(inflightInstant, metadata);
            if (extraPreCommitFunc.isPresent()) {
                ((BiConsumer)extraPreCommitFunc.get()).accept(table.getMetaClient(), metadata);
            }
            this.commit(table, commitActionType, instantTime, metadata, stats, writeStatuses);
            this.postCommit(table, metadata, instantTime, extraMetadata);
            LOG.info("Committed " + instantTime);
            this.releaseResources(instantTime);
        }
        catch (IOException e) {
            throw new HoodieCommitException("Failed to complete commit " + this.config.getBasePath() + " at time " + instantTime, e);
        }
        finally {
            this.txnManager.endTransaction((Option<HoodieInstant>)Option.of((Object)inflightInstant));
        }
        this.mayBeCleanAndArchive(table);
        try {
            this.runTableServicesInline(table, metadata, extraMetadata);
        }
        catch (Exception e) {
            if (this.config.isFailOnInlineTableServiceExceptionEnabled()) {
                throw e;
            }
            LOG.warn("Inline compaction or clustering failed with exception: " + e.getMessage() + ". Moving further since \"hoodie.fail.writes.on.inline.table.service.exception\" is set to false.");
        }
        this.emitCommitMetrics(instantTime, metadata, commitActionType);
        if (this.config.writeCommitCallbackOn()) {
            if (null == this.commitCallback) {
                this.commitCallback = HoodieCommitCallbackFactory.create(this.config);
            }
            this.commitCallback.call(new HoodieWriteCommitCallbackMessage(instantTime, this.config.getTableName(), this.config.getBasePath(), stats));
        }
        return true;
    }

    protected void commit(HoodieTable table, String commitActionType, String instantTime, HoodieCommitMetadata metadata, List<HoodieWriteStat> stats, HoodieData<WriteStatus> writeStatuses) throws IOException {
        LOG.info("Committing " + instantTime + " action " + commitActionType);
        HoodieActiveTimeline activeTimeline = table.getActiveTimeline();
        this.finalizeWrite(table, instantTime, stats);
        if (!metadata.getExtraMetadata().containsKey("latest_schema") && metadata.getExtraMetadata().containsKey("schema") && table.getConfig().getSchemaEvolutionEnable()) {
            this.saveInternalSchema(table, instantTime, metadata);
        }
        this.writeTableMetadata(table, instantTime, metadata, writeStatuses);
        activeTimeline.saveAsComplete(new HoodieInstant(true, commitActionType, instantTime), Option.of((Object)metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
    }

    private void saveInternalSchema(HoodieTable table, String instantTime, HoodieCommitMetadata metadata) {
        TableSchemaResolver schemaUtil = new TableSchemaResolver(table.getMetaClient());
        String historySchemaStr = (String)schemaUtil.getTableHistorySchemaStrFromCommitMetadata().orElse((Object)"");
        FileBasedInternalSchemaStorageManager schemasManager = new FileBasedInternalSchemaStorageManager(table.getMetaClient());
        if (!historySchemaStr.isEmpty() || Boolean.parseBoolean(this.config.getString(HoodieCommonConfig.RECONCILE_SCHEMA.key()))) {
            InternalSchema internalSchema;
            Schema avroSchema = HoodieAvroUtils.createHoodieWriteSchema((String)this.config.getSchema(), (boolean)this.config.allowOperationMetadataField());
            if (historySchemaStr.isEmpty()) {
                internalSchema = (InternalSchema)SerDeHelper.fromJson((String)this.config.getInternalSchema()).orElse((Object)AvroInternalSchemaConverter.convert((Schema)avroSchema));
                internalSchema.setSchemaId(Long.parseLong(instantTime));
            } else {
                internalSchema = InternalSchemaUtils.searchSchema((long)Long.parseLong(instantTime), (TreeMap)SerDeHelper.parseSchemas((String)historySchemaStr));
            }
            InternalSchema evolvedSchema = AvroSchemaEvolutionUtils.reconcileSchema((Schema)avroSchema, (InternalSchema)internalSchema);
            if (evolvedSchema.equals((Object)internalSchema)) {
                metadata.addMetadata("latest_schema", SerDeHelper.toJson((InternalSchema)evolvedSchema));
                schemasManager.persistHistorySchemaStr(instantTime, historySchemaStr.isEmpty() ? SerDeHelper.inheritSchemas((InternalSchema)evolvedSchema, (String)"") : historySchemaStr);
            } else {
                evolvedSchema.setSchemaId(Long.parseLong(instantTime));
                String newSchemaStr = SerDeHelper.toJson((InternalSchema)evolvedSchema);
                metadata.addMetadata("latest_schema", newSchemaStr);
                schemasManager.persistHistorySchemaStr(instantTime, SerDeHelper.inheritSchemas((InternalSchema)evolvedSchema, (String)historySchemaStr));
            }
            metadata.addMetadata("schema", AvroInternalSchemaConverter.convert((InternalSchema)evolvedSchema, (String)avroSchema.getFullName()).toString());
        }
    }

    protected abstract HoodieTable<T, I, K, O> createTable(HoodieWriteConfig var1, Configuration var2);

    protected abstract HoodieTable<T, I, K, O> createTable(HoodieWriteConfig var1, Configuration var2, HoodieTableMetaClient var3);

    void emitCommitMetrics(String instantTime, HoodieCommitMetadata metadata, String actionType) {
        if (this.writeTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.writeTimer.stop());
            HoodieActiveTimeline.parseDateFromInstantTimeSafely((String)instantTime).ifPresent(parsedInstant -> this.metrics.updateCommitMetrics(parsedInstant.getTime(), durationInMs, metadata, actionType));
            this.writeTimer = null;
        }
    }

    protected void preCommit(HoodieInstant inflightInstant, HoodieCommitMetadata metadata) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        this.resolveWriteConflict(table, metadata, this.pendingInflightAndRequestedInstants);
    }

    protected void writeTableMetadata(HoodieTable table, String instantTime, HoodieCommitMetadata metadata, HoodieData<WriteStatus> writeStatuses) {
        this.context.setJobStatus(this.getClass().getSimpleName(), "Committing to metadata table: " + this.config.getTableName());
        Option<HoodieTableMetadataWriter> metadataWriterOpt = table.getMetadataWriter(instantTime);
        if (metadataWriterOpt.isPresent()) {
            try (HoodieTableMetadataWriter metadataWriter = (HoodieTableMetadataWriter)metadataWriterOpt.get();){
                metadataWriter.update(metadata, writeStatuses, instantTime);
            }
            catch (Exception e) {
                if (e instanceof HoodieException) {
                    throw (HoodieException)((Object)e);
                }
                throw new HoodieException("Failed to update metadata", (Throwable)e);
            }
        }
    }

    public abstract I filterExists(I var1);

    public void bootstrap(Option<Map<String, String>> extraMetadata) {
        if (this.config.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl()) {
            throw new HoodieException("Cannot bootstrap the table in multi-writer mode");
        }
        HoodieTable table = this.initTable(WriteOperationType.UPSERT, (Option<String>)Option.ofNullable((Object)"00000000000001"));
        this.tableServiceClient.rollbackFailedBootstrap();
        table.bootstrap(this.context, extraMetadata);
    }

    public abstract O upsert(I var1, String var2);

    public abstract O upsertPreppedRecords(I var1, String var2);

    public abstract O insert(I var1, String var2);

    public abstract O insertPreppedRecords(I var1, String var2);

    public abstract O bulkInsert(I var1, String var2);

    public abstract O bulkInsert(I var1, String var2, Option<BulkInsertPartitioner> var3);

    public abstract O bulkInsertPreppedRecords(I var1, String var2, Option<BulkInsertPartitioner> var3);

    public abstract O delete(K var1, String var2);

    public abstract O deletePrepped(I var1, String var2);

    public void preWrite(String instantTime, WriteOperationType writeOperationType, HoodieTableMetaClient metaClient) {
        this.setOperationType(writeOperationType);
        this.lastCompletedTxnAndMetadata = this.txnManager.isLockRequired() ? TransactionUtils.getLastCompletedTxnInstantAndMetadata(metaClient) : Option.empty();
        this.pendingInflightAndRequestedInstants = TransactionUtils.getInflightAndRequestedInstants(metaClient);
        this.pendingInflightAndRequestedInstants.remove(instantTime);
        this.tableServiceClient.setPendingInflightAndRequestedInstants(this.pendingInflightAndRequestedInstants);
        this.tableServiceClient.startAsyncCleanerService(this);
        this.tableServiceClient.startAsyncArchiveService(this);
    }

    public O postWrite(HoodieWriteMetadata<O> result, String instantTime, HoodieTable hoodieTable) {
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics(this.getOperationType().name(), ((Duration)result.getIndexUpdateDuration().get()).toMillis());
        }
        if (result.isCommitted()) {
            if (result.getFinalizeDuration().isPresent()) {
                this.metrics.updateFinalizeWriteMetrics(((Duration)result.getFinalizeDuration().get()).toMillis(), ((List)result.getWriteStats().get()).size());
            }
            this.postCommit(hoodieTable, (HoodieCommitMetadata)result.getCommitMetadata().get(), instantTime, (Option<Map<String, String>>)Option.empty());
            this.mayBeCleanAndArchive(hoodieTable);
            this.emitCommitMetrics(instantTime, (HoodieCommitMetadata)result.getCommitMetadata().get(), hoodieTable.getMetaClient().getCommitActionType());
        }
        return result.getWriteStatuses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postCommit(HoodieTable table, HoodieCommitMetadata metadata, String instantTime, Option<Map<String, String>> extraMetadata) {
        try {
            this.context.setJobStatus(this.getClass().getSimpleName(), "Cleaning up marker directories for commit " + instantTime + " in table " + this.config.getTableName());
            WriteMarkersFactory.get(this.config.getMarkersType(), table, instantTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        }
        finally {
            this.heartbeatClient.stop(instantTime);
        }
    }

    protected void mayBeCleanAndArchive(HoodieTable table) {
        this.autoCleanOnCommit();
        this.autoArchiveOnCommit(this.createTable(this.config, this.hadoopConf));
    }

    protected void runTableServicesInline(HoodieTable table, HoodieCommitMetadata metadata, Option<Map<String, String>> extraMetadata) {
        this.tableServiceClient.runTableServicesInline(table, metadata, extraMetadata);
    }

    protected void autoCleanOnCommit() {
        if (!this.config.isAutoClean()) {
            return;
        }
        if (this.config.isAsyncClean()) {
            LOG.info("Async cleaner has been spawned. Waiting for it to finish");
            this.tableServiceClient.asyncClean();
            LOG.info("Async cleaner has finished");
        } else {
            LOG.info("Start to clean synchronously.");
            this.clean();
        }
    }

    protected void autoArchiveOnCommit(HoodieTable table) {
        if (!this.config.isAutoArchive()) {
            return;
        }
        if (this.config.isAsyncArchive()) {
            LOG.info("Async archiver has been spawned. Waiting for it to finish");
            this.tableServiceClient.asyncArchive();
            LOG.info("Async archiver has finished");
        } else {
            LOG.info("Start to archive synchronously.");
            this.archive(table);
        }
    }

    public void runAnyPendingCompactions() {
        this.tableServiceClient.runAnyPendingCompactions(this.createTable(this.config, this.hadoopConf));
    }

    public void runAnyPendingLogCompactions() {
        this.tableServiceClient.runAnyPendingLogCompactions(this.createTable(this.config, this.hadoopConf));
    }

    public void savepoint(String user, String comment) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        if (table.getCompletedCommitsTimeline().empty()) {
            throw new HoodieSavepointException("Could not savepoint. Commit timeline is empty");
        }
        String latestCommit = ((HoodieInstant)table.getCompletedCommitsTimeline().lastInstant().get()).getTimestamp();
        LOG.info("Savepointing latest commit " + latestCommit);
        this.savepoint(latestCommit, user, comment);
    }

    public void savepoint(String instantTime, String user, String comment) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        table.savepoint(this.context, instantTime, user, comment);
    }

    public void deleteSavepoint() {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        HoodieTimeline savePointTimeline = table.getActiveTimeline().getSavePointTimeline();
        if (savePointTimeline.empty()) {
            throw new HoodieSavepointException("Could not delete savepoint. Savepoint timeline is empty");
        }
        String savepointTime = ((HoodieInstant)savePointTimeline.lastInstant().get()).getTimestamp();
        LOG.info("Deleting latest savepoint time " + savepointTime);
        this.deleteSavepoint(savepointTime);
    }

    public void deleteSavepoint(String savepointTime) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        SavepointHelpers.deleteSavepoint(table, savepointTime);
    }

    public void restoreToSavepoint() {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        HoodieTimeline savePointTimeline = table.getActiveTimeline().getSavePointTimeline();
        if (savePointTimeline.empty()) {
            throw new HoodieSavepointException("Could not restore to savepoint. Savepoint timeline is empty");
        }
        String savepointTime = ((HoodieInstant)savePointTimeline.lastInstant().get()).getTimestamp();
        LOG.info("Restoring to latest savepoint time " + savepointTime);
        this.restoreToSavepoint(savepointTime);
    }

    public void restoreToSavepoint(String savepointTime) {
        boolean initializeMetadataTableIfNecessary = this.config.isMetadataTableEnabled();
        if (initializeMetadataTableIfNecessary) {
            try {
                HoodieTableMetaClient mdtMetaClient = HoodieTableMetaClient.builder().setConf(this.hadoopConf).setBasePath(HoodieTableMetadata.getMetadataTableBasePath((String)this.config.getBasePath())).build();
                Option oldestMdtCompaction = mdtMetaClient.getCommitTimeline().filterCompletedInstants().firstInstant();
                boolean deleteMDT = false;
                if (oldestMdtCompaction.isPresent() && HoodieTimeline.LESSER_THAN_OR_EQUALS.test(savepointTime, ((HoodieInstant)oldestMdtCompaction.get()).getTimestamp())) {
                    LOG.warn(String.format("Deleting MDT during restore to %s as the savepoint is older than oldest compaction %s on MDT", savepointTime, ((HoodieInstant)oldestMdtCompaction.get()).getTimestamp()));
                    deleteMDT = true;
                }
                if (!deleteMDT) {
                    HoodieInstant syncedInstant = new HoodieInstant(false, "deltacommit", savepointTime);
                    if (mdtMetaClient.getCommitsTimeline().isBeforeTimelineStarts(syncedInstant.getTimestamp())) {
                        LOG.warn(String.format("Deleting MDT during restore to %s as the savepoint is older than the MDT timeline %s", savepointTime, ((HoodieInstant)mdtMetaClient.getCommitsTimeline().firstInstant().get()).getTimestamp()));
                        deleteMDT = true;
                    }
                }
                if (deleteMDT) {
                    HoodieTableMetadataUtil.deleteMetadataTable((String)this.config.getBasePath(), (HoodieEngineContext)this.context);
                    initializeMetadataTableIfNecessary = false;
                }
            }
            catch (Exception mdtMetaClient) {
                // empty catch block
            }
        }
        HoodieTable table = this.initTable(WriteOperationType.UNKNOWN, (Option<String>)Option.empty(), initializeMetadataTableIfNecessary);
        SavepointHelpers.validateSavepointPresence(table, savepointTime);
        ValidationUtils.checkArgument((!this.config.shouldArchiveBeyondSavepoint() ? 1 : 0) != 0, (String)("Restore is not supported when " + HoodieArchivalConfig.ARCHIVE_BEYOND_SAVEPOINT.key() + " is enabled"));
        this.restoreToInstant(savepointTime, initializeMetadataTableIfNecessary);
        SavepointHelpers.validateSavepointRestore(table, savepointTime);
    }

    @Deprecated
    public boolean rollback(String commitInstantTime) throws HoodieRollbackException {
        HoodieTable table = this.initTable(WriteOperationType.UNKNOWN, (Option<String>)Option.empty());
        Option<HoodiePendingRollbackInfo> pendingRollbackInfo = this.tableServiceClient.getPendingRollbackInfo(table.getMetaClient(), commitInstantTime);
        return this.tableServiceClient.rollback(commitInstantTime, pendingRollbackInfo, false);
    }

    @Deprecated
    public boolean rollback(String commitInstantTime, String rollbackInstantTimestamp) throws HoodieRollbackException {
        HoodieTable table = this.initTable(WriteOperationType.UNKNOWN, (Option<String>)Option.empty());
        Option<HoodiePendingRollbackInfo> pendingRollbackInfo = this.tableServiceClient.getPendingRollbackInfo(table.getMetaClient(), commitInstantTime);
        return this.tableServiceClient.rollback(commitInstantTime, pendingRollbackInfo, rollbackInstantTimestamp, false);
    }

    public HoodieRestoreMetadata restoreToInstant(String savepointToRestoreTimestamp, boolean initialMetadataTableIfNecessary) throws HoodieRestoreException {
        LOG.info("Begin restore to instant " + savepointToRestoreTimestamp);
        Timer.Context timerContext = this.metrics.getRollbackCtx();
        try {
            HoodieTable table = this.initTable(WriteOperationType.UNKNOWN, (Option<String>)Option.empty(), initialMetadataTableIfNecessary);
            Pair<String, Option<HoodieRestorePlan>> timestampAndRestorePlan = this.scheduleAndGetRestorePlan(savepointToRestoreTimestamp, table);
            String restoreInstantTimestamp = (String)timestampAndRestorePlan.getLeft();
            Option restorePlanOption = (Option)timestampAndRestorePlan.getRight();
            if (restorePlanOption.isPresent()) {
                HoodieRestoreMetadata restoreMetadata = table.restore(this.context, restoreInstantTimestamp, savepointToRestoreTimestamp);
                if (timerContext != null) {
                    long durationInMs = this.metrics.getDurationInMs(timerContext.stop());
                    long totalFilesDeleted = restoreMetadata.getHoodieRestoreMetadata().values().stream().flatMap(Collection::stream).mapToLong(HoodieRollbackMetadata::getTotalFilesDeleted).sum();
                    this.metrics.updateRollbackMetrics(durationInMs, totalFilesDeleted);
                }
                return restoreMetadata;
            }
            throw new HoodieRestoreException("Failed to restore " + this.config.getBasePath() + " to commit " + savepointToRestoreTimestamp);
        }
        catch (Exception e) {
            throw new HoodieRestoreException("Failed to restore to " + savepointToRestoreTimestamp, e);
        }
    }

    private Pair<String, Option<HoodieRestorePlan>> scheduleAndGetRestorePlan(String savepointToRestoreTimestamp, HoodieTable<T, I, K, O> table) throws IOException {
        Option failedRestore = table.getRestoreTimeline().filterInflightsAndRequested().lastInstant();
        if (failedRestore.isPresent() && savepointToRestoreTimestamp.equals(RestoreUtils.getSavepointToRestoreTimestamp(table, (HoodieInstant)failedRestore.get()))) {
            return Pair.of((Object)((HoodieInstant)failedRestore.get()).getTimestamp(), (Object)Option.of((Object)RestoreUtils.getRestorePlan(table.getMetaClient(), (HoodieInstant)failedRestore.get())));
        }
        String restoreInstantTimestamp = HoodieActiveTimeline.createNewInstantTime();
        return Pair.of((Object)restoreInstantTimestamp, table.scheduleRestore(this.context, restoreInstantTimestamp, savepointToRestoreTimestamp));
    }

    public HoodieCleanMetadata clean(String cleanInstantTime) throws HoodieIOException {
        return this.clean(cleanInstantTime, true, false);
    }

    @Deprecated
    public HoodieCleanMetadata clean(String cleanInstantTime, boolean skipLocking) throws HoodieIOException {
        return this.clean(cleanInstantTime, true, false);
    }

    public HoodieCleanMetadata clean(String cleanInstantTime, boolean scheduleInline, boolean skipLocking) throws HoodieIOException {
        return this.tableServiceClient.clean(cleanInstantTime, scheduleInline);
    }

    public HoodieCleanMetadata clean() {
        return this.clean(HoodieActiveTimeline.createNewInstantTime());
    }

    @Deprecated
    public HoodieCleanMetadata clean(boolean skipLocking) {
        return this.clean(HoodieActiveTimeline.createNewInstantTime());
    }

    protected void archive(HoodieTable table) {
        this.tableServiceClient.archive(table);
    }

    public void archive() {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        this.archive(table);
    }

    public String startCommit() {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        return this.startCommit(metaClient.getCommitActionType(), metaClient);
    }

    public String startCommit(String actionType, HoodieTableMetaClient metaClient) {
        CleanerUtils.rollbackFailedWrites((HoodieFailedWritesCleaningPolicy)this.config.getFailedWritesCleanPolicy(), (String)"commit", (Functions.Function0 & Serializable)() -> this.tableServiceClient.rollbackFailedWrites());
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        this.startCommit(instantTime, actionType, metaClient);
        return instantTime;
    }

    public void startCommitWithTime(String instantTime) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        this.startCommitWithTime(instantTime, metaClient.getCommitActionType(), metaClient);
    }

    public void startCommitWithTime(String instantTime, String actionType) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        this.startCommitWithTime(instantTime, actionType, metaClient);
    }

    private void startCommitWithTime(String instantTime, String actionType, HoodieTableMetaClient metaClient) {
        CleanerUtils.rollbackFailedWrites((HoodieFailedWritesCleaningPolicy)this.config.getFailedWritesCleanPolicy(), (String)"commit", (Functions.Function0 & Serializable)() -> this.tableServiceClient.rollbackFailedWrites());
        this.startCommit(instantTime, actionType, metaClient);
    }

    private void startCommit(String instantTime, String actionType, HoodieTableMetaClient metaClient) {
        LOG.info("Generate a new instant time: " + instantTime + " action: " + actionType);
        HoodieTimeline inflightRestoreTimeline = metaClient.getActiveTimeline().getRestoreTimeline().filterInflightsAndRequested();
        ValidationUtils.checkArgument((inflightRestoreTimeline.countInstants() == 0 ? 1 : 0) != 0, (String)("Found pending restore in active timeline. Please complete the restore fully before proceeding. As of now, table could be in an inconsistent state. Pending restores: " + Arrays.toString(inflightRestoreTimeline.getInstantsAsStream().map(instant -> instant.getTimestamp()).collect(Collectors.toList()).toArray())));
        metaClient.getActiveTimeline().filterPendingCompactionTimeline().lastInstant().ifPresent(latestPending -> ValidationUtils.checkArgument((boolean)HoodieTimeline.compareTimestamps((String)latestPending.getTimestamp(), (BiPredicate)HoodieTimeline.LESSER_THAN, (String)instantTime), (String)("Latest pending compaction instant time must be earlier than this instant time. Latest Compaction :" + latestPending + ",  Ingesting at " + instantTime)));
        if (this.config.getFailedWritesCleanPolicy().isLazy()) {
            this.heartbeatClient.start(instantTime);
        }
        if (actionType.equals("replacecommit")) {
            metaClient.getActiveTimeline().createRequestedReplaceCommit(instantTime, actionType);
        } else {
            metaClient.getActiveTimeline().createNewInstant(new HoodieInstant(HoodieInstant.State.REQUESTED, actionType, instantTime));
        }
    }

    public Option<String> scheduleCompaction(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleCompactionAtInstant(instantTime, extraMetadata) ? Option.of((Object)instantTime) : Option.empty();
    }

    public boolean scheduleCompactionAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.COMPACT).isPresent();
    }

    public Option<String> scheduleIndexing(List<MetadataPartitionType> partitionTypes) {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        Option<HoodieIndexPlan> indexPlan = this.createTable(this.config, this.hadoopConf).scheduleIndexing(this.context, instantTime, partitionTypes);
        return indexPlan.isPresent() ? Option.of((Object)instantTime) : Option.empty();
    }

    public Option<HoodieIndexCommitMetadata> index(String indexInstantTime) {
        return this.createTable(this.config, this.hadoopConf).index(this.context, indexInstantTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(List<MetadataPartitionType> partitionTypes) {
        block18: {
            HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
            String dropInstant = HoodieActiveTimeline.createNewInstantTime();
            HoodieInstant ownerInstant = new HoodieInstant(true, "indexing", dropInstant);
            this.txnManager.beginTransaction((Option<HoodieInstant>)Option.of((Object)ownerInstant), (Option<HoodieInstant>)Option.empty());
            try {
                this.context.setJobStatus(this.getClass().getSimpleName(), "Dropping partitions from metadata table: " + this.config.getTableName());
                Option<HoodieTableMetadataWriter> metadataWriterOpt = table.getMetadataWriter(dropInstant);
                if (!metadataWriterOpt.isPresent()) break block18;
                try (HoodieTableMetadataWriter metadataWriter = (HoodieTableMetadataWriter)metadataWriterOpt.get();){
                    metadataWriter.dropMetadataPartitions(partitionTypes);
                }
                catch (Exception e) {
                    if (e instanceof HoodieException) {
                        throw (HoodieException)((Object)e);
                    }
                    throw new HoodieException("Failed to drop partitions from metadata", (Throwable)e);
                }
            }
            finally {
                this.txnManager.endTransaction((Option<HoodieInstant>)Option.of((Object)ownerInstant));
            }
        }
    }

    public HoodieWriteMetadata<O> cluster(String clusteringInstantTime) {
        if (this.shouldDelegateToTableServiceManager(this.config, ActionType.replacecommit)) {
            throw new UnsupportedOperationException("Clustering should be delegated to table service manager instead of direct run.");
        }
        return this.cluster(clusteringInstantTime, true);
    }

    public HoodieWriteMetadata<O> compact(String compactionInstantTime) {
        if (this.shouldDelegateToTableServiceManager(this.config, ActionType.compaction)) {
            throw new UnsupportedOperationException("Compaction should be delegated to table service manager instead of direct run.");
        }
        return this.compact(compactionInstantTime, this.config.shouldAutoCommit());
    }

    public void commitCompaction(String compactionInstantTime, HoodieCommitMetadata metadata, Option<Map<String, String>> extraMetadata) {
        this.tableServiceClient.commitCompaction(compactionInstantTime, metadata, extraMetadata);
    }

    protected void completeCompaction(HoodieCommitMetadata metadata, HoodieTable table, String compactionCommitTime) {
        this.tableServiceClient.completeCompaction(metadata, table, compactionCommitTime);
    }

    public Option<String> scheduleLogCompaction(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleLogCompactionAtInstant(instantTime, extraMetadata) ? Option.of((Object)instantTime) : Option.empty();
    }

    public boolean scheduleLogCompactionAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.LOG_COMPACT).isPresent();
    }

    public HoodieWriteMetadata<O> logCompact(String logCompactionInstantTime) {
        return this.logCompact(logCompactionInstantTime, this.config.shouldAutoCommit());
    }

    public void commitLogCompaction(String logCompactionInstantTime, HoodieCommitMetadata metadata, Option<Map<String, String>> extraMetadata) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.context.getHadoopConf().get());
        extraMetadata.ifPresent(m -> m.forEach((arg_0, arg_1) -> ((HoodieCommitMetadata)metadata).addMetadata(arg_0, arg_1)));
        this.completeLogCompaction(metadata, table, logCompactionInstantTime);
    }

    protected void completeLogCompaction(HoodieCommitMetadata metadata, HoodieTable table, String logCompactionCommitTime) {
        this.tableServiceClient.completeLogCompaction(metadata, table, logCompactionCommitTime);
    }

    protected HoodieWriteMetadata<O> compact(String compactionInstantTime, boolean shouldComplete) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.context.getHadoopConf().get());
        this.preWrite(compactionInstantTime, WriteOperationType.COMPACT, table.getMetaClient());
        return this.tableServiceClient.compact(compactionInstantTime, shouldComplete);
    }

    protected Option<String> inlineScheduleCompaction(Option<Map<String, String>> extraMetadata) {
        return this.scheduleCompaction(extraMetadata);
    }

    protected HoodieWriteMetadata<O> logCompact(String logCompactionInstantTime, boolean shouldComplete) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.context.getHadoopConf().get());
        this.preWrite(logCompactionInstantTime, WriteOperationType.LOG_COMPACT, table.getMetaClient());
        return this.tableServiceClient.logCompact(logCompactionInstantTime, shouldComplete);
    }

    public Option<String> scheduleClustering(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleClusteringAtInstant(instantTime, extraMetadata) ? Option.of((Object)instantTime) : Option.empty();
    }

    public boolean scheduleClusteringAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.CLUSTER).isPresent();
    }

    protected boolean scheduleCleaningAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.CLEAN).isPresent();
    }

    public HoodieWriteMetadata<O> cluster(String clusteringInstant, boolean shouldComplete) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.context.getHadoopConf().get());
        this.preWrite(clusteringInstant, WriteOperationType.CLUSTER, table.getMetaClient());
        return this.tableServiceClient.cluster(clusteringInstant, shouldComplete);
    }

    public Option<String> scheduleTableService(Option<Map<String, String>> extraMetadata, TableServiceType tableServiceType) {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleTableService(instantTime, extraMetadata, tableServiceType);
    }

    public Option<String> scheduleTableService(String instantTime, Option<Map<String, String>> extraMetadata, TableServiceType tableServiceType) {
        return this.tableServiceClient.scheduleTableService(instantTime, extraMetadata, tableServiceType);
    }

    public HoodieMetrics getMetrics() {
        return this.metrics;
    }

    public HoodieIndex<?, ?> getIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitTable(WriteOperationType operationType, HoodieTableMetaClient metaClient, Option<String> instantTime) {
        Option ownerInstant = Option.empty();
        if (instantTime.isPresent()) {
            ownerInstant = Option.of((Object)new HoodieInstant(true, CommitUtils.getCommitActionType((WriteOperationType)operationType, (HoodieTableType)metaClient.getTableType()), (String)instantTime.get()));
        }
        this.txnManager.beginTransaction((Option<HoodieInstant>)ownerInstant, (Option<HoodieInstant>)Option.empty());
        try {
            this.tryUpgrade(metaClient, instantTime);
            this.initMetadataTable(instantTime);
        }
        finally {
            this.txnManager.endTransaction((Option<HoodieInstant>)ownerInstant);
        }
    }

    protected void initMetadataTable(Option<String> instantTime) {
    }

    protected final HoodieTable initTable(WriteOperationType operationType, Option<String> instantTime, boolean initMetadataTable) {
        return this.initTable(operationType, instantTime);
    }

    public final HoodieTable initTable(WriteOperationType operationType, Option<String> instantTime) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        if (WriteOperationType.isDelete((WriteOperationType)operationType)) {
            this.setWriteSchemaForDeletes(metaClient);
        }
        this.doInitTable(operationType, metaClient, instantTime);
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf, metaClient);
        metaClient.validateTableProperties((Properties)this.config.getProps());
        switch (operationType) {
            case INSERT: 
            case INSERT_PREPPED: 
            case UPSERT: 
            case UPSERT_PREPPED: 
            case BULK_INSERT: 
            case BULK_INSERT_PREPPED: 
            case INSERT_OVERWRITE: 
            case INSERT_OVERWRITE_TABLE: {
                this.setWriteTimer(table);
                break;
            }
            case CLUSTER: 
            case COMPACT: 
            case LOG_COMPACT: {
                this.tableServiceClient.setTableServiceTimer(operationType);
                break;
            }
        }
        return table;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setWriteSchemaForDeletes(HoodieTableMetaClient metaClient) {
        try {
            HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
            Option lastInstant = activeTimeline.filterCompletedInstants().filter(s -> s.getAction().equals(metaClient.getCommitActionType()) || s.getAction().equals("replacecommit")).lastInstant();
            if (lastInstant.isPresent()) {
                HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])activeTimeline.getInstantDetails((HoodieInstant)lastInstant.get()).get()), HoodieCommitMetadata.class);
                String extraSchema = (String)commitMetadata.getExtraMetadata().get("schema");
                if (StringUtils.isNullOrEmpty((String)extraSchema)) throw new HoodieIOException("Latest commit does not have any schema in commit metadata");
                this.config.setSchema((String)commitMetadata.getExtraMetadata().get("schema"));
                return;
            } else {
                LOG.warn("None rows are deleted because the table is empty");
            }
            return;
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException thrown while reading last commit metadata", e);
        }
    }

    protected void releaseResources(String instantTime) {
    }

    @Override
    public void close() {
        super.close();
        this.index.close();
        this.tableServiceClient.close();
    }

    private void setWriteTimer(HoodieTable table) {
        String commitType = table.getMetaClient().getCommitActionType();
        if (commitType.equals("commit")) {
            this.writeTimer = this.metrics.getCommitCtx();
        } else if (commitType.equals("deltacommit")) {
            this.writeTimer = this.metrics.getDeltaCommitCtx();
        }
    }

    protected void tryUpgrade(HoodieTableMetaClient metaClient, Option<String> instantTime) {
        UpgradeDowngrade upgradeDowngrade = new UpgradeDowngrade(metaClient, this.config, this.context, this.upgradeDowngradeHelper);
        if (upgradeDowngrade.needsUpgradeOrDowngrade(HoodieTableVersion.current())) {
            List<String> instantsToRollback = this.tableServiceClient.getInstantsToRollback(metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient), HoodieFailedWritesCleaningPolicy.EAGER, instantTime);
            if (!instantsToRollback.isEmpty()) {
                Map<String, Option<HoodiePendingRollbackInfo>> pendingRollbacks = this.tableServiceClient.getPendingRollbackInfos(metaClient);
                instantsToRollback.forEach(entry -> pendingRollbacks.putIfAbsent((String)entry, (Option<HoodiePendingRollbackInfo>)Option.empty()));
                this.tableServiceClient.rollbackFailedWrites(pendingRollbacks, true);
            }
            new UpgradeDowngrade(metaClient, this.config, this.context, this.upgradeDowngradeHelper).run(HoodieTableVersion.current(), (String)instantTime.orElse(null));
            metaClient.reloadActiveTimeline();
        }
    }

    public boolean lazyRollbackFailedIndexing() {
        return this.tableServiceClient.rollbackFailedIndexingCommits();
    }

    public boolean rollbackFailedWrites() {
        return this.tableServiceClient.rollbackFailedWrites();
    }

    public void addColumn(String colName, Schema schema, String doc, String position, TableChange.ColumnPositionChange.ColumnPositionType positionType) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier((InternalSchema)pair.getLeft()).applyAddChange(colName, AvroInternalSchemaConverter.convertToField((Schema)schema), doc, position, positionType);
        this.commitTableChange(newSchema, (HoodieTableMetaClient)pair.getRight());
    }

    public void addColumn(String colName, Schema schema) {
        this.addColumn(colName, schema, null, "", TableChange.ColumnPositionChange.ColumnPositionType.NO_OPERATION);
    }

    public void deleteColumns(String ... colNames) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier((InternalSchema)pair.getLeft()).applyDeleteChange(colNames);
        this.commitTableChange(newSchema, (HoodieTableMetaClient)pair.getRight());
    }

    public void renameColumn(String colName, String newName) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier((InternalSchema)pair.getLeft()).applyRenameChange(colName, newName);
        this.commitTableChange(newSchema, (HoodieTableMetaClient)pair.getRight());
    }

    public void updateColumnNullability(String colName, boolean nullable) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier((InternalSchema)pair.getLeft()).applyColumnNullabilityChange(colName, nullable);
        this.commitTableChange(newSchema, (HoodieTableMetaClient)pair.getRight());
    }

    public void updateColumnType(String colName, Type newType) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier((InternalSchema)pair.getLeft()).applyColumnTypeChange(colName, newType);
        this.commitTableChange(newSchema, (HoodieTableMetaClient)pair.getRight());
    }

    public void updateColumnComment(String colName, String doc) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier((InternalSchema)pair.getLeft()).applyColumnCommentChange(colName, doc);
        this.commitTableChange(newSchema, (HoodieTableMetaClient)pair.getRight());
    }

    public void reOrderColPosition(String colName, String referColName, TableChange.ColumnPositionChange.ColumnPositionType orderType) {
        if (colName == null || orderType == null || referColName == null) {
            return;
        }
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier((InternalSchema)pair.getLeft()).applyReOrderColPositionChange(colName, referColName, orderType);
        this.commitTableChange(newSchema, (HoodieTableMetaClient)pair.getRight());
    }

    private Pair<InternalSchema, HoodieTableMetaClient> getInternalSchemaAndMetaClient() {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        return Pair.of((Object)this.getInternalSchema(schemaUtil), (Object)metaClient);
    }

    private void commitTableChange(InternalSchema newSchema, HoodieTableMetaClient metaClient) {
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        String historySchemaStr = (String)schemaUtil.getTableHistorySchemaStrFromCommitMetadata().orElseGet(() -> SerDeHelper.inheritSchemas((InternalSchema)this.getInternalSchema(schemaUtil), (String)""));
        Schema schema = AvroInternalSchemaConverter.convert((InternalSchema)newSchema, (String)AvroSchemaUtils.getAvroRecordQualifiedName((String)this.config.getTableName()));
        String commitActionType = CommitUtils.getCommitActionType((WriteOperationType)WriteOperationType.ALTER_SCHEMA, (HoodieTableType)metaClient.getTableType());
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        this.startCommitWithTime(instantTime, commitActionType, metaClient);
        this.config.setSchema(schema.toString());
        HoodieActiveTimeline timeLine = metaClient.getActiveTimeline();
        HoodieInstant requested = new HoodieInstant(HoodieInstant.State.REQUESTED, commitActionType, instantTime);
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        metadata.setOperationType(WriteOperationType.ALTER_SCHEMA);
        try {
            timeLine.transitionRequestedToInflight(requested, Option.of((Object)metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException io) {
            throw new HoodieCommitException("Failed to commit " + instantTime + " unable to save inflight metadata ", io);
        }
        HashMap<String, String> extraMeta = new HashMap<String, String>();
        extraMeta.put("latest_schema", SerDeHelper.toJson((InternalSchema)newSchema.setSchemaId(Long.parseLong(instantTime))));
        FileBasedInternalSchemaStorageManager schemasManager = new FileBasedInternalSchemaStorageManager(metaClient);
        schemasManager.persistHistorySchemaStr(instantTime, SerDeHelper.inheritSchemas((InternalSchema)newSchema, (String)historySchemaStr));
        this.commitStats(instantTime, (HoodieData<WriteStatus>)this.context.emptyHoodieData(), Collections.emptyList(), (Option<Map<String, String>>)Option.of(extraMeta), commitActionType);
    }

    private InternalSchema getInternalSchema(TableSchemaResolver schemaUtil) {
        return (InternalSchema)schemaUtil.getTableInternalSchemaFromCommitMetadata().orElseGet(() -> {
            try {
                return AvroInternalSchemaConverter.convert((Schema)schemaUtil.getTableAvroSchema());
            }
            catch (Exception e) {
                throw new HoodieException(String.format("cannot find schema for current table: %s", this.config.getBasePath()));
            }
        });
    }
}

