/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.plan.generators;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieCompactionStrategy;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieUnMergedLogRecordScanner;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.compact.LogCompactionExecutionHelper;
import org.apache.hudi.table.action.compact.plan.generators.BaseHoodieCompactionPlanGenerator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieLogCompactionPlanGenerator<T extends HoodieRecordPayload, I, K, O>
extends BaseHoodieCompactionPlanGenerator<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(HoodieLogCompactionPlanGenerator.class);

    public HoodieLogCompactionPlanGenerator(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    @Override
    protected HoodieCompactionPlan getCompactionPlan(HoodieTableMetaClient metaClient, List<HoodieCompactionOperation> operations) {
        HoodieCompactionStrategy compactionStrategy = HoodieCompactionStrategy.newBuilder().setStrategyParams(this.getStrategyParams()).setCompactorClassName(LogCompactionExecutionHelper.class.getName()).build();
        return HoodieCompactionPlan.newBuilder().setOperations(operations).setVersion(CompactionUtils.LATEST_COMPACTION_METADATA_VERSION).setStrategy(compactionStrategy).setPreserveHoodieMetadata(Boolean.valueOf(true)).build();
    }

    @Override
    protected boolean filterFileSlice(FileSlice fileSlice, String lastCompletedInstantTime, Set<HoodieFileGroupId> pendingFileGroupIds) {
        return this.isFileSliceEligibleForLogCompaction(fileSlice, lastCompletedInstantTime) && super.filterFileSlice(fileSlice, lastCompletedInstantTime, pendingFileGroupIds);
    }

    @Override
    protected boolean filterLogCompactionOperations() {
        return true;
    }

    private boolean isFileSliceEligibleForLogCompaction(FileSlice fileSlice, String maxInstantTime) {
        LOG.info((Object)("Checking if fileId " + fileSlice.getFileId() + " and partition " + fileSlice.getPartitionPath() + " eligible for log compaction."));
        HoodieTableMetaClient metaClient = this.hoodieTable.getMetaClient();
        HoodieUnMergedLogRecordScanner scanner = HoodieUnMergedLogRecordScanner.newBuilder().withFileSystem((FileSystem)metaClient.getFs()).withBasePath(this.hoodieTable.getMetaClient().getBasePath()).withLogFilePaths(fileSlice.getLogFiles().sorted(HoodieLogFile.getLogFileComparator()).map(file -> file.getPath().toString()).collect(Collectors.toList())).withLatestInstantTime(maxInstantTime).withBufferSize(this.writeConfig.getMaxDFSStreamBufferSize()).withOptimizedLogBlocksScan(true).withRecordMerger(this.writeConfig.getRecordMerger()).build();
        scanner.scan(true);
        int totalBlocks = scanner.getCurrentInstantLogBlocks().size();
        LOG.info((Object)("Total blocks seen are " + totalBlocks));
        return totalBlocks >= this.writeConfig.getLogCompactionBlocksThreshold();
    }
}

