/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster.strategy;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieSliceInfo;
import org.apache.hudi.client.utils.FileSliceMetricUtils;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilterMode;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class ClusteringPlanStrategy<T, I, K, O>
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(ClusteringPlanStrategy.class);
    public static final int CLUSTERING_PLAN_VERSION_1 = 1;
    private final HoodieTable<T, I, K, O> hoodieTable;
    private final transient HoodieEngineContext engineContext;
    private final HoodieWriteConfig writeConfig;

    public static String checkAndGetClusteringPlanStrategy(HoodieWriteConfig config) {
        String className = config.getClusteringPlanStrategyClass();
        String sparkSizeBasedClassName = "org.apache.hudi.client.clustering.plan.strategy.SparkSizeBasedClusteringPlanStrategy";
        String sparkSelectedPartitionsClassName = "org.apache.hudi.client.clustering.plan.strategy.SparkSelectedPartitionsClusteringPlanStrategy";
        String sparkRecentDaysClassName = "org.apache.hudi.client.clustering.plan.strategy.SparkRecentDaysClusteringPlanStrategy";
        String javaSelectedPartitionClassName = "org.apache.hudi.client.clustering.plan.strategy.JavaRecentDaysClusteringPlanStrategy";
        String javaSizeBasedClassName = "org.apache.hudi.client.clustering.plan.strategy.JavaSizeBasedClusteringPlanStrategy";
        String logStr = "The clustering plan '%s' is deprecated. Please set the plan as '%s' and set '%s' as '%s' to achieve the same behaviour";
        if (sparkRecentDaysClassName.equals(className)) {
            config.setValue(HoodieClusteringConfig.PLAN_PARTITION_FILTER_MODE_NAME, ClusteringPlanPartitionFilterMode.RECENT_DAYS.name());
            LOG.warn((Object)String.format(logStr, className, sparkSizeBasedClassName, HoodieClusteringConfig.PLAN_PARTITION_FILTER_MODE_NAME.key(), ClusteringPlanPartitionFilterMode.RECENT_DAYS.name()));
            return sparkSizeBasedClassName;
        }
        if (sparkSelectedPartitionsClassName.equals(className)) {
            config.setValue(HoodieClusteringConfig.PLAN_PARTITION_FILTER_MODE_NAME, ClusteringPlanPartitionFilterMode.SELECTED_PARTITIONS.name());
            LOG.warn((Object)String.format(logStr, className, sparkSizeBasedClassName, HoodieClusteringConfig.PLAN_PARTITION_FILTER_MODE_NAME.key(), ClusteringPlanPartitionFilterMode.SELECTED_PARTITIONS.name()));
            return sparkSizeBasedClassName;
        }
        if (javaSelectedPartitionClassName.equals(className)) {
            config.setValue(HoodieClusteringConfig.PLAN_PARTITION_FILTER_MODE_NAME, ClusteringPlanPartitionFilterMode.RECENT_DAYS.name());
            LOG.warn((Object)String.format(logStr, className, javaSizeBasedClassName, HoodieClusteringConfig.PLAN_PARTITION_FILTER_MODE_NAME.key(), ClusteringPlanPartitionFilterMode.SELECTED_PARTITIONS.name()));
            return javaSizeBasedClassName;
        }
        return className;
    }

    public ClusteringPlanStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        this.writeConfig = writeConfig;
        this.hoodieTable = table;
        this.engineContext = engineContext;
    }

    public abstract Option<HoodieClusteringPlan> generateClusteringPlan();

    public boolean checkPrecondition() {
        return true;
    }

    protected Stream<FileSlice> getFileSlicesEligibleForClustering(String partition) {
        SyncableFileSystemView fileSystemView = (SyncableFileSystemView)this.getHoodieTable().getSliceView();
        Set fgIdsInPendingCompactionLogCompactionAndClustering = Stream.concat(fileSystemView.getPendingCompactionOperations(), fileSystemView.getPendingLogCompactionOperations()).map(instantTimeOpPair -> ((CompactionOperation)instantTimeOpPair.getValue()).getFileGroupId()).collect(Collectors.toSet());
        fgIdsInPendingCompactionLogCompactionAndClustering.addAll(fileSystemView.getFileGroupsInPendingClustering().map(Pair::getKey).collect(Collectors.toSet()));
        return this.hoodieTable.getSliceView().getLatestFileSlices(partition).filter(slice -> !fgIdsInPendingCompactionLogCompactionAndClustering.contains(slice.getFileGroupId()));
    }

    protected abstract Map<String, String> getStrategyParams();

    protected Map<String, String> getExtraMetadata() {
        return Collections.emptyMap();
    }

    protected int getPlanVersion() {
        return 1;
    }

    protected static List<HoodieSliceInfo> getFileSliceInfo(List<FileSlice> slices) {
        return slices.stream().map(slice -> {
            new HoodieSliceInfo();
            return HoodieSliceInfo.newBuilder().setPartitionPath(slice.getPartitionPath()).setFileId(slice.getFileId()).setDataFilePath((String)slice.getBaseFile().map(BaseFile::getPath).orElse((Object)"")).setDeltaFilePaths(slice.getLogFiles().map(f -> f.getPath().toString()).collect(Collectors.toList())).setBootstrapFilePath((String)slice.getBaseFile().map(bf -> (String)bf.getBootstrapBaseFile().map(bbf -> bbf.getPath()).orElse((Object)"")).orElse((Object)"")).build();
        }).collect(Collectors.toList());
    }

    protected Map<String, Double> buildMetrics(List<FileSlice> fileSlices) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        FileSliceMetricUtils.addFileSliceCommonMetrics(fileSlices, metrics, this.getWriteConfig().getParquetMaxFileSize());
        return metrics;
    }

    protected HoodieTable<T, I, K, O> getHoodieTable() {
        return this.hoodieTable;
    }

    protected HoodieEngineContext getEngineContext() {
        return this.engineContext;
    }

    protected HoodieWriteConfig getWriteConfig() {
        return this.writeConfig;
    }
}

