/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.inmemory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieTable;

public class HoodieInMemoryHashIndex
extends HoodieIndex<Object, Object> {
    private static ConcurrentMap<HoodieKey, HoodieRecordLocation> recordLocationMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HoodieInMemoryHashIndex(HoodieWriteConfig config) {
        super(config);
        Class<HoodieInMemoryHashIndex> clazz = HoodieInMemoryHashIndex.class;
        synchronized (HoodieInMemoryHashIndex.class) {
            if (recordLocationMap == null) {
                recordLocationMap = new ConcurrentHashMap<HoodieKey, HoodieRecordLocation>();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public <R> HoodieData<HoodieRecord<R>> tagLocation(HoodieData<HoodieRecord<R>> records, HoodieEngineContext context, HoodieTable hoodieTable) {
        return records.mapPartitions((SerializableFunction & Serializable)hoodieRecordIterator -> {
            ArrayList<HoodieRecord> taggedRecords = new ArrayList<HoodieRecord>();
            while (hoodieRecordIterator.hasNext()) {
                HoodieRecord record = (HoodieRecord)hoodieRecordIterator.next();
                if (recordLocationMap.containsKey(record.getKey())) {
                    record.unseal();
                    record.setCurrentLocation((HoodieRecordLocation)recordLocationMap.get(record.getKey()));
                    record.seal();
                }
                taggedRecords.add(record);
            }
            return taggedRecords.iterator();
        }, true);
    }

    @Override
    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatuses, HoodieEngineContext context, HoodieTable hoodieTable) {
        return writeStatuses.map((SerializableFunction & Serializable)writeStatus -> {
            for (HoodieRecord record : writeStatus.getWrittenRecords()) {
                if (writeStatus.isErrored(record.getKey())) continue;
                HoodieKey key = record.getKey();
                Option newLocation = record.getNewLocation();
                if (newLocation.isPresent()) {
                    recordLocationMap.put(key, (HoodieRecordLocation)newLocation.get());
                    continue;
                }
                recordLocationMap.remove(key);
            }
            return writeStatus;
        });
    }

    @Override
    public boolean rollbackCommit(String instantTime) {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean canIndexLogFiles() {
        return true;
    }

    @Override
    public boolean isImplicitWithStorage() {
        return false;
    }

    @VisibleForTesting
    public static void clear() {
        if (recordLocationMap != null) {
            recordLocationMap.clear();
        }
    }
}

