/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.queue.HoodieConsumer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.execution.HoodieLazyInsertIterable;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;

public class CopyOnWriteInsertHandler<T>
implements HoodieConsumer<HoodieLazyInsertIterable.HoodieInsertValueGenResult<HoodieRecord>, List<WriteStatus>> {
    private final HoodieWriteConfig config;
    private final String instantTime;
    private final boolean areRecordsSorted;
    private final HoodieTable hoodieTable;
    private final String idPrefix;
    private final TaskContextSupplier taskContextSupplier;
    private final WriteHandleFactory writeHandleFactory;
    private final List<WriteStatus> statuses = new ArrayList<WriteStatus>();
    private final Map<String, HoodieWriteHandle> handles = new HashMap<String, HoodieWriteHandle>();

    public CopyOnWriteInsertHandler(HoodieWriteConfig config, String instantTime, boolean areRecordsSorted, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, WriteHandleFactory writeHandleFactory) {
        this.config = config;
        this.instantTime = instantTime;
        this.areRecordsSorted = areRecordsSorted;
        this.hoodieTable = hoodieTable;
        this.idPrefix = idPrefix;
        this.taskContextSupplier = taskContextSupplier;
        this.writeHandleFactory = writeHandleFactory;
    }

    public void consume(HoodieLazyInsertIterable.HoodieInsertValueGenResult<HoodieRecord> genResult) {
        HoodieRecord record = genResult.getResult();
        String partitionPath = record.getPartitionPath();
        HoodieWriteHandle handle = this.handles.get(partitionPath);
        if (handle == null) {
            if (this.areRecordsSorted) {
                this.closeOpenHandles();
            }
            handle = this.writeHandleFactory.create(this.config, this.instantTime, this.hoodieTable, record.getPartitionPath(), this.idPrefix, this.taskContextSupplier);
            this.handles.put(partitionPath, handle);
        }
        if (!handle.canWrite(genResult.getResult())) {
            this.statuses.addAll(handle.close());
            handle = this.writeHandleFactory.create(this.config, this.instantTime, this.hoodieTable, record.getPartitionPath(), this.idPrefix, this.taskContextSupplier);
            this.handles.put(partitionPath, handle);
        }
        handle.write(record, genResult.schema, new TypedProperties(genResult.props));
    }

    public List<WriteStatus> finish() {
        this.closeOpenHandles();
        ValidationUtils.checkState((this.statuses.size() > 0 ? 1 : 0) != 0);
        return this.statuses;
    }

    private void closeOpenHandles() {
        for (HoodieWriteHandle handle : this.handles.values()) {
            this.statuses.addAll(handle.close());
        }
        this.handles.clear();
    }
}

