/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieHBaseIndexConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@ConfigClassProperty(name="Common Index Configs", groupName=ConfigGroups.Names.WRITE_CLIENT, subGroupName=ConfigGroups.SubGroupNames.INDEX, areCommonConfigs=true, description="")
@Immutable
public class HoodieIndexConfig
extends HoodieConfig {
    private static final Logger LOG = LogManager.getLogger(HoodieIndexConfig.class);
    public static final ConfigProperty<String> INDEX_TYPE = ConfigProperty.key((String)"hoodie.index.type").noDefaultValue().withValidValues(new String[]{HoodieIndex.IndexType.HBASE.name(), HoodieIndex.IndexType.INMEMORY.name(), HoodieIndex.IndexType.BLOOM.name(), HoodieIndex.IndexType.GLOBAL_BLOOM.name(), HoodieIndex.IndexType.SIMPLE.name(), HoodieIndex.IndexType.GLOBAL_SIMPLE.name(), HoodieIndex.IndexType.BUCKET.name()}).withDocumentation("Type of index to use. Default is SIMPLE on Spark engine, and INMEMORY on Flink and Java engines. Possible options are [BLOOM | GLOBAL_BLOOM |SIMPLE | GLOBAL_SIMPLE | INMEMORY | HBASE | BUCKET]. Bloom filters removes the dependency on a external system and is stored in the footer of the Parquet Data Files");
    public static final ConfigProperty<String> INDEX_CLASS_NAME = ConfigProperty.key((String)"hoodie.index.class").defaultValue((Object)"").withDocumentation("Full path of user-defined index class and must be a subclass of HoodieIndex class. It will take precedence over the hoodie.index.type configuration if specified");
    public static final ConfigProperty<String> BLOOM_FILTER_NUM_ENTRIES_VALUE = ConfigProperty.key((String)"hoodie.index.bloom.num_entries").defaultValue((Object)"60000").withDocumentation("Only applies if index type is BLOOM. This is the number of entries to be stored in the bloom filter. The rationale for the default: Assume the maxParquetFileSize is 128MB and averageRecordSize is 1kb and hence we approx a total of 130K records in a file. The default (60000) is roughly half of this approximation. Warning: Setting this very low, will generate a lot of false positives and index lookup will have to scan a lot more files than it has to and setting this to a very high number will increase the size every base file linearly (roughly 4KB for every 50000 entries). This config is also used with DYNAMIC bloom filter which determines the initial size for the bloom.");
    public static final ConfigProperty<String> BLOOM_FILTER_FPP_VALUE = ConfigProperty.key((String)"hoodie.index.bloom.fpp").defaultValue((Object)"0.000000001").withDocumentation("Only applies if index type is BLOOM. Error rate allowed given the number of entries. This is used to calculate how many bits should be assigned for the bloom filter and the number of hash functions. This is usually set very low (default: 0.000000001), we like to tradeoff disk space for lower false positives. If the number of entries added to bloom filter exceeds the configured value (hoodie.index.bloom.num_entries), then this fpp may not be honored.");
    public static final ConfigProperty<String> BLOOM_INDEX_PARALLELISM = ConfigProperty.key((String)"hoodie.bloom.index.parallelism").defaultValue((Object)"0").withDocumentation("Only applies if index type is BLOOM. This is the amount of parallelism for index lookup, which involves a shuffle. By default, this is auto computed based on input workload characteristics. If the parallelism is explicitly configured by the user, the user-configured value is used in defining the actual parallelism. If the indexing stage is slow due to the limited parallelism, you can increase this to tune the performance.");
    public static final ConfigProperty<String> BLOOM_INDEX_PRUNE_BY_RANGES = ConfigProperty.key((String)"hoodie.bloom.index.prune.by.ranges").defaultValue((Object)"true").withDocumentation("Only applies if index type is BLOOM. When true, range information from files to leveraged speed up index lookups. Particularly helpful, if the key has a monotonously increasing prefix, such as timestamp. If the record key is completely random, it is better to turn this off, since range pruning will only  add extra overhead to the index lookup.");
    public static final ConfigProperty<String> BLOOM_INDEX_USE_CACHING = ConfigProperty.key((String)"hoodie.bloom.index.use.caching").defaultValue((Object)"true").withDocumentation("Only applies if index type is BLOOM.When true, the input RDD will cached to speed up index lookup by reducing IO for computing parallelism or affected partitions");
    public static final ConfigProperty<Boolean> BLOOM_INDEX_USE_METADATA = ConfigProperty.key((String)"hoodie.bloom.index.use.metadata").defaultValue((Object)false).sinceVersion("0.11.0").withDocumentation("Only applies if index type is BLOOM.When true, the index lookup uses bloom filters and column stats from metadata table when available to speed up the process.");
    public static final ConfigProperty<String> BLOOM_INDEX_TREE_BASED_FILTER = ConfigProperty.key((String)"hoodie.bloom.index.use.treebased.filter").defaultValue((Object)"true").withDocumentation("Only applies if index type is BLOOM. When true, interval tree based file pruning optimization is enabled. This mode speeds-up file-pruning based on key ranges when compared with the brute-force mode");
    public static final ConfigProperty<String> BLOOM_INDEX_BUCKETIZED_CHECKING = ConfigProperty.key((String)"hoodie.bloom.index.bucketized.checking").defaultValue((Object)"true").withDocumentation("Only applies if index type is BLOOM. When true, bucketized bloom filtering is enabled. This reduces skew seen in sort based bloom index lookup");
    public static final ConfigProperty<String> BLOOM_FILTER_TYPE = ConfigProperty.key((String)"hoodie.bloom.index.filter.type").defaultValue((Object)BloomFilterTypeCode.DYNAMIC_V0.name()).withValidValues(new String[]{BloomFilterTypeCode.SIMPLE.name(), BloomFilterTypeCode.DYNAMIC_V0.name()}).withDocumentation("Filter type used. Default is BloomFilterTypeCode.DYNAMIC_V0. Available values are [BloomFilterTypeCode.SIMPLE , BloomFilterTypeCode.DYNAMIC_V0]. Dynamic bloom filters auto size themselves based on number of keys.");
    public static final ConfigProperty<String> BLOOM_INDEX_FILTER_DYNAMIC_MAX_ENTRIES = ConfigProperty.key((String)"hoodie.bloom.index.filter.dynamic.max.entries").defaultValue((Object)"100000").withDocumentation("The threshold for the maximum number of keys to record in a dynamic Bloom filter row. Only applies if filter type is BloomFilterTypeCode.DYNAMIC_V0.");
    public static final ConfigProperty<String> SIMPLE_INDEX_USE_CACHING = ConfigProperty.key((String)"hoodie.simple.index.use.caching").defaultValue((Object)"true").withDocumentation("Only applies if index type is SIMPLE. When true, the incoming writes will cached to speed up index lookup by reducing IO for computing parallelism or affected partitions");
    public static final ConfigProperty<String> SIMPLE_INDEX_PARALLELISM = ConfigProperty.key((String)"hoodie.simple.index.parallelism").defaultValue((Object)"100").withDocumentation("Only applies if index type is SIMPLE. This limits the parallelism of fetching records from the base files of affected partitions. The index picks the configured parallelism if the number of base files is larger than this configured value; otherwise, the number of base files is used as the parallelism. If the indexing stage is slow due to the limited parallelism, you can increase this to tune the performance.");
    public static final ConfigProperty<String> GLOBAL_SIMPLE_INDEX_PARALLELISM = ConfigProperty.key((String)"hoodie.global.simple.index.parallelism").defaultValue((Object)"100").withDocumentation("Only applies if index type is GLOBAL_SIMPLE. This limits the parallelism of fetching records from the base files of all table partitions. The index picks the configured parallelism if the number of base files is larger than this configured value; otherwise, the number of base files is used as the parallelism. If the indexing stage is slow due to the limited parallelism, you can increase this to tune the performance.");
    public static final ConfigProperty<String> BLOOM_INDEX_KEYS_PER_BUCKET = ConfigProperty.key((String)"hoodie.bloom.index.keys.per.bucket").defaultValue((Object)"10000000").withDocumentation("Only applies if bloomIndexBucketizedChecking is enabled and index type is bloom. This configuration controls the \u201cbucket\u201d size which tracks the number of record-key checks made against a single file and is the unit of work allocated to each partition performing bloom filter lookup. A higher value would amortize the fixed cost of reading a bloom filter to memory.");
    public static final ConfigProperty<String> BLOOM_INDEX_INPUT_STORAGE_LEVEL_VALUE = ConfigProperty.key((String)"hoodie.bloom.index.input.storage.level").defaultValue((Object)"MEMORY_AND_DISK_SER").withDocumentation("Only applies when #bloomIndexUseCaching is set. Determine what level of persistence is used to cache input RDDs. Refer to org.apache.spark.storage.StorageLevel for different values");
    public static final ConfigProperty<String> SIMPLE_INDEX_INPUT_STORAGE_LEVEL_VALUE = ConfigProperty.key((String)"hoodie.simple.index.input.storage.level").defaultValue((Object)"MEMORY_AND_DISK_SER").withDocumentation("Only applies when #simpleIndexUseCaching is set. Determine what level of persistence is used to cache input RDDs. Refer to org.apache.spark.storage.StorageLevel for different values");
    public static final ConfigProperty<String> BLOOM_INDEX_UPDATE_PARTITION_PATH_ENABLE = ConfigProperty.key((String)"hoodie.bloom.index.update.partition.path").defaultValue((Object)"true").withDocumentation("Only applies if index type is GLOBAL_BLOOM. When set to true, an update including the partition path of a record that already exists will result in inserting the incoming record into the new partition and deleting the original record in the old partition. When set to false, the original record will only be updated in the old partition");
    public static final ConfigProperty<String> SIMPLE_INDEX_UPDATE_PARTITION_PATH_ENABLE = ConfigProperty.key((String)"hoodie.simple.index.update.partition.path").defaultValue((Object)"true").withDocumentation("Similar to " + BLOOM_INDEX_UPDATE_PARTITION_PATH_ENABLE + ", but for simple index.");
    public static final ConfigProperty<String> BUCKET_INDEX_ENGINE_TYPE = ConfigProperty.key((String)"hoodie.index.bucket.engine").defaultValue((Object)"SIMPLE").sinceVersion("0.11.0").withDocumentation("Type of bucket index engine to use. Default is SIMPLE bucket index, with fixed number of bucket.Possible options are [SIMPLE | CONSISTENT_HASHING].Consistent hashing supports dynamic resizing of the number of bucket, solving potential data skew and file size issues of the SIMPLE hashing engine. Consistent hashing only works with MOR tables, only use simple hashing on COW tables.");
    public static final ConfigProperty<Integer> BUCKET_INDEX_NUM_BUCKETS = ConfigProperty.key((String)"hoodie.bucket.index.num.buckets").defaultValue((Object)256).withDocumentation("Only applies if index type is BUCKET. Determine the number of buckets in the hudi table, and each partition is divided to N buckets.");
    public static final ConfigProperty<String> BUCKET_INDEX_MAX_NUM_BUCKETS = ConfigProperty.key((String)"hoodie.bucket.index.max.num.buckets").noDefaultValue().sinceVersion("0.13.0").withDocumentation("Only applies if bucket index engine is consistent hashing. Determine the upper bound of the number of buckets in the hudi table. Bucket resizing cannot be done higher than this max limit.");
    public static final ConfigProperty<String> BUCKET_INDEX_MIN_NUM_BUCKETS = ConfigProperty.key((String)"hoodie.bucket.index.min.num.buckets").noDefaultValue().sinceVersion("0.13.0").withDocumentation("Only applies if bucket index engine is consistent hashing. Determine the lower bound of the number of buckets in the hudi table. Bucket resizing cannot be done lower than this min limit.");
    public static final ConfigProperty<String> BUCKET_INDEX_HASH_FIELD = ConfigProperty.key((String)"hoodie.bucket.index.hash.field").noDefaultValue().withDocumentation("Index key. It is used to index the record and find its file group. If not set, use record key field as default");
    public static final ConfigProperty<Double> BUCKET_SPLIT_THRESHOLD = ConfigProperty.key((String)"hoodie.bucket.index.split.threshold").defaultValue((Object)2.0).sinceVersion("0.13.0").withDocumentation("Control if the bucket should be split when using consistent hashing bucket index.Specifically, if a file slice size reaches `hoodie.xxxx.max.file.size` * threshold, then split will be carried out.");
    public static final ConfigProperty<Double> BUCKET_MERGE_THRESHOLD = ConfigProperty.key((String)"hoodie.bucket.index.merge.threshold").defaultValue((Object)0.2).sinceVersion("0.13.0").withDocumentation("Control if buckets should be merged when using consistent hashing bucket indexSpecifically, if a file slice size is smaller than `hoodie.xxxx.max.file.size` * threshold, then it will be consideredas a merge candidate.");
    @Deprecated
    public static final String HBASE_ZKQUORUM_PROP = HoodieHBaseIndexConfig.ZKQUORUM.key();
    @Deprecated
    public static final String HBASE_ZKPORT_PROP = HoodieHBaseIndexConfig.ZKPORT.key();
    @Deprecated
    public static final String HBASE_ZK_ZNODEPARENT = HoodieHBaseIndexConfig.ZK_NODE_PATH.key();
    @Deprecated
    public static final String HBASE_TABLENAME_PROP = HoodieHBaseIndexConfig.TABLENAME.key();
    @Deprecated
    public static final String HBASE_GET_BATCH_SIZE_PROP = HoodieHBaseIndexConfig.GET_BATCH_SIZE.key();
    @Deprecated
    public static final String HBASE_PUT_BATCH_SIZE_PROP = HoodieHBaseIndexConfig.PUT_BATCH_SIZE.key();
    @Deprecated
    public static final String DEFAULT_HBASE_BATCH_SIZE = "100";
    @Deprecated
    public static final String INDEX_TYPE_PROP = INDEX_TYPE.key();
    @Deprecated
    public static final String INDEX_CLASS_PROP = INDEX_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_INDEX_CLASS = (String)INDEX_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String BLOOM_FILTER_NUM_ENTRIES = BLOOM_FILTER_NUM_ENTRIES_VALUE.key();
    @Deprecated
    public static final String DEFAULT_BLOOM_FILTER_NUM_ENTRIES = (String)BLOOM_FILTER_NUM_ENTRIES_VALUE.defaultValue();
    @Deprecated
    public static final String BLOOM_FILTER_FPP = BLOOM_FILTER_FPP_VALUE.key();
    @Deprecated
    public static final String DEFAULT_BLOOM_FILTER_FPP = (String)BLOOM_FILTER_FPP_VALUE.defaultValue();
    @Deprecated
    public static final String BLOOM_INDEX_PARALLELISM_PROP = BLOOM_INDEX_PARALLELISM.key();
    @Deprecated
    public static final String DEFAULT_BLOOM_INDEX_PARALLELISM = (String)BLOOM_INDEX_PARALLELISM.defaultValue();
    @Deprecated
    public static final String BLOOM_INDEX_PRUNE_BY_RANGES_PROP = BLOOM_INDEX_PRUNE_BY_RANGES.key();
    @Deprecated
    public static final String DEFAULT_BLOOM_INDEX_PRUNE_BY_RANGES = (String)BLOOM_INDEX_PRUNE_BY_RANGES.defaultValue();
    @Deprecated
    public static final String BLOOM_INDEX_USE_CACHING_PROP = BLOOM_INDEX_USE_CACHING.key();
    @Deprecated
    public static final String DEFAULT_BLOOM_INDEX_USE_CACHING = (String)BLOOM_INDEX_USE_CACHING.defaultValue();
    @Deprecated
    public static final String BLOOM_INDEX_TREE_BASED_FILTER_PROP = BLOOM_INDEX_TREE_BASED_FILTER.key();
    @Deprecated
    public static final String DEFAULT_BLOOM_INDEX_TREE_BASED_FILTER = (String)BLOOM_INDEX_TREE_BASED_FILTER.defaultValue();
    @Deprecated
    public static final String BLOOM_INDEX_BUCKETIZED_CHECKING_PROP = BLOOM_INDEX_BUCKETIZED_CHECKING.key();
    @Deprecated
    public static final String DEFAULT_BLOOM_INDEX_BUCKETIZED_CHECKING = (String)BLOOM_INDEX_BUCKETIZED_CHECKING.defaultValue();
    @Deprecated
    public static final String BLOOM_INDEX_FILTER_TYPE = BLOOM_FILTER_TYPE.key();
    @Deprecated
    public static final String DEFAULT_BLOOM_INDEX_FILTER_TYPE = (String)BLOOM_FILTER_TYPE.defaultValue();
    @Deprecated
    public static final String HOODIE_BLOOM_INDEX_FILTER_DYNAMIC_MAX_ENTRIES = BLOOM_INDEX_FILTER_DYNAMIC_MAX_ENTRIES.key();
    @Deprecated
    public static final String DEFAULT_HOODIE_BLOOM_INDEX_FILTER_DYNAMIC_MAX_ENTRIES = (String)BLOOM_INDEX_FILTER_DYNAMIC_MAX_ENTRIES.defaultValue();
    @Deprecated
    public static final String SIMPLE_INDEX_USE_CACHING_PROP = SIMPLE_INDEX_USE_CACHING.key();
    @Deprecated
    public static final String DEFAULT_SIMPLE_INDEX_USE_CACHING = (String)SIMPLE_INDEX_USE_CACHING.defaultValue();
    @Deprecated
    public static final String SIMPLE_INDEX_PARALLELISM_PROP = SIMPLE_INDEX_PARALLELISM.key();
    @Deprecated
    public static final String DEFAULT_SIMPLE_INDEX_PARALLELISM = (String)SIMPLE_INDEX_PARALLELISM.defaultValue();
    @Deprecated
    public static final String GLOBAL_SIMPLE_INDEX_PARALLELISM_PROP = GLOBAL_SIMPLE_INDEX_PARALLELISM.key();
    @Deprecated
    public static final String DEFAULT_GLOBAL_SIMPLE_INDEX_PARALLELISM = (String)GLOBAL_SIMPLE_INDEX_PARALLELISM.defaultValue();
    @Deprecated
    public static final String BLOOM_INDEX_KEYS_PER_BUCKET_PROP = BLOOM_INDEX_KEYS_PER_BUCKET.key();
    @Deprecated
    public static final String DEFAULT_BLOOM_INDEX_KEYS_PER_BUCKET = (String)BLOOM_INDEX_KEYS_PER_BUCKET.defaultValue();
    @Deprecated
    public static final String BLOOM_INDEX_INPUT_STORAGE_LEVEL = BLOOM_INDEX_INPUT_STORAGE_LEVEL_VALUE.key();
    @Deprecated
    public static final String DEFAULT_BLOOM_INDEX_INPUT_STORAGE_LEVEL = (String)BLOOM_INDEX_INPUT_STORAGE_LEVEL_VALUE.defaultValue();
    @Deprecated
    public static final String SIMPLE_INDEX_INPUT_STORAGE_LEVEL = SIMPLE_INDEX_INPUT_STORAGE_LEVEL_VALUE.key();
    @Deprecated
    public static final String DEFAULT_SIMPLE_INDEX_INPUT_STORAGE_LEVEL = (String)SIMPLE_INDEX_INPUT_STORAGE_LEVEL_VALUE.defaultValue();
    @Deprecated
    public static final String BLOOM_INDEX_UPDATE_PARTITION_PATH = BLOOM_INDEX_UPDATE_PARTITION_PATH_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_BLOOM_INDEX_UPDATE_PARTITION_PATH = (String)BLOOM_INDEX_UPDATE_PARTITION_PATH_ENABLE.defaultValue();
    @Deprecated
    public static final String SIMPLE_INDEX_UPDATE_PARTITION_PATH = SIMPLE_INDEX_UPDATE_PARTITION_PATH_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_SIMPLE_INDEX_UPDATE_PARTITION_PATH = (String)SIMPLE_INDEX_UPDATE_PARTITION_PATH_ENABLE.defaultValue();
    private EngineType engineType;

    private HoodieIndexConfig() {
        this(EngineType.SPARK);
    }

    private HoodieIndexConfig(EngineType engineType) {
        this.engineType = engineType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private EngineType engineType = EngineType.SPARK;
        private final HoodieIndexConfig hoodieIndexConfig = new HoodieIndexConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.hoodieIndexConfig.getProps().load((Reader)reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.hoodieIndexConfig.getProps().putAll((Map)props);
            return this;
        }

        public Builder withIndexType(HoodieIndex.IndexType indexType) {
            this.hoodieIndexConfig.setValue(INDEX_TYPE, indexType.name());
            return this;
        }

        public Builder withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType bucketType) {
            this.hoodieIndexConfig.setValue(BUCKET_INDEX_ENGINE_TYPE, bucketType.name());
            return this;
        }

        public Builder withIndexClass(String indexClass) {
            this.hoodieIndexConfig.setValue(INDEX_CLASS_NAME, indexClass);
            return this;
        }

        public Builder withHBaseIndexConfig(HoodieHBaseIndexConfig hBaseIndexConfig) {
            this.hoodieIndexConfig.getProps().putAll((Map)hBaseIndexConfig.getProps());
            return this;
        }

        public Builder bloomFilterNumEntries(int numEntries) {
            this.hoodieIndexConfig.setValue(BLOOM_FILTER_NUM_ENTRIES_VALUE, String.valueOf(numEntries));
            return this;
        }

        public Builder bloomFilterFPP(double fpp) {
            this.hoodieIndexConfig.setValue(BLOOM_FILTER_FPP_VALUE, String.valueOf(fpp));
            return this;
        }

        public Builder bloomIndexParallelism(int parallelism) {
            this.hoodieIndexConfig.setValue(BLOOM_INDEX_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder bloomIndexPruneByRanges(boolean pruneRanges) {
            this.hoodieIndexConfig.setValue(BLOOM_INDEX_PRUNE_BY_RANGES, String.valueOf(pruneRanges));
            return this;
        }

        public Builder bloomIndexUseCaching(boolean useCaching) {
            this.hoodieIndexConfig.setValue(BLOOM_INDEX_USE_CACHING, String.valueOf(useCaching));
            return this;
        }

        public Builder bloomIndexUseMetadata(boolean useMetadata) {
            this.hoodieIndexConfig.setValue(BLOOM_INDEX_USE_METADATA, String.valueOf(useMetadata));
            return this;
        }

        public Builder bloomIndexTreebasedFilter(boolean useTreeFilter) {
            this.hoodieIndexConfig.setValue(BLOOM_INDEX_TREE_BASED_FILTER, String.valueOf(useTreeFilter));
            return this;
        }

        public Builder bloomIndexBucketizedChecking(boolean bucketizedChecking) {
            this.hoodieIndexConfig.setValue(BLOOM_INDEX_BUCKETIZED_CHECKING, String.valueOf(bucketizedChecking));
            return this;
        }

        public Builder bloomIndexKeysPerBucket(int keysPerBucket) {
            this.hoodieIndexConfig.setValue(BLOOM_INDEX_KEYS_PER_BUCKET, String.valueOf(keysPerBucket));
            return this;
        }

        public Builder withBloomIndexInputStorageLevel(String level) {
            this.hoodieIndexConfig.setValue(BLOOM_INDEX_INPUT_STORAGE_LEVEL_VALUE, level);
            return this;
        }

        public Builder withBloomIndexUpdatePartitionPath(boolean updatePartitionPath) {
            this.hoodieIndexConfig.setValue(BLOOM_INDEX_UPDATE_PARTITION_PATH_ENABLE, String.valueOf(updatePartitionPath));
            return this;
        }

        public Builder withSimpleIndexParallelism(int parallelism) {
            this.hoodieIndexConfig.setValue(SIMPLE_INDEX_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder simpleIndexUseCaching(boolean useCaching) {
            this.hoodieIndexConfig.setValue(SIMPLE_INDEX_USE_CACHING, String.valueOf(useCaching));
            return this;
        }

        public Builder withSimpleIndexInputStorageLevel(String level) {
            this.hoodieIndexConfig.setValue(SIMPLE_INDEX_INPUT_STORAGE_LEVEL_VALUE, level);
            return this;
        }

        public Builder withGlobalSimpleIndexParallelism(int parallelism) {
            this.hoodieIndexConfig.setValue(GLOBAL_SIMPLE_INDEX_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withGlobalSimpleIndexUpdatePartitionPath(boolean updatePartitionPath) {
            this.hoodieIndexConfig.setValue(SIMPLE_INDEX_UPDATE_PARTITION_PATH_ENABLE, String.valueOf(updatePartitionPath));
            return this;
        }

        public Builder withEngineType(EngineType engineType) {
            this.engineType = engineType;
            return this;
        }

        public Builder withBucketNum(String bucketNum) {
            this.hoodieIndexConfig.setValue(BUCKET_INDEX_NUM_BUCKETS, bucketNum);
            return this;
        }

        public Builder withBucketMaxNum(int bucketMaxNum) {
            this.hoodieIndexConfig.setValue(BUCKET_INDEX_MAX_NUM_BUCKETS, String.valueOf(bucketMaxNum));
            return this;
        }

        public Builder withBucketMinNum(int bucketMinNum) {
            this.hoodieIndexConfig.setValue(BUCKET_INDEX_MIN_NUM_BUCKETS, String.valueOf(bucketMinNum));
            return this;
        }

        public Builder withIndexKeyField(String keyField) {
            this.hoodieIndexConfig.setValue(BUCKET_INDEX_HASH_FIELD, keyField);
            return this;
        }

        public HoodieIndexConfig build() {
            this.hoodieIndexConfig.setDefaultValue(INDEX_TYPE, this.getDefaultIndexType(this.engineType));
            this.hoodieIndexConfig.setDefaults(HoodieIndexConfig.class.getName());
            HoodieIndex.IndexType.valueOf(this.hoodieIndexConfig.getString(INDEX_TYPE));
            this.validateBucketIndexConfig();
            return this.hoodieIndexConfig;
        }

        private String getDefaultIndexType(EngineType engineType) {
            switch (engineType) {
                case SPARK: {
                    return HoodieIndex.IndexType.SIMPLE.name();
                }
                case FLINK: 
                case JAVA: {
                    return HoodieIndex.IndexType.INMEMORY.name();
                }
            }
            throw new HoodieNotSupportedException("Unsupported engine " + engineType);
        }

        public EngineType getEngineType() {
            return this.engineType;
        }

        private void validateBucketIndexConfig() {
            if (this.hoodieIndexConfig.getString(INDEX_TYPE).equalsIgnoreCase(HoodieIndex.IndexType.BUCKET.toString())) {
                if (StringUtils.isNullOrEmpty((String)this.hoodieIndexConfig.getString(BUCKET_INDEX_HASH_FIELD))) {
                    this.hoodieIndexConfig.setValue(BUCKET_INDEX_HASH_FIELD, this.hoodieIndexConfig.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME));
                } else {
                    boolean valid = Arrays.stream(this.hoodieIndexConfig.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME).split(",")).collect(Collectors.toSet()).containsAll(Arrays.asList(this.hoodieIndexConfig.getString(BUCKET_INDEX_HASH_FIELD).split(",")));
                    if (!valid) {
                        throw new HoodieIndexException("Bucket index key (if configured) must be subset of record key.");
                    }
                }
                if (this.hoodieIndexConfig.getIntOrDefault(BUCKET_INDEX_NUM_BUCKETS) <= 0) {
                    throw new HoodieIndexException("When using bucket index, hoodie.bucket.index.num.buckets cannot be negative.");
                }
                int bucketNum = this.hoodieIndexConfig.getInt(BUCKET_INDEX_NUM_BUCKETS);
                if (StringUtils.isNullOrEmpty((String)this.hoodieIndexConfig.getString(BUCKET_INDEX_MAX_NUM_BUCKETS))) {
                    this.hoodieIndexConfig.setValue(BUCKET_INDEX_MAX_NUM_BUCKETS, Integer.toString(bucketNum));
                } else if (this.hoodieIndexConfig.getInt(BUCKET_INDEX_MAX_NUM_BUCKETS) < bucketNum) {
                    LOG.warn((Object)("Maximum bucket number is smaller than bucket number, maximum: " + this.hoodieIndexConfig.getInt(BUCKET_INDEX_MAX_NUM_BUCKETS) + ", bucketNum: " + bucketNum));
                    this.hoodieIndexConfig.setValue(BUCKET_INDEX_MAX_NUM_BUCKETS, Integer.toString(bucketNum));
                }
                if (StringUtils.isNullOrEmpty((String)this.hoodieIndexConfig.getString(BUCKET_INDEX_MIN_NUM_BUCKETS))) {
                    this.hoodieIndexConfig.setValue(BUCKET_INDEX_MIN_NUM_BUCKETS, Integer.toString(bucketNum));
                } else if (this.hoodieIndexConfig.getInt(BUCKET_INDEX_MIN_NUM_BUCKETS) > bucketNum) {
                    LOG.warn((Object)("Minimum bucket number is larger than the bucket number, minimum: " + this.hoodieIndexConfig.getInt(BUCKET_INDEX_MIN_NUM_BUCKETS) + ", bucketNum: " + bucketNum));
                    this.hoodieIndexConfig.setValue(BUCKET_INDEX_MIN_NUM_BUCKETS, Integer.toString(bucketNum));
                }
            }
        }
    }
}

