/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RestorePlanActionExecutor<T, I, K, O>
extends BaseActionExecutor<T, I, K, O, Option<HoodieRestorePlan>> {
    private static final Logger LOG = LogManager.getLogger(RestorePlanActionExecutor.class);
    public static final Integer RESTORE_PLAN_VERSION_1 = 1;
    public static final Integer RESTORE_PLAN_VERSION_2;
    public static final Integer LATEST_RESTORE_PLAN_VERSION;
    private final String savepointToRestoreTimestamp;

    public RestorePlanActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, String savepointToRestoreTimestamp) {
        super(context, config, table, instantTime);
        this.savepointToRestoreTimestamp = savepointToRestoreTimestamp;
    }

    @Override
    public Option<HoodieRestorePlan> execute() {
        HoodieInstant restoreInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "restore", this.instantTime);
        try {
            List pendingClusteringInstantsToRollback = this.table.getActiveTimeline().filterPendingReplaceTimeline().filter(instant -> ClusteringUtils.isPendingClusteringInstant((HoodieTableMetaClient)this.table.getMetaClient(), (HoodieInstant)instant)).getReverseOrderedInstants().filter(instant -> HoodieActiveTimeline.GREATER_THAN.test(instant.getTimestamp(), this.savepointToRestoreTimestamp)).collect(Collectors.toList());
            List commitInstantsToRollback = this.table.getActiveTimeline().getWriteTimeline().getReverseOrderedInstants().filter(instant -> HoodieActiveTimeline.GREATER_THAN.test(instant.getTimestamp(), this.savepointToRestoreTimestamp)).filter(instant -> !pendingClusteringInstantsToRollback.contains(instant)).collect(Collectors.toList());
            List instantsToRollback = Stream.concat(pendingClusteringInstantsToRollback.stream(), commitInstantsToRollback.stream()).map(entry -> new HoodieInstantInfo(entry.getTimestamp(), entry.getAction())).collect(Collectors.toList());
            HoodieRestorePlan restorePlan = new HoodieRestorePlan(instantsToRollback, LATEST_RESTORE_PLAN_VERSION, this.savepointToRestoreTimestamp);
            this.table.getActiveTimeline().saveToRestoreRequested(restoreInstant, TimelineMetadataUtils.serializeRestorePlan((HoodieRestorePlan)restorePlan));
            this.table.getMetaClient().reloadActiveTimeline();
            LOG.info((Object)("Requesting Restore with instant time " + restoreInstant));
            return Option.of((Object)restorePlan);
        }
        catch (IOException e) {
            LOG.error((Object)"Got exception when saving restore requested file", (Throwable)e);
            throw new HoodieIOException(e.getMessage(), e);
        }
    }

    static {
        LATEST_RESTORE_PLAN_VERSION = RESTORE_PLAN_VERSION_2 = Integer.valueOf(2);
    }
}

