/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.client.utils.MetadataConversionUtils;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.action.rollback.SerializablePathFilter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ListingBasedRollbackStrategy
implements BaseRollbackPlanActionExecutor.RollbackStrategy {
    private static final Logger LOG = LogManager.getLogger(ListingBasedRollbackStrategy.class);
    protected final HoodieTable<?, ?, ?, ?> table;
    protected final transient HoodieEngineContext context;
    protected final HoodieWriteConfig config;
    protected final String instantTime;

    public ListingBasedRollbackStrategy(HoodieTable<?, ?, ?, ?> table, HoodieEngineContext context, HoodieWriteConfig config, String instantTime) {
        this.table = table;
        this.context = context;
        this.config = config;
        this.instantTime = instantTime;
    }

    @Override
    public List<HoodieRollbackRequest> getRollbackRequests(HoodieInstant instantToRollback) {
        try {
            HoodieTableMetaClient metaClient = this.table.getMetaClient();
            List partitionPaths = FSUtils.getAllPartitionPaths((HoodieEngineContext)this.context, (String)this.table.getMetaClient().getBasePath(), (boolean)false, (boolean)false);
            int numPartitions = Math.max(Math.min(partitionPaths.size(), this.config.getRollbackParallelism()), 1);
            this.context.setJobStatus(this.getClass().getSimpleName(), "Creating Listing Rollback Plan: " + this.config.getTableName());
            HoodieTableType tableType = this.table.getMetaClient().getTableType();
            String baseFileExtension = this.getBaseFileExtension(metaClient);
            Option<HoodieCommitMetadata> commitMetadataOptional = MetadataConversionUtils.getHoodieCommitMetadata(metaClient, instantToRollback);
            Boolean isCommitMetadataCompleted = this.checkCommitMetadataCompleted(instantToRollback, commitMetadataOptional);
            return this.context.flatMap(partitionPaths, (SerializableFunction & Serializable)partitionPath -> {
                ArrayList<HoodieRollbackRequest> hoodieRollbackRequests;
                block14: {
                    block15: {
                        FileStatus[] filesToDelete;
                        block13: {
                            hoodieRollbackRequests = new ArrayList<HoodieRollbackRequest>(partitionPaths.size());
                            filesToDelete = this.fetchFilesFromInstant(instantToRollback, (String)partitionPath, metaClient.getBasePath(), baseFileExtension, metaClient.getFs(), commitMetadataOptional, isCommitMetadataCompleted);
                            if (HoodieTableType.COPY_ON_WRITE != tableType) break block13;
                            hoodieRollbackRequests.add(this.getHoodieRollbackRequest((String)partitionPath, filesToDelete));
                            break block14;
                        }
                        if (HoodieTableType.MERGE_ON_READ != tableType) break block15;
                        String commit = instantToRollback.getTimestamp();
                        HoodieActiveTimeline activeTimeline = this.table.getMetaClient().reloadActiveTimeline();
                        switch (instantToRollback.getAction()) {
                            case "commit": 
                            case "replacecommit": {
                                hoodieRollbackRequests.add(this.getHoodieRollbackRequest((String)partitionPath, filesToDelete));
                                break;
                            }
                            case "compaction": {
                                boolean higherDeltaCommits;
                                boolean bl = higherDeltaCommits = !activeTimeline.getDeltaCommitTimeline().filterCompletedInstants().findInstantsAfter(commit, 1).empty();
                                if (higherDeltaCommits) {
                                    hoodieRollbackRequests.add(this.getHoodieRollbackRequest((String)partitionPath, this.listFilesToBeDeleted(instantToRollback.getTimestamp(), baseFileExtension, (String)partitionPath, (FileSystem)metaClient.getFs())));
                                    break;
                                }
                                hoodieRollbackRequests.add(this.getHoodieRollbackRequest((String)partitionPath, filesToDelete));
                                break;
                            }
                            case "deltacommit": {
                                HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])this.table.getMetaClient().getCommitTimeline().getInstantDetails(instantToRollback).get()), HoodieCommitMetadata.class);
                                hoodieRollbackRequests.add(this.getHoodieRollbackRequest((String)partitionPath, filesToDelete));
                                if (commitMetadata.getPartitionToWriteStats().containsKey(partitionPath)) {
                                    hoodieRollbackRequests.addAll(ListingBasedRollbackStrategy.getRollbackRequestToAppend(partitionPath, instantToRollback, commitMetadata, this.table));
                                    break;
                                }
                                break block14;
                            }
                            default: {
                                throw new HoodieRollbackException("Unknown listing type, during rollback of " + instantToRollback);
                            }
                        }
                        break block14;
                    }
                    throw new HoodieRollbackException(String.format("Unsupported table type: %s, during listing rollback of %s", tableType, instantToRollback));
                }
                return hoodieRollbackRequests.stream();
            }, numPartitions);
        }
        catch (Exception e) {
            LOG.error((Object)("Generating rollback requests failed for " + instantToRollback.getTimestamp()), (Throwable)e);
            throw new HoodieRollbackException("Generating rollback requests failed for " + instantToRollback.getTimestamp(), e);
        }
    }

    private String getBaseFileExtension(HoodieTableMetaClient metaClient) {
        return metaClient.getTableConfig().getBaseFileFormat().getFileExtension();
    }

    @NotNull
    private HoodieRollbackRequest getHoodieRollbackRequest(String partitionPath, FileStatus[] filesToDeletedStatus) {
        List<String> filesToDelete = this.getFilesToBeDeleted(filesToDeletedStatus);
        return new HoodieRollbackRequest(partitionPath, "", "", filesToDelete, Collections.emptyMap());
    }

    @NotNull
    private List<String> getFilesToBeDeleted(FileStatus[] dataFilesToDeletedStatus) {
        return Arrays.stream(dataFilesToDeletedStatus).map(fileStatus -> {
            String dataFileToBeDeleted = fileStatus.getPath().toString();
            return dataFileToBeDeleted.substring(dataFileToBeDeleted.indexOf(":") + 1);
        }).collect(Collectors.toList());
    }

    private FileStatus[] listFilesToBeDeleted(String commit, String basefileExtension, String partitionPath, FileSystem fs) throws IOException {
        LOG.info((Object)("Collecting files to be cleaned/rolledback up for path " + partitionPath + " and commit " + commit));
        PathFilter filter = path -> {
            if (path.toString().contains(basefileExtension)) {
                String fileCommitTime = FSUtils.getCommitTime((String)path.getName());
                return commit.equals(fileCommitTime);
            }
            return false;
        };
        return fs.listStatus(FSUtils.getPartitionPath((String)this.config.getBasePath(), (String)partitionPath), filter);
    }

    private FileStatus[] fetchFilesFromInstant(HoodieInstant instantToRollback, String partitionPath, String basePath, String baseFileExtension, HoodieWrapperFileSystem fs, Option<HoodieCommitMetadata> commitMetadataOptional, Boolean isCommitMetadataCompleted) throws IOException {
        if (isCommitMetadataCompleted.booleanValue()) {
            return this.fetchFilesFromCommitMetadata(instantToRollback, partitionPath, basePath, (HoodieCommitMetadata)commitMetadataOptional.get(), baseFileExtension, fs);
        }
        return this.fetchFilesFromListFiles(instantToRollback, partitionPath, basePath, baseFileExtension, fs);
    }

    private FileStatus[] fetchFilesFromCommitMetadata(HoodieInstant instantToRollback, String partitionPath, String basePath, HoodieCommitMetadata commitMetadata, String baseFileExtension, HoodieWrapperFileSystem fs) throws IOException {
        SerializablePathFilter pathFilter = ListingBasedRollbackStrategy.getSerializablePathFilter(baseFileExtension, instantToRollback.getTimestamp());
        Path[] filePaths = ListingBasedRollbackStrategy.getFilesFromCommitMetadata(basePath, commitMetadata, partitionPath);
        return fs.listStatus((Path[])Arrays.stream(filePaths).filter(entry -> {
            try {
                return fs.exists(entry);
            }
            catch (Exception e) {
                LOG.error((Object)("Exists check failed for " + entry.toString()), (Throwable)e);
                return true;
            }
        }).toArray(Path[]::new), (PathFilter)pathFilter);
    }

    private FileStatus[] fetchFilesFromListFiles(HoodieInstant instantToRollback, String partitionPath, String basePath, String baseFileExtension, HoodieWrapperFileSystem fs) throws IOException {
        SerializablePathFilter pathFilter = ListingBasedRollbackStrategy.getSerializablePathFilter(baseFileExtension, instantToRollback.getTimestamp());
        Path[] filePaths = ListingBasedRollbackStrategy.listFilesToBeDeleted(basePath, partitionPath);
        return fs.listStatus(filePaths, (PathFilter)pathFilter);
    }

    private Boolean checkCommitMetadataCompleted(HoodieInstant instantToRollback, Option<HoodieCommitMetadata> commitMetadataOptional) {
        return commitMetadataOptional.isPresent() && instantToRollback.isCompleted() && !WriteOperationType.UNKNOWN.equals((Object)((HoodieCommitMetadata)commitMetadataOptional.get()).getOperationType());
    }

    private static Path[] listFilesToBeDeleted(String basePath, String partitionPath) {
        return new Path[]{FSUtils.getPartitionPath((String)basePath, (String)partitionPath)};
    }

    private static Path[] getFilesFromCommitMetadata(String basePath, HoodieCommitMetadata commitMetadata, String partitionPath) {
        List fullPaths = commitMetadata.getFullPathsByPartitionPath(basePath, partitionPath);
        return (Path[])fullPaths.stream().map(Path::new).toArray(Path[]::new);
    }

    @NotNull
    private static SerializablePathFilter getSerializablePathFilter(String basefileExtension, String commit) {
        return path -> {
            if (path.toString().endsWith(basefileExtension)) {
                String fileCommitTime = FSUtils.getCommitTime((String)path.getName());
                return commit.equals(fileCommitTime);
            }
            if (FSUtils.isLogFile((Path)path)) {
                String fileCommitTime = FSUtils.getBaseCommitTimeFromLogPath((Path)path);
                return commit.equals(fileCommitTime);
            }
            return false;
        };
    }

    public static List<HoodieRollbackRequest> getRollbackRequestToAppend(String partitionPath, HoodieInstant rollbackInstant, HoodieCommitMetadata commitMetadata, HoodieTable<?, ?, ?, ?> table) {
        ArrayList<HoodieRollbackRequest> hoodieRollbackRequests = new ArrayList<HoodieRollbackRequest>();
        ValidationUtils.checkArgument((boolean)rollbackInstant.getAction().equals("deltacommit"));
        Map latestFileSlices = table.getSliceView().getLatestFileSlicesBeforeOrOn(partitionPath, rollbackInstant.getTimestamp(), true).collect(Collectors.toMap(FileSlice::getFileId, Function.identity()));
        List hoodieWriteStats = ((List)commitMetadata.getPartitionToWriteStats().get(partitionPath)).stream().filter(writeStat -> {
            boolean validForRollback;
            boolean bl = validForRollback = writeStat != null && !writeStat.getPrevCommit().equals("null") && writeStat.getPrevCommit() != null && latestFileSlices.containsKey(writeStat.getFileId());
            if (!validForRollback) {
                return false;
            }
            FileSlice latestFileSlice = (FileSlice)latestFileSlices.get(writeStat.getFileId());
            ValidationUtils.checkArgument((boolean)HoodieTimeline.compareTimestamps((String)latestFileSlice.getBaseInstantTime(), (BiPredicate)HoodieTimeline.LESSER_THAN_OR_EQUALS, (String)rollbackInstant.getTimestamp()), (String)"Log-file base-instant could not be less than the instant being rolled back");
            return HoodieTimeline.compareTimestamps((String)latestFileSlice.getBaseInstantTime(), (BiPredicate)HoodieTimeline.LESSER_THAN, (String)rollbackInstant.getTimestamp());
        }).collect(Collectors.toList());
        for (HoodieWriteStat writeStat2 : hoodieWriteStats) {
            FileSlice latestFileSlice = (FileSlice)latestFileSlices.get(writeStat2.getFileId());
            String fileId = writeStat2.getFileId();
            String latestBaseInstant = latestFileSlice.getBaseInstantTime();
            Path fullLogFilePath = FSUtils.getPartitionPath((String)table.getConfig().getBasePath(), (String)writeStat2.getPath());
            Map<String, Long> logFilesWithBlocksToRollback = Collections.singletonMap(fullLogFilePath.toString(), writeStat2.getTotalWriteBytes());
            hoodieRollbackRequests.add(new HoodieRollbackRequest(partitionPath, fileId, latestBaseInstant, Collections.emptyList(), logFilesWithBlocksToRollback));
        }
        return hoodieRollbackRequests;
    }
}

