/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieReadHandle;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.table.HoodieTable;

public class HoodieKeyLocationFetchHandle<T, I, K, O>
extends HoodieReadHandle<T, I, K, O> {
    private final Pair<String, HoodieBaseFile> partitionPathBaseFilePair;
    private final Option<BaseKeyGenerator> keyGeneratorOpt;

    public HoodieKeyLocationFetchHandle(HoodieWriteConfig config, HoodieTable<T, I, K, O> hoodieTable, Pair<String, HoodieBaseFile> partitionPathBaseFilePair, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config, hoodieTable, (Pair<String, String>)Pair.of((Object)partitionPathBaseFilePair.getLeft(), (Object)((HoodieBaseFile)partitionPathBaseFilePair.getRight()).getFileId()));
        this.partitionPathBaseFilePair = partitionPathBaseFilePair;
        this.keyGeneratorOpt = keyGeneratorOpt;
    }

    public Stream<Pair<HoodieKey, HoodieRecordLocation>> locations() {
        HoodieBaseFile baseFile = (HoodieBaseFile)this.partitionPathBaseFilePair.getRight();
        BaseFileUtils baseFileUtils = BaseFileUtils.getInstance((String)baseFile.getPath());
        List hoodieKeyList = new ArrayList();
        hoodieKeyList = this.keyGeneratorOpt.isPresent() ? baseFileUtils.fetchHoodieKeys(this.hoodieTable.getHadoopConf(), new Path(baseFile.getPath()), this.keyGeneratorOpt) : baseFileUtils.fetchHoodieKeys(this.hoodieTable.getHadoopConf(), new Path(baseFile.getPath()));
        return hoodieKeyList.stream().map(entry -> Pair.of((Object)entry, (Object)new HoodieRecordLocation(baseFile.getCommitTime(), baseFile.getFileId())));
    }
}

