/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieConsistentHashingMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.hash.HashID;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.jetbrains.annotations.NotNull;

public class ConsistentBucketIdentifier
extends BucketIdentifier {
    private final HoodieConsistentHashingMetadata metadata;
    private final TreeMap<Integer, ConsistentHashingNode> ring;
    private final Map<String, ConsistentHashingNode> fileIdToBucket;

    public ConsistentBucketIdentifier(HoodieConsistentHashingMetadata metadata) {
        this.metadata = metadata;
        this.fileIdToBucket = new HashMap<String, ConsistentHashingNode>();
        this.ring = new TreeMap();
        this.initialize();
    }

    public Collection<ConsistentHashingNode> getNodes() {
        return this.ring.values();
    }

    public HoodieConsistentHashingMetadata getMetadata() {
        return this.metadata;
    }

    public int getNumBuckets() {
        return this.ring.size();
    }

    public ConsistentHashingNode getBucketByFileId(String fileId) {
        return this.fileIdToBucket.get(fileId);
    }

    public ConsistentHashingNode getBucket(HoodieKey hoodieKey, List<String> indexKeyFields) {
        return this.getBucket(ConsistentBucketIdentifier.getHashKeys(hoodieKey.getRecordKey(), indexKeyFields));
    }

    protected ConsistentHashingNode getBucket(List<String> hashKeys) {
        int hashValue = HashID.getXXHash32((String)String.join((CharSequence)"", hashKeys), (int)0);
        return this.getBucket(hashValue & Integer.MAX_VALUE);
    }

    protected ConsistentHashingNode getBucket(int hashValue) {
        SortedMap<Integer, ConsistentHashingNode> tailMap = this.ring.tailMap(hashValue);
        return tailMap.isEmpty() ? this.ring.firstEntry().getValue() : (ConsistentHashingNode)tailMap.get(tailMap.firstKey());
    }

    public ConsistentHashingNode getFormerBucket(String fileId) {
        return this.getFormerBucket(this.getBucketByFileId(fileId).getValue());
    }

    public ConsistentHashingNode getFormerBucket(int hashValue) {
        SortedMap<Integer, ConsistentHashingNode> headMap = this.ring.headMap(hashValue);
        return headMap.isEmpty() ? this.ring.lastEntry().getValue() : (ConsistentHashingNode)headMap.get(headMap.lastKey());
    }

    public List<ConsistentHashingNode> mergeBucket(List<String> fileIds) {
        ValidationUtils.checkArgument((fileIds.size() >= 2 ? 1 : 0) != 0, (String)"At least two file groups should be provided for merging");
        List nodes = fileIds.stream().map(this::getBucketByFileId).collect(Collectors.toList());
        for (int i = 0; i < nodes.size() - 1; ++i) {
            ValidationUtils.checkState((this.getFormerBucket(((ConsistentHashingNode)nodes.get(i + 1)).getValue()).getValue() == ((ConsistentHashingNode)nodes.get(i)).getValue() ? 1 : 0) != 0, (String)"Cannot merge discontinuous hash range");
        }
        ArrayList<ConsistentHashingNode> childNodes = new ArrayList<ConsistentHashingNode>(nodes.size());
        for (int i = 0; i < nodes.size() - 1; ++i) {
            childNodes.add(new ConsistentHashingNode(((ConsistentHashingNode)nodes.get(i)).getValue(), null, ConsistentHashingNode.NodeTag.DELETE));
        }
        childNodes.add(new ConsistentHashingNode(((ConsistentHashingNode)nodes.get(nodes.size() - 1)).getValue(), FSUtils.createNewFileIdPfx(), ConsistentHashingNode.NodeTag.REPLACE));
        return childNodes;
    }

    public Option<List<ConsistentHashingNode>> splitBucket(String fileId) {
        ConsistentHashingNode bucket = this.getBucketByFileId(fileId);
        ValidationUtils.checkState((bucket != null ? 1 : 0) != 0, (String)"FileId has no corresponding bucket");
        return this.splitBucket(bucket);
    }

    public Option<List<ConsistentHashingNode>> splitBucket(@NotNull ConsistentHashingNode bucket) {
        ConsistentHashingNode formerBucket = this.getFormerBucket(bucket.getValue());
        long mid = (long)formerBucket.getValue() + (long)bucket.getValue() + (formerBucket.getValue() < bucket.getValue() ? 0L : 0x80000000L);
        if ((mid = mid >> 1 & Integer.MAX_VALUE) == (long)formerBucket.getValue() || mid == (long)bucket.getValue()) {
            return Option.empty();
        }
        return Option.of(Arrays.asList(new ConsistentHashingNode((int)mid, FSUtils.createNewFileIdPfx(), ConsistentHashingNode.NodeTag.REPLACE), new ConsistentHashingNode(bucket.getValue(), FSUtils.createNewFileIdPfx(), ConsistentHashingNode.NodeTag.REPLACE)));
    }

    private void initialize() {
        for (ConsistentHashingNode p : this.metadata.getNodes()) {
            this.ring.put(p.getValue(), p);
            this.fileIdToBucket.put(FSUtils.createNewFileId((String)p.getFileIdPrefix(), (int)0), p);
        }
        block5: for (ConsistentHashingNode p : this.metadata.getChildrenNodes()) {
            switch (p.getTag()) {
                case REPLACE: {
                    ConsistentHashingNode tmp = this.ring.put(p.getValue(), p);
                    if (tmp != null) {
                        this.fileIdToBucket.remove(FSUtils.createNewFileId((String)tmp.getFileIdPrefix(), (int)0));
                    }
                    this.fileIdToBucket.put(FSUtils.createNewFileId((String)p.getFileIdPrefix(), (int)0), p);
                    continue block5;
                }
                case DELETE: {
                    ConsistentHashingNode tmp = this.ring.remove(p.getValue());
                    this.fileIdToBucket.remove(FSUtils.createNewFileId((String)tmp.getFileIdPrefix(), (int)0));
                    continue block5;
                }
            }
            throw new HoodieClusteringException("Children node is tagged as NORMAL or unknown tag: " + p);
        }
    }
}

