/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.utils.LazyIterableIterator;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.execution.CopyOnWriteInsertHandler;
import org.apache.hudi.io.CreateHandleFactory;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.util.ExecutorFactory;

public abstract class HoodieLazyInsertIterable<T>
extends LazyIterableIterator<HoodieRecord<T>, List<WriteStatus>> {
    protected final HoodieWriteConfig hoodieConfig;
    protected final String instantTime;
    protected boolean areRecordsSorted;
    protected final HoodieTable hoodieTable;
    protected final String idPrefix;
    protected TaskContextSupplier taskContextSupplier;
    protected WriteHandleFactory writeHandleFactory;

    public HoodieLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier) {
        this(recordItr, areRecordsSorted, config, instantTime, hoodieTable, idPrefix, taskContextSupplier, new CreateHandleFactory());
    }

    public HoodieLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, WriteHandleFactory writeHandleFactory) {
        super(recordItr);
        this.areRecordsSorted = areRecordsSorted;
        this.hoodieConfig = config;
        this.instantTime = instantTime;
        this.hoodieTable = hoodieTable;
        this.idPrefix = idPrefix;
        this.taskContextSupplier = taskContextSupplier;
        this.writeHandleFactory = writeHandleFactory;
    }

    static <T> Function<HoodieRecord<T>, HoodieInsertValueGenResult<HoodieRecord>> getTransformer(Schema schema, HoodieWriteConfig writeConfig) {
        return HoodieLazyInsertIterable.getTransformerInternal(schema, writeConfig);
    }

    private static <T> Function<HoodieRecord<T>, HoodieInsertValueGenResult<HoodieRecord>> getTransformerInternal(Schema schema, HoodieWriteConfig writeConfig) {
        boolean shouldClone = ExecutorFactory.isBufferingRecords(writeConfig);
        return record -> {
            HoodieRecord clonedRecord = shouldClone ? record.copy() : record;
            return new HoodieInsertValueGenResult<HoodieRecord>(clonedRecord, schema, (Properties)writeConfig.getProps());
        };
    }

    @Override
    protected void start() {
    }

    @Override
    protected void end() {
    }

    protected CopyOnWriteInsertHandler getInsertHandler() {
        return new CopyOnWriteInsertHandler(this.hoodieConfig, this.instantTime, this.areRecordsSorted, this.hoodieTable, this.idPrefix, this.taskContextSupplier, this.writeHandleFactory);
    }

    public static class HoodieInsertValueGenResult<R extends HoodieRecord> {
        private final R record;
        public final Schema schema;
        public final Properties props;

        public HoodieInsertValueGenResult(R record, Schema schema, Properties properties) {
            this.record = record;
            this.schema = schema;
            this.props = properties;
        }

        public R getResult() {
            return this.record;
        }
    }
}

