/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.hudi.common.config.HoodieTableServiceManagerConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.RetryHelper;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieRemoteException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoodieTableServiceManagerClient {
    private static final String BASE_URL = "/v1/hoodie/service";
    public static final String EXECUTE_COMPACTION = String.format("%s/%s", "/v1/hoodie/service", "compact");
    public static final String EXECUTE_CLUSTERING = String.format("%s/%s", "/v1/hoodie/service", "cluster");
    public static final String EXECUTE_CLEAN = String.format("%s/%s", "/v1/hoodie/service", "clean");
    public static final String ACTION = "action";
    public static final String DATABASE_NAME_PARAM = "db_name";
    public static final String TABLE_NAME_PARAM = "table_name";
    public static final String BASEPATH_PARAM = "basepath";
    public static final String INSTANT_PARAM = "instant";
    public static final String USERNAME = "username";
    public static final String CLUSTER = "cluster";
    public static final String QUEUE = "queue";
    public static final String RESOURCE = "resource";
    public static final String PARALLELISM = "parallelism";
    public static final String EXTRA_PARAMS = "extra_params";
    public static final String EXECUTION_ENGINE = "execution_engine";
    public static final String RETRY_EXCEPTIONS = "IOException";
    private final HoodieTableServiceManagerConfig config;
    private final HoodieTableMetaClient metaClient;
    private final String uri;
    private final String basePath;
    private final String dbName;
    private final String tableName;
    private static final Logger LOG = LogManager.getLogger(HoodieTableServiceManagerClient.class);

    public HoodieTableServiceManagerClient(HoodieTableMetaClient metaClient, HoodieTableServiceManagerConfig config) {
        this.basePath = metaClient.getBasePathV2().toString();
        this.dbName = metaClient.getTableConfig().getDatabaseName();
        this.tableName = metaClient.getTableConfig().getTableName();
        this.uri = config.getTableServiceManagerURIs();
        this.config = config;
        this.metaClient = metaClient;
    }

    private String executeRequest(String requestPath, Map<String, String> queryParameters) throws IOException {
        URIBuilder builder = new URIBuilder(URI.create(this.uri)).setPath(requestPath);
        queryParameters.forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
        String url = builder.toString();
        LOG.info("Sending request to table management service : (" + url + ")");
        int timeoutMs = this.config.getConnectionTimeoutSec() * 1000;
        int requestRetryLimit = this.config.getConnectionRetryLimit();
        int connectionRetryDelay = this.config.getConnectionRetryDelay();
        RetryHelper retryHelper = new RetryHelper((long)connectionRetryDelay, requestRetryLimit, (long)connectionRetryDelay, RETRY_EXCEPTIONS);
        return (String)retryHelper.tryWith((RetryHelper.CheckedFunction & Serializable)() -> Request.Get((String)url).connectTimeout(timeoutMs).socketTimeout(timeoutMs).execute().returnContent().asString()).start();
    }

    private Map<String, String> getParamsWithAdditionalParams(String[] paramNames, String[] paramVals) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(BASEPATH_PARAM, this.basePath);
        ValidationUtils.checkArgument((paramNames.length == paramVals.length ? 1 : 0) != 0);
        for (int i = 0; i < paramNames.length; ++i) {
            paramsMap.put(paramNames[i], paramVals[i]);
        }
        return paramsMap;
    }

    public Option<String> executeCompaction() {
        try {
            String instantRange = StringUtils.join((String[])((String[])this.metaClient.reloadActiveTimeline().filterPendingCompactionTimeline().getInstantsAsStream().map(HoodieInstant::getTimestamp).toArray(String[]::new)), (String)",");
            this.executeRequest(EXECUTE_COMPACTION, this.getDefaultParams(Action.REQUEST, instantRange));
            return Option.of((Object)instantRange);
        }
        catch (IOException e) {
            throw new HoodieRemoteException(e);
        }
    }

    public Option<String> executeClean() {
        try {
            String instantRange = StringUtils.join((String[])((String[])this.metaClient.reloadActiveTimeline().getCleanerTimeline().filterInflightsAndRequested().getInstantsAsStream().map(HoodieInstant::getTimestamp).toArray(String[]::new)), (String)",");
            this.executeRequest(EXECUTE_CLEAN, this.getDefaultParams(Action.REQUEST, instantRange));
            return Option.of((Object)instantRange);
        }
        catch (IOException e) {
            throw new HoodieRemoteException(e);
        }
    }

    public Option<String> executeClustering() {
        try {
            this.metaClient.reloadActiveTimeline();
            String instantRange = StringUtils.join((String[])((String[])ClusteringUtils.getPendingClusteringInstantTimes((HoodieTableMetaClient)this.metaClient).stream().map(HoodieInstant::getTimestamp).toArray(String[]::new)), (String)",");
            this.executeRequest(EXECUTE_CLUSTERING, this.getDefaultParams(Action.REQUEST, instantRange));
            return Option.of((Object)instantRange);
        }
        catch (IOException e) {
            throw new HoodieRemoteException(e);
        }
    }

    private Map<String, String> getDefaultParams(Action action, String instantRange) {
        return this.getParamsWithAdditionalParams(new String[]{ACTION, DATABASE_NAME_PARAM, TABLE_NAME_PARAM, INSTANT_PARAM, USERNAME, QUEUE, RESOURCE, PARALLELISM, EXTRA_PARAMS, EXECUTION_ENGINE}, new String[]{action.name(), this.dbName, this.tableName, instantRange, this.config.getDeployUsername(), this.config.getDeployQueue(), this.config.getDeployResources(), String.valueOf(this.config.getDeployParallelism()), this.config.getDeployExtraParams(), this.config.getDeployExecutionEngine()});
    }

    public static enum Action {
        REQUEST,
        CANCEL,
        REGISTER;

    }
}

