/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.restore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRestoreException;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.hudi.table.action.restore.RestoreUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseRestoreActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseActionExecutor<T, I, K, O, HoodieRestoreMetadata> {
    private static final Logger LOG = LogManager.getLogger(BaseRestoreActionExecutor.class);
    private final String restoreInstantTime;
    private final TransactionManager txnManager;

    public BaseRestoreActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, String restoreInstantTime) {
        super(context, config, table, instantTime);
        this.restoreInstantTime = restoreInstantTime;
        this.txnManager = new TransactionManager(config, (FileSystem)table.getMetaClient().getFs());
    }

    @Override
    public HoodieRestoreMetadata execute() {
        HoodieTimer restoreTimer = new HoodieTimer();
        restoreTimer.startTimer();
        Option restoreInstant = this.table.getRestoreTimeline().filterInflightsAndRequested().filter(instant -> instant.getTimestamp().equals(this.instantTime)).firstInstant();
        if (!restoreInstant.isPresent()) {
            throw new HoodieRollbackException("No pending restore instants found to execute restore");
        }
        try {
            List<HoodieInstant> instantsToRollback = this.getInstantsToRollback((HoodieInstant)restoreInstant.get());
            ValidationUtils.checkArgument((((HoodieInstant)restoreInstant.get()).getState().equals((Object)HoodieInstant.State.REQUESTED) || ((HoodieInstant)restoreInstant.get()).getState().equals((Object)HoodieInstant.State.INFLIGHT) ? 1 : 0) != 0);
            HashMap<String, List<HoodieRollbackMetadata>> instantToMetadata = new HashMap<String, List<HoodieRollbackMetadata>>();
            if (((HoodieInstant)restoreInstant.get()).isRequested()) {
                this.table.getActiveTimeline().transitionRestoreRequestedToInflight((HoodieInstant)restoreInstant.get());
            }
            instantsToRollback.forEach(instant -> {
                instantToMetadata.put(instant.getTimestamp(), Collections.singletonList(this.rollbackInstant((HoodieInstant)instant)));
                LOG.info((Object)("Deleted instant " + instant));
            });
            return this.finishRestore(instantToMetadata, instantsToRollback, restoreTimer.endTimer());
        }
        catch (IOException io) {
            throw new HoodieRestoreException("unable to Restore instant " + restoreInstant.get(), io);
        }
    }

    private List<HoodieInstant> getInstantsToRollback(HoodieInstant restoreInstant) throws IOException {
        ArrayList<HoodieInstant> instantsToRollback = new ArrayList<HoodieInstant>();
        HoodieRestorePlan restorePlan = RestoreUtils.getRestorePlan(this.table.getMetaClient(), restoreInstant);
        for (HoodieInstantInfo instantInfo : restorePlan.getInstantsToRollback()) {
            Option rollbackInstantOpt = this.table.getActiveTimeline().getWriteTimeline().filter(instant -> instant.getTimestamp().equals(instantInfo.getCommitTime()) && instant.getAction().equals(instantInfo.getAction())).firstInstant();
            if (rollbackInstantOpt.isPresent()) {
                instantsToRollback.add((HoodieInstant)rollbackInstantOpt.get());
                continue;
            }
            LOG.warn((Object)("Ignoring already rolledback instant " + instantInfo.toString()));
        }
        return instantsToRollback;
    }

    protected abstract HoodieRollbackMetadata rollbackInstant(HoodieInstant var1);

    private HoodieRestoreMetadata finishRestore(Map<String, List<HoodieRollbackMetadata>> instantToMetadata, List<HoodieInstant> instantsRolledBack, long durationInMs) throws IOException {
        HoodieRestoreMetadata restoreMetadata = TimelineMetadataUtils.convertRestoreMetadata((String)this.instantTime, (long)durationInMs, instantsRolledBack, instantToMetadata);
        HoodieInstant restoreInflightInstant = new HoodieInstant(true, "restore", this.instantTime);
        this.writeToMetadata(restoreMetadata, restoreInflightInstant);
        this.table.getActiveTimeline().saveAsComplete(restoreInflightInstant, TimelineMetadataUtils.serializeRestoreMetadata((HoodieRestoreMetadata)restoreMetadata));
        List<HoodieInstant> instantsToRollback = this.table.getActiveTimeline().getRollbackTimeline().getReverseOrderedInstants().filter(instant -> HoodieActiveTimeline.GREATER_THAN.test(instant.getTimestamp(), this.restoreInstantTime)).collect(Collectors.toList());
        instantsToRollback.forEach(entry -> {
            if (entry.isCompleted()) {
                this.table.getActiveTimeline().deleteCompletedRollback(entry);
            }
            this.table.getActiveTimeline().deletePending(new HoodieInstant(HoodieInstant.State.INFLIGHT, "rollback", entry.getTimestamp()));
            this.table.getActiveTimeline().deletePending(new HoodieInstant(HoodieInstant.State.REQUESTED, "rollback", entry.getTimestamp()));
        });
        LOG.info((Object)("Commits " + instantsRolledBack + " rollback is complete. Restored table to " + this.restoreInstantTime));
        return restoreMetadata;
    }

    private void writeToMetadata(HoodieRestoreMetadata restoreMetadata, HoodieInstant restoreInflightInstant) {
        try {
            this.txnManager.beginTransaction((Option<HoodieInstant>)Option.of((Object)restoreInflightInstant), (Option<HoodieInstant>)Option.empty());
            this.writeTableMetadata(restoreMetadata);
        }
        finally {
            this.txnManager.endTransaction((Option<HoodieInstant>)Option.of((Object)restoreInflightInstant));
        }
    }
}

