/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;

public abstract class HoodieBaseParquetWriter<R>
extends ParquetWriter<R> {
    private static final int WRITTEN_RECORDS_THRESHOLD_FOR_FILE_SIZE_CHECK = 1000;
    private final AtomicLong writtenRecordCount = new AtomicLong(0L);
    private final long maxFileSize;
    private long lastCachedDataSize = -1L;

    public HoodieBaseParquetWriter(Path file, HoodieParquetConfig<? extends WriteSupport<R>> parquetConfig) throws IOException {
        super(HoodieWrapperFileSystem.convertToHoodiePath((Path)file, (Configuration)parquetConfig.getHadoopConf()), ParquetFileWriter.Mode.CREATE, (WriteSupport)parquetConfig.getWriteSupport(), parquetConfig.getCompressionCodecName(), parquetConfig.getBlockSize(), parquetConfig.getPageSize(), parquetConfig.getPageSize(), parquetConfig.dictionaryEnabled(), false, DEFAULT_WRITER_VERSION, FSUtils.registerFileSystem((Path)file, (Configuration)parquetConfig.getHadoopConf()));
        this.maxFileSize = parquetConfig.getMaxFileSize() + Math.round((double)parquetConfig.getMaxFileSize() * parquetConfig.getCompressionRatio());
    }

    public boolean canWrite() {
        if (this.lastCachedDataSize == -1L || this.getWrittenRecordCount() % 1000L == 0L) {
            this.lastCachedDataSize = this.getDataSize();
        }
        return this.lastCachedDataSize < this.maxFileSize;
    }

    public void write(R object) throws IOException {
        super.write(object);
        this.writtenRecordCount.incrementAndGet();
    }

    protected long getWrittenRecordCount() {
        return this.writtenRecordCount.get();
    }
}

