/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class TestHoodieReaderWriterBase {
    protected static final int NUM_RECORDS = 50;
    @TempDir
    protected File tempDir;

    protected abstract Path getFilePath();

    protected abstract HoodieFileWriter<GenericRecord> createWriter(Schema var1, boolean var2) throws Exception;

    protected abstract HoodieFileReader<GenericRecord> createReader(Configuration var1) throws Exception;

    protected abstract void verifyMetadata(Configuration var1) throws IOException;

    protected abstract void verifySchema(Configuration var1, String var2) throws IOException;

    @BeforeEach
    @AfterEach
    public void clearTempFile() {
        File file = new File(this.getFilePath().toString());
        if (file.exists()) {
            file.delete();
        }
    }

    @Test
    public void testWriteReadMetadata() throws Exception {
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
        this.writeFileWithSimpleSchema();
        Configuration conf = new Configuration();
        this.verifyMetadata(conf);
        HoodieFileReader<GenericRecord> hoodieReader = this.createReader(conf);
        BloomFilter filter = hoodieReader.readBloomFilter();
        for (int i = 0; i < 50; ++i) {
            String key = "key" + String.format("%02d", i);
            Assertions.assertTrue((boolean)filter.mightContain(key));
        }
        Assertions.assertFalse((boolean)filter.mightContain("non-existent-key"));
        Assertions.assertEquals((Object)avroSchema, (Object)hoodieReader.getSchema());
        Assertions.assertEquals((long)50L, (long)hoodieReader.getTotalRecords());
        String[] minMaxRecordKeys = hoodieReader.readMinMaxRecordKeys();
        Assertions.assertEquals((int)2, (int)minMaxRecordKeys.length);
        Assertions.assertEquals((Object)"key00", (Object)minMaxRecordKeys[0]);
        Assertions.assertEquals((Object)"key49", (Object)minMaxRecordKeys[1]);
    }

    @Test
    public void testWriteReadPrimitiveRecord() throws Exception {
        String schemaPath = "/exampleSchema.avsc";
        this.writeFileWithSimpleSchema();
        Configuration conf = new Configuration();
        this.verifyMetadata(conf);
        this.verifySchema(conf, schemaPath);
        this.verifySimpleRecords((Iterator<GenericRecord>)this.createReader(conf).getRecordIterator());
    }

    @Test
    public void testWriteReadComplexRecord() throws Exception {
        String schemaPath = "/exampleSchemaWithUDT.avsc";
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)schemaPath);
        Schema udtSchema = (Schema)avroSchema.getField("driver").schema().getTypes().get(1);
        HoodieFileWriter<GenericRecord> writer = this.createWriter(avroSchema, true);
        for (int i = 0; i < 50; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            String key = "key" + String.format("%02d", i);
            record.put("_row_key", (Object)key);
            record.put("time", (Object)Integer.toString(i));
            record.put("number", (Object)i);
            GenericData.Record innerRecord = new GenericData.Record(udtSchema);
            innerRecord.put("driver_name", (Object)("driver" + i));
            innerRecord.put("list", Collections.singletonList(i));
            innerRecord.put("map", Collections.singletonMap(key, "value" + i));
            record.put("driver", (Object)innerRecord);
            writer.writeAvro(key, (IndexedRecord)record);
        }
        writer.close();
        Configuration conf = new Configuration();
        this.verifyMetadata(conf);
        this.verifySchema(conf, schemaPath);
        this.verifyComplexRecords((Iterator<GenericRecord>)this.createReader(conf).getRecordIterator());
    }

    @Test
    public void testWriteReadWithEvolvedSchema() throws Exception {
        String[] schemaList;
        this.writeFileWithSimpleSchema();
        Configuration conf = new Configuration();
        HoodieFileReader<GenericRecord> hoodieReader = this.createReader(conf);
        for (String evolvedSchemaPath : schemaList = new String[]{"/exampleEvolvedSchema.avsc", "/exampleEvolvedSchemaChangeOrder.avsc", "/exampleEvolvedSchemaColumnRequire.avsc", "/exampleEvolvedSchemaColumnType.avsc", "/exampleEvolvedSchemaDeleteColumn.avsc"}) {
            this.verifyReaderWithSchema(evolvedSchemaPath, hoodieReader);
        }
    }

    @Test
    public void testReaderFilterRowKeys() throws Exception {
        this.writeFileWithSchemaWithMeta();
        Configuration conf = new Configuration();
        this.verifyMetadata(conf);
        this.verifyFilterRowKeys(this.createReader(conf));
    }

    protected void writeFileWithSimpleSchema() throws Exception {
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
        HoodieFileWriter<GenericRecord> writer = this.createWriter(avroSchema, true);
        for (int i = 0; i < 50; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            String key = "key" + String.format("%02d", i);
            record.put("_row_key", (Object)key);
            record.put("time", (Object)Integer.toString(i));
            record.put("number", (Object)i);
            writer.writeAvro(key, (IndexedRecord)record);
        }
        writer.close();
    }

    protected void writeFileWithSchemaWithMeta() throws Exception {
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchemaWithMetaFields.avsc");
        HoodieFileWriter<GenericRecord> writer = this.createWriter(avroSchema, true);
        for (int i = 0; i < 50; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            String key = "key" + String.format("%02d", i);
            record.put("_row_key", (Object)key);
            record.put("time", (Object)Integer.toString(i));
            record.put("number", (Object)i);
            writer.writeAvroWithMetadata(new HoodieKey((String)record.get("_row_key"), Integer.toString((Integer)record.get("number"))), (IndexedRecord)record);
        }
        writer.close();
    }

    protected void verifySimpleRecords(Iterator<GenericRecord> iterator) {
        int index = 0;
        while (iterator.hasNext()) {
            GenericRecord record = iterator.next();
            String key = "key" + String.format("%02d", index);
            Assertions.assertEquals((Object)key, (Object)record.get("_row_key").toString());
            Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("time").toString());
            Assertions.assertEquals((Object)index, (Object)record.get("number"));
            ++index;
        }
    }

    protected void verifyComplexRecords(Iterator<GenericRecord> iterator) {
        int index = 0;
        while (iterator.hasNext()) {
            GenericRecord record = iterator.next();
            String key = "key" + String.format("%02d", index);
            Assertions.assertEquals((Object)key, (Object)record.get("_row_key").toString());
            Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("time").toString());
            Assertions.assertEquals((Object)index, (Object)record.get("number"));
            GenericRecord innerRecord = (GenericRecord)record.get("driver");
            Assertions.assertEquals((Object)("driver" + index), (Object)innerRecord.get("driver_name").toString());
            Assertions.assertEquals((int)1, (int)((List)innerRecord.get("list")).size());
            Assertions.assertEquals((Object)index, ((List)innerRecord.get("list")).get(0));
            Map mapping = (Map)innerRecord.get("map");
            boolean match = false;
            for (Object innerKey : mapping.keySet()) {
                if (!innerKey.toString().equals(key)) continue;
                Assertions.assertEquals((Object)("value" + index), (Object)mapping.get(innerKey).toString());
                match = true;
            }
            Assertions.assertTrue((boolean)match);
            ++index;
        }
    }

    private void verifyFilterRowKeys(HoodieFileReader<GenericRecord> hoodieReader) {
        Set candidateRowKeys = IntStream.range(40, 100).mapToObj(i -> "key" + String.format("%02d", i)).collect(Collectors.toCollection(TreeSet::new));
        List expectedKeys = IntStream.range(40, 50).mapToObj(i -> "key" + String.format("%02d", i)).sorted().collect(Collectors.toList());
        Assertions.assertEquals(expectedKeys, hoodieReader.filterRowKeys(candidateRowKeys).stream().sorted().collect(Collectors.toList()));
    }

    private void verifyReaderWithSchema(String schemaPath, HoodieFileReader<GenericRecord> hoodieReader) throws IOException {
        Schema evolvedSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)schemaPath);
        ClosableIterator iter = hoodieReader.getRecordIterator(evolvedSchema);
        int index = 0;
        while (iter.hasNext()) {
            this.verifyRecord(schemaPath, (GenericRecord)iter.next(), index);
            ++index;
        }
    }

    private void verifyRecord(String schemaPath, GenericRecord record, int index) {
        String numStr = String.format("%02d", index);
        Assertions.assertEquals((Object)("key" + numStr), (Object)record.get("_row_key").toString());
        Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("time").toString());
        if ("/exampleEvolvedSchemaColumnType.avsc".equals(schemaPath)) {
            Assertions.assertEquals((Object)Integer.toString(index), (Object)record.get("number").toString());
        } else if ("/exampleEvolvedSchemaDeleteColumn.avsc".equals(schemaPath)) {
            Assertions.assertNull((Object)record.get("number"));
        } else {
            Assertions.assertEquals((Object)index, (Object)record.get("number"));
        }
        Assertions.assertNull((Object)record.get("added_field"));
    }
}

