/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieConsistentHashingMetadata;
import org.apache.hudi.index.bucket.ConsistentBucketIdentifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConsistentBucketIdIdentifier {
    @Test
    public void testGetBucket() {
        List<ConsistentHashingNode> nodes = Arrays.asList(new ConsistentHashingNode(100, "0"), new ConsistentHashingNode(0x2FFFFFFF, "1"), new ConsistentHashingNode(0x4FFFFFFF, "2"));
        HoodieConsistentHashingMetadata meta = new HoodieConsistentHashingMetadata(0, "", "", 3, 0, nodes);
        ConsistentBucketIdentifier identifier = new ConsistentBucketIdentifier(meta);
        Assertions.assertEquals((int)3, (int)identifier.getNumBuckets());
        Assertions.assertEquals((Object)nodes.get(2), (Object)identifier.getBucket(Arrays.asList("Hudi")));
        Assertions.assertEquals((Object)nodes.get(1), (Object)identifier.getBucket(Arrays.asList("bucket_index")));
        Assertions.assertEquals((Object)nodes.get(1), (Object)identifier.getBucket(Arrays.asList("consistent_hashing")));
        Assertions.assertEquals((Object)nodes.get(1), (Object)identifier.getBucket(Arrays.asList("bucket_index", "consistent_hashing")));
        int[] ref1 = new int[]{2, 2, 1, 1, 0, 1, 1, 1, 0, 1};
        int[] ref2 = new int[]{1, 0, 1, 0, 1, 1, 1, 0, 1, 2};
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((Object)nodes.get(ref1[i]), (Object)identifier.getBucket(Arrays.asList(Integer.toString(i))));
            Assertions.assertEquals((Object)nodes.get(ref2[i]), (Object)identifier.getBucket(Arrays.asList(Integer.toString(i), Integer.toString(i + 1))));
        }
        Assertions.assertEquals((Object)nodes.get(0), (Object)identifier.getBucket(0));
        Assertions.assertEquals((Object)nodes.get(0), (Object)identifier.getBucket(50));
        Assertions.assertEquals((Object)nodes.get(0), (Object)identifier.getBucket(100));
        Assertions.assertEquals((Object)nodes.get(1), (Object)identifier.getBucket(101));
        Assertions.assertEquals((Object)nodes.get(1), (Object)identifier.getBucket(0x1FFFFFFF));
        Assertions.assertEquals((Object)nodes.get(1), (Object)identifier.getBucket(0x2FFFFFFF));
        Assertions.assertEquals((Object)nodes.get(2), (Object)identifier.getBucket(0x40000000));
        Assertions.assertEquals((Object)nodes.get(2), (Object)identifier.getBucket(0x40000001));
        Assertions.assertEquals((Object)nodes.get(2), (Object)identifier.getBucket(0x4FFFFFFF));
        Assertions.assertEquals((Object)nodes.get(0), (Object)identifier.getBucket(0x50000000));
        Assertions.assertEquals((Object)nodes.get(0), (Object)identifier.getBucket(Integer.MAX_VALUE));
        Assertions.assertEquals((Object)nodes.get(0), (Object)identifier.getBucketByFileId(FSUtils.createNewFileId((String)"0", (int)0)));
        Assertions.assertEquals((Object)nodes.get(1), (Object)identifier.getBucketByFileId(FSUtils.createNewFileId((String)"1", (int)0)));
        Assertions.assertEquals((Object)nodes.get(2), (Object)identifier.getBucketByFileId(FSUtils.createNewFileId((String)"2", (int)0)));
    }
}

