/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.apache.hudi.client.transaction.FileSystemBasedLockProviderTestClass;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.client.transaction.lock.ZookeeperBasedLockProvider;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLayoutConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieWriteConfig {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPropertyLoading(boolean withAlternative) throws IOException {
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withPath("/tmp");
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put(HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key(), "1");
        params.put(HoodieArchivalConfig.MAX_COMMITS_TO_KEEP.key(), "5");
        params.put(HoodieArchivalConfig.MIN_COMMITS_TO_KEEP.key(), "2");
        if (withAlternative) {
            params.put("hoodie.avro.schema.externalTransformation", "true");
        } else {
            params.put("hoodie.avro.schema.external.transformation", "true");
        }
        ByteArrayOutputStream outStream = this.saveParamsIntoOutputStream(params);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outStream.toByteArray());
        try {
            builder = builder.fromInputStream((InputStream)inputStream);
        }
        finally {
            outStream.close();
            inputStream.close();
        }
        HoodieWriteConfig config = builder.build();
        Assertions.assertEquals((int)5, (int)config.getMaxCommitsToKeep());
        Assertions.assertEquals((int)2, (int)config.getMinCommitsToKeep());
        Assertions.assertTrue((boolean)config.shouldUseExternalSchemaTransformation());
    }

    @Test
    public void testDefaultIndexAccordingToEngineType() {
        this.testEngineSpecificConfig(HoodieWriteConfig::getIndexType, this.constructConfigMap(EngineType.SPARK, HoodieIndex.IndexType.SIMPLE, EngineType.FLINK, HoodieIndex.IndexType.INMEMORY, EngineType.JAVA, HoodieIndex.IndexType.INMEMORY));
    }

    @Test
    public void testDefaultClusteringPlanStrategyClassAccordingToEngineType() {
        this.testEngineSpecificConfig(HoodieWriteConfig::getClusteringPlanStrategyClass, this.constructConfigMap(EngineType.SPARK, "org.apache.hudi.client.clustering.plan.strategy.SparkSizeBasedClusteringPlanStrategy", EngineType.FLINK, "org.apache.hudi.client.clustering.plan.strategy.JavaSizeBasedClusteringPlanStrategy", EngineType.JAVA, "org.apache.hudi.client.clustering.plan.strategy.JavaSizeBasedClusteringPlanStrategy"));
    }

    @Test
    public void testDefaultClusteringExecutionStrategyClassAccordingToEngineType() {
        this.testEngineSpecificConfig(HoodieWriteConfig::getClusteringExecutionStrategyClass, this.constructConfigMap(EngineType.SPARK, "org.apache.hudi.client.clustering.run.strategy.SparkSortAndSizeExecutionStrategy", EngineType.FLINK, "org.apache.hudi.client.clustering.run.strategy.JavaSortAndSizeExecutionStrategy", EngineType.JAVA, "org.apache.hudi.client.clustering.run.strategy.JavaSortAndSizeExecutionStrategy"));
    }

    @Test
    public void testDefaultMarkersTypeAccordingToEngineType() {
        this.testEngineSpecificConfig(HoodieWriteConfig::getMarkersType, this.constructConfigMap(EngineType.SPARK, MarkerType.TIMELINE_SERVER_BASED, EngineType.FLINK, MarkerType.DIRECT, EngineType.JAVA, MarkerType.DIRECT));
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testAutoConcurrencyConfigAdjustmentWithTableServices(final HoodieTableType tableType) {
        String inProcessLockProviderClassName = InProcessLockProvider.class.getCanonicalName();
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "true");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "false");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, true, true, WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL, HoodieFailedWritesCleaningPolicy.LAZY, inProcessLockProviderClassName);
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "false");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "true");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, true, true, WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL, HoodieFailedWritesCleaningPolicy.LAZY, inProcessLockProviderClassName);
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "false");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "false");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "false");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, tableType == HoodieTableType.MERGE_ON_READ, true, tableType == HoodieTableType.MERGE_ON_READ ? WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL : WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), tableType == HoodieTableType.MERGE_ON_READ ? HoodieFailedWritesCleaningPolicy.LAZY : HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), tableType == HoodieTableType.MERGE_ON_READ ? inProcessLockProviderClassName : (String)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.defaultValue());
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "false");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "false");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, false, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), (String)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.defaultValue());
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "true");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "false");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "true");
                this.put(HoodieArchivalConfig.ASYNC_ARCHIVE.key(), "true");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, true, false, WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL, HoodieFailedWritesCleaningPolicy.LAZY, inProcessLockProviderClassName);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testAutoAdjustLockConfigs(HoodieTableType tableType) {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(HoodieTableConfig.TYPE.key(), tableType.name());
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withAutoAdjustLockConfigs(false).withClusteringConfig(new HoodieClusteringConfig.Builder().withAsyncClustering(Boolean.valueOf(true)).build()).withProperties((Properties)properties).build();
        this.verifyConcurrencyControlRelatedConfigs(writeConfig, true, true, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), (String)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.defaultValue());
        writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withAutoAdjustLockConfigs(false).withWriteConcurrencyMode(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL).withClusteringConfig(new HoodieClusteringConfig.Builder().withAsyncClustering(Boolean.valueOf(true)).build()).withProperties((Properties)properties).build();
        this.verifyConcurrencyControlRelatedConfigs(writeConfig, true, true, true, WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL, HoodieFailedWritesCleaningPolicy.LAZY, (String)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.defaultValue());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testAutoConcurrencyConfigAdjustmentWithUserConfigs(final HoodieTableType tableType) {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(HoodieTableConfig.TYPE.key(), tableType.name());
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(FileSystemBasedLockProviderTestClass.class).build()).withAutoAdjustLockConfigs(true).withProperties((Properties)properties).build();
        this.verifyConcurrencyControlRelatedConfigs(writeConfig, true, tableType == HoodieTableType.MERGE_ON_READ, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), FileSystemBasedLockProviderTestClass.class.getName());
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "false");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "true");
                this.put(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), ZookeeperBasedLockProvider.class.getName());
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, true, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), ZookeeperBasedLockProvider.class.getName());
        writeConfig = this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        });
        if (writeConfig.areAnyTableServicesAsync().booleanValue()) {
            this.verifyConcurrencyControlRelatedConfigs(writeConfig, true, true, true, WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL, HoodieFailedWritesCleaningPolicy.LAZY, InProcessLockProvider.class.getName());
        } else {
            this.verifyConcurrencyControlRelatedConfigs(writeConfig, true, false, true, WriteConcurrencyMode.valueOf((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), (String)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.defaultValue());
        }
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testAutoConcurrencyConfigAdjustmentWithNoTableService(final HoodieTableType tableType) {
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieWriteConfig.TABLE_SERVICES_ENABLED.key(), "false");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), false, false, false, WriteConcurrencyMode.fromValue((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), (String)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.defaultValue());
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieWriteConfig.TABLE_SERVICES_ENABLED.key(), "false");
                this.put(HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key(), WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.value());
                this.put(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), FileSystemBasedLockProviderTestClass.class.getName());
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), false, false, false, WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL, HoodieFailedWritesCleaningPolicy.LAZY, FileSystemBasedLockProviderTestClass.class.getName());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testAutoConcurrencyConfigAdjustmentWithMetadataTableDisabled(final HoodieTableType tableType) {
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieTableConfig.TYPE.key(), tableType.name());
                this.put(HoodieMetadataConfig.ENABLE.key(), "false");
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "true");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "false");
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, true, true, WriteConcurrencyMode.fromValue((String)((String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())), HoodieFailedWritesCleaningPolicy.valueOf((String)((String)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.defaultValue())), (String)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.defaultValue());
        this.verifyConcurrencyControlRelatedConfigs(this.createWriteConfig((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE.key(), "true");
                this.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                this.put(HoodieCleanConfig.AUTO_CLEAN.key(), "true");
                this.put(HoodieCleanConfig.ASYNC_CLEAN.key(), "false");
                this.put(HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key(), WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.value());
                this.put(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), FileSystemBasedLockProviderTestClass.class.getName());
                this.put(HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), "true");
            }
        }), true, true, true, WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL, HoodieFailedWritesCleaningPolicy.LAZY, FileSystemBasedLockProviderTestClass.class.getName());
    }

    @Test
    public void testSimpleBucketIndexPartitionerConfig() {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.SIMPLE).build()).build();
        Assertions.assertEquals((Object)"org.apache.hudi.table.action.commit.SparkBucketIndexPartitioner", (Object)writeConfig.getString(HoodieLayoutConfig.LAYOUT_PARTITIONER_CLASS_NAME));
        HoodieWriteConfig overwritePartitioner = HoodieWriteConfig.newBuilder().withPath("/tmp").withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.SIMPLE).build()).withLayoutConfig(HoodieLayoutConfig.newBuilder().withLayoutPartitioner("org.apache.hudi.table.action.commit.UpsertPartitioner").build()).build();
        Assertions.assertEquals((Object)"org.apache.hudi.table.action.commit.UpsertPartitioner", (Object)overwritePartitioner.getString(HoodieLayoutConfig.LAYOUT_PARTITIONER_CLASS_NAME));
    }

    private HoodieWriteConfig createWriteConfig(Map<String, String> configs) {
        Properties properties = new Properties();
        configs.forEach(properties::setProperty);
        return HoodieWriteConfig.newBuilder().withPath("/tmp").withProperties(properties).build();
    }

    private ByteArrayOutputStream saveParamsIntoOutputStream(Map<String, String> params) throws IOException {
        Properties properties = new Properties();
        properties.putAll(params);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        properties.store(outStream, "Saved on " + new Date(System.currentTimeMillis()));
        return outStream;
    }

    private void testEngineSpecificConfig(Function<HoodieWriteConfig, Object> getConfigFunc, Map<EngineType, Object> expectedConfigMap) {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").build();
        Assertions.assertEquals((Object)expectedConfigMap.get(EngineType.SPARK), (Object)getConfigFunc.apply(writeConfig));
        for (EngineType engineType : expectedConfigMap.keySet()) {
            writeConfig = HoodieWriteConfig.newBuilder().withEngineType(engineType).withPath("/tmp").build();
            Assertions.assertEquals((Object)expectedConfigMap.get(engineType), (Object)getConfigFunc.apply(writeConfig));
        }
    }

    private Map<EngineType, Object> constructConfigMap(EngineType k1, Object v1, EngineType k2, Object v2, EngineType k3, Object v3) {
        HashMap<EngineType, Object> mapping = new HashMap<EngineType, Object>();
        mapping.put(k1, v1);
        mapping.put(k2, v2);
        mapping.put(k3, v3);
        return mapping;
    }

    private void verifyConcurrencyControlRelatedConfigs(HoodieWriteConfig writeConfig, boolean expectedTableServicesEnabled, boolean expectedAnyTableServicesAsync, boolean expectedAnyTableServicesExecutedInline, WriteConcurrencyMode expectedConcurrencyMode, HoodieFailedWritesCleaningPolicy expectedCleanPolicy, String expectedLockProviderName) {
        Assertions.assertEquals((Object)expectedTableServicesEnabled, (Object)writeConfig.areTableServicesEnabled());
        Assertions.assertEquals((Object)expectedAnyTableServicesAsync, (Object)writeConfig.areAnyTableServicesAsync());
        Assertions.assertEquals((Object)expectedAnyTableServicesExecutedInline, (Object)writeConfig.areAnyTableServicesExecutedInline());
        Assertions.assertEquals((Object)expectedConcurrencyMode, (Object)writeConfig.getWriteConcurrencyMode());
        Assertions.assertEquals((Object)expectedCleanPolicy, (Object)writeConfig.getFailedWritesCleanPolicy());
        Assertions.assertEquals((Object)expectedLockProviderName, (Object)writeConfig.getLockProviderClass());
    }
}

