/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.hudi.client.utils.FileSliceMetricUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFileSliceMetricUtils {
    @Test
    public void testFileSliceMetricUtilsWithoutFile() {
        HashMap metrics = new HashMap();
        ArrayList fileSlices = new ArrayList();
        long defaultBaseFileSize = 0xA00000L;
        double epsilon = 1.0E-5;
        FileSliceMetricUtils.addFileSliceCommonMetrics(fileSlices, metrics, (long)0xA00000L);
        Assertions.assertEquals((double)0.0, (double)((Double)metrics.get("TOTAL_IO_READ_MB")), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)((Double)metrics.get("TOTAL_IO_WRITE_MB")), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)((Double)metrics.get("TOTAL_IO_MB")), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)((Double)metrics.get("TOTAL_LOG_FILES_SIZE")), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)((Double)metrics.get("TOTAL_LOG_FILES")), (double)1.0E-5);
    }

    @Test
    public void testFileSliceMetricUtilsWithoutLogFile() {
        HashMap metrics = new HashMap();
        ArrayList<FileSlice> fileSlices = new ArrayList<FileSlice>();
        long defaultBaseFileSize = 0xA00000L;
        double epsilon = 1.0E-5;
        fileSlices.add(this.buildFileSlice(0xF00000L, new ArrayList<Long>()));
        fileSlices.add(this.buildFileSlice(0x1400000L, new ArrayList<Long>()));
        fileSlices.add(this.buildFileSlice(0L, new ArrayList<Long>()));
        FileSliceMetricUtils.addFileSliceCommonMetrics(fileSlices, metrics, (long)0xA00000L);
        Assertions.assertEquals((double)35.0, (double)((Double)metrics.get("TOTAL_IO_READ_MB")), (double)1.0E-5);
        Assertions.assertEquals((double)45.0, (double)((Double)metrics.get("TOTAL_IO_WRITE_MB")), (double)1.0E-5);
        Assertions.assertEquals((double)80.0, (double)((Double)metrics.get("TOTAL_IO_MB")), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)((Double)metrics.get("TOTAL_LOG_FILES_SIZE")), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)((Double)metrics.get("TOTAL_LOG_FILES")), (double)1.0E-5);
    }

    @Test
    public void testFileSliceMetricUtilsWithLogFile() {
        HashMap metrics = new HashMap();
        ArrayList<FileSlice> fileSlices = new ArrayList<FileSlice>();
        long defaultBaseFileSize = 0xA00000L;
        double epsilon = 1.0E-5;
        fileSlices.add(this.buildFileSlice(0xF00000L, new ArrayList<Long>(Arrays.asList(0x500000L, 0x300000L))));
        fileSlices.add(this.buildFileSlice(0x1400000L, new ArrayList<Long>(Collections.singletonList(0x200000L))));
        FileSliceMetricUtils.addFileSliceCommonMetrics(fileSlices, metrics, (long)0xA00000L);
        Assertions.assertEquals((double)45.0, (double)((Double)metrics.get("TOTAL_IO_READ_MB")), (double)1.0E-5);
        Assertions.assertEquals((double)35.0, (double)((Double)metrics.get("TOTAL_IO_WRITE_MB")), (double)1.0E-5);
        Assertions.assertEquals((double)80.0, (double)((Double)metrics.get("TOTAL_IO_MB")), (double)1.0E-5);
        Assertions.assertEquals((double)1.048576E7, (double)((Double)metrics.get("TOTAL_LOG_FILES_SIZE")), (double)1.0E-5);
        Assertions.assertEquals((double)3.0, (double)((Double)metrics.get("TOTAL_LOG_FILES")), (double)1.0E-5);
    }

    private FileSlice buildFileSlice(long baseFileLen, List<Long> logFileLens) {
        String baseFilePath = ".b5068208-e1a4-11e6-bf01-fe55135034f3_20170101134598.log.1";
        FileSlice slice = new FileSlice("partition_0", HoodieActiveTimeline.createNewInstantTime(), UUID.randomUUID().toString());
        HoodieBaseFile baseFile = new HoodieBaseFile(".b5068208-e1a4-11e6-bf01-fe55135034f3_20170101134598.log.1");
        baseFile.setFileLen(baseFileLen);
        slice.setBaseFile(baseFile);
        int logVersion = 1;
        for (long logFileLen : logFileLens) {
            String logFilePath = "." + UUID.randomUUID().toString() + "_20170101134598.log." + logVersion;
            HoodieLogFile logFile = new HoodieLogFile(logFilePath);
            logFile.setFileLen(logFileLen);
            slice.addLogFile(logFile);
            ++logVersion;
        }
        return slice;
    }
}

