/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryOneTime;
import org.apache.curator.test.TestingServer;
import org.apache.hudi.client.transaction.lock.ZookeeperBasedLockProvider;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestZookeeperBasedLockProvider {
    private static final Logger LOG = LogManager.getLogger(TestZookeeperBasedLockProvider.class);
    private static TestingServer server;
    private static CuratorFramework client;
    private static String basePath;
    private static String key;
    private static LockConfiguration lockConfiguration;

    @BeforeAll
    public static void setup() {
        while (server == null) {
            try {
                server = new TestingServer();
                CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
                client = builder.connectString(server.getConnectString()).retryPolicy((RetryPolicy)new RetryOneTime(1000)).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Getting bind exception - retrying to allocate server");
                server = null;
            }
        }
        Properties properties = new Properties();
        properties.setProperty("hoodie.write.lock.zookeeper.base_path", basePath);
        properties.setProperty("hoodie.write.lock.zookeeper.lock_key", key);
        properties.setProperty("hoodie.write.lock.zookeeper.url", server.getConnectString());
        properties.setProperty("hoodie.write.lock.zookeeper.base_path", server.getTempDirectory().getAbsolutePath());
        properties.setProperty("hoodie.write.lock.zookeeper.session_timeout_ms", "10000");
        properties.setProperty("hoodie.write.lock.zookeeper.connection_timeout_ms", "10000");
        properties.setProperty("hoodie.write.lock.zookeeper.lock_key", "key");
        properties.setProperty("hoodie.write.lock.wait_time_ms", "1000");
        lockConfiguration = new LockConfiguration(properties);
    }

    @Test
    public void testAcquireLock() {
        ZookeeperBasedLockProvider zookeeperBasedLockProvider = new ZookeeperBasedLockProvider(lockConfiguration, client);
        Assertions.assertTrue((boolean)zookeeperBasedLockProvider.tryLock(lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS));
        zookeeperBasedLockProvider.unlock();
    }

    @Test
    public void testUnLock() {
        ZookeeperBasedLockProvider zookeeperBasedLockProvider = new ZookeeperBasedLockProvider(lockConfiguration, client);
        Assertions.assertTrue((boolean)zookeeperBasedLockProvider.tryLock(lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS));
        zookeeperBasedLockProvider.unlock();
        zookeeperBasedLockProvider.tryLock(lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS);
    }

    @Test
    public void testReentrantLock() {
        ZookeeperBasedLockProvider zookeeperBasedLockProvider = new ZookeeperBasedLockProvider(lockConfiguration, client);
        Assertions.assertTrue((boolean)zookeeperBasedLockProvider.tryLock(lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS));
        try {
            zookeeperBasedLockProvider.tryLock(lockConfiguration.getConfig().getLong("hoodie.write.lock.wait_time_ms"), TimeUnit.MILLISECONDS);
            Assertions.fail();
        }
        catch (HoodieLockException hoodieLockException) {
            // empty catch block
        }
        zookeeperBasedLockProvider.unlock();
    }

    @Test
    public void testUnlockWithoutLock() {
        ZookeeperBasedLockProvider zookeeperBasedLockProvider = new ZookeeperBasedLockProvider(lockConfiguration, client);
        zookeeperBasedLockProvider.unlock();
    }

    static {
        basePath = "/hudi/test/lock";
        key = "table1";
    }
}

