/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.cloudwatch;

import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.aws.cloudwatch.CloudWatchReporter;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.cloudwatch.CloudWatchMetricsReporter;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class TestCloudWatchMetricsReporter {
    @Mock
    private HoodieWriteConfig config;
    @Mock
    private MetricRegistry registry;
    @Mock
    private CloudWatchReporter reporter;

    @Test
    public void testReporter() {
        Mockito.when((Object)this.config.getCloudWatchReportPeriodSeconds()).thenReturn((Object)30);
        CloudWatchMetricsReporter metricsReporter = new CloudWatchMetricsReporter(this.config, this.registry, this.reporter);
        metricsReporter.start();
        ((CloudWatchReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).start(30L, TimeUnit.SECONDS);
        metricsReporter.report();
        ((CloudWatchReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).report();
        metricsReporter.stop();
        ((CloudWatchReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).stop();
    }
}

