/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.Properties;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metrics.InMemoryMetricsReporter;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.MetricsReporterFactory;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.metrics.custom.CustomizableMetricsReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestMetricsReporterFactory {
    @Mock
    HoodieWriteConfig config;
    @Mock
    MetricRegistry registry;

    @Test
    public void metricsReporterFactoryShouldReturnReporter() {
        Mockito.when((Object)this.config.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.INMEMORY);
        MetricsReporter reporter = MetricsReporterFactory.createReporter((HoodieWriteConfig)this.config, (MetricRegistry)this.registry);
        Assertions.assertTrue((boolean)(reporter instanceof InMemoryMetricsReporter));
    }

    @Test
    public void metricsReporterFactoryShouldReturnUserDefinedReporter() {
        Mockito.when((Object)this.config.getMetricReporterClassName()).thenReturn((Object)DummyMetricsReporter.class.getName());
        TypedProperties props = new TypedProperties();
        props.setProperty("testKey", "testValue");
        Mockito.when((Object)this.config.getProps()).thenReturn((Object)props);
        MetricsReporter reporter = MetricsReporterFactory.createReporter((HoodieWriteConfig)this.config, (MetricRegistry)this.registry);
        Assertions.assertTrue((boolean)(reporter instanceof CustomizableMetricsReporter));
        Assertions.assertEquals((Object)props, (Object)((DummyMetricsReporter)reporter).getProps());
        Assertions.assertEquals((Object)this.registry, (Object)((DummyMetricsReporter)reporter).getRegistry());
    }

    @Test
    public void metricsReporterFactoryShouldThrowExceptionWhenMetricsReporterClassIsIllegal() {
        Mockito.when((Object)this.config.getMetricReporterClassName()).thenReturn((Object)IllegalTestMetricsReporter.class.getName());
        Mockito.when((Object)this.config.getProps()).thenReturn((Object)new TypedProperties());
        Assertions.assertThrows(HoodieException.class, () -> MetricsReporterFactory.createReporter((HoodieWriteConfig)this.config, (MetricRegistry)this.registry));
    }

    public static class IllegalTestMetricsReporter {
        public IllegalTestMetricsReporter(Properties props, MetricRegistry registry) {
        }
    }

    public static class DummyMetricsReporter
    extends CustomizableMetricsReporter {
        public DummyMetricsReporter(Properties props, MetricRegistry registry) {
            super(props, registry);
        }

        public void start() {
        }

        public void report() {
        }

        public void stop() {
        }
    }
}

