/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.Gauge;
import org.apache.hudi.common.testutils.NetworkTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestHoodieGraphiteMetrics {
    @Mock
    HoodieWriteConfig config;

    @AfterEach
    void shutdownMetrics() {
        Metrics.shutdown();
    }

    @Test
    public void testRegisterGauge() {
        Mockito.when((Object)this.config.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getTableName()).thenReturn((Object)"table1");
        Mockito.when((Object)this.config.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.GRAPHITE);
        Mockito.when((Object)this.config.getGraphiteServerHost()).thenReturn((Object)"localhost");
        Mockito.when((Object)this.config.getGraphiteServerPort()).thenReturn((Object)NetworkTestUtils.nextFreePort());
        Mockito.when((Object)this.config.getGraphiteReportPeriodSeconds()).thenReturn((Object)30);
        new HoodieMetrics(this.config);
        Metrics.registerGauge((String)"graphite_metric", (long)123L);
        Assertions.assertEquals((Object)"123", (Object)((Gauge)Metrics.getInstance().getRegistry().getGauges().get("graphite_metric")).getValue().toString());
    }
}

