/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.common.bootstrap.index.HFileBootstrapIndex;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.testutils.FileSystemTestUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.io.storage.HoodieHFileConfig;
import org.apache.hudi.io.storage.HoodieHFileReader;
import org.apache.hudi.io.storage.HoodieHFileUtils;
import org.apache.hudi.io.storage.TestHoodieOrcReaderWriter;
import org.apache.hudi.io.storage.TestHoodieReaderWriterBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

public class TestHoodieHFileReaderWriter
extends TestHoodieReaderWriterBase {
    private static final String DUMMY_BASE_PATH = "dummy_base_path";
    private static final int NUM_RECORDS_FIXTURE = 50;
    private static final String SIMPLE_SCHEMA_HFILE_SUFFIX = "_simple.hfile";
    private static final String COMPLEX_SCHEMA_HFILE_SUFFIX = "_complex.hfile";
    private static final String BOOTSTRAP_INDEX_HFILE_SUFFIX = "_bootstrap_index_partitions.hfile";

    @Override
    protected Path getFilePath() {
        return new Path(this.tempDir.toString() + "/f1_1-0-1_000.hfile");
    }

    @Override
    protected HoodieFileWriter<GenericRecord> createWriter(Schema avroSchema, boolean populateMetaFields) throws Exception {
        String instantTime = "000";
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(DUMMY_BASE_PATH).withIndexConfig(HoodieIndexConfig.newBuilder().bloomFilterNumEntries(1000).bloomFilterFPP(1.0E-5).build()).withPopulateMetaFields(populateMetaFields).build();
        Configuration conf = new Configuration();
        TaskContextSupplier mockTaskContextSupplier = (TaskContextSupplier)Mockito.mock(TaskContextSupplier.class);
        Supplier partitionSupplier = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)mockTaskContextSupplier.getPartitionIdSupplier()).thenReturn((Object)partitionSupplier);
        Mockito.when(partitionSupplier.get()).thenReturn((Object)10);
        return HoodieFileWriterFactory.newHFileFileWriter((String)instantTime, (Path)this.getFilePath(), (HoodieWriteConfig)writeConfig, (Schema)avroSchema, (Configuration)conf, (TaskContextSupplier)mockTaskContextSupplier);
    }

    @Override
    protected HoodieFileReader<GenericRecord> createReader(Configuration conf) throws Exception {
        CacheConfig cacheConfig = new CacheConfig(conf);
        return new HoodieHFileReader(conf, this.getFilePath(), cacheConfig, this.getFilePath().getFileSystem(conf));
    }

    @Override
    protected void verifyMetadata(Configuration conf) throws IOException {
        FileSystem fs = this.getFilePath().getFileSystem(conf);
        HFile.Reader hfileReader = HoodieHFileUtils.createHFileReader((FileSystem)fs, (Path)this.getFilePath(), (CacheConfig)new CacheConfig(conf), (Configuration)conf);
        Assertions.assertEquals(HoodieHFileConfig.HFILE_COMPARATOR.getClass(), hfileReader.getComparator().getClass());
        Assertions.assertEquals((long)50L, (long)hfileReader.getEntries());
    }

    @Override
    protected void verifySchema(Configuration conf, String schemaPath) throws IOException {
        FileSystem fs = this.getFilePath().getFileSystem(conf);
        HFile.Reader hfileReader = HoodieHFileUtils.createHFileReader((FileSystem)fs, (Path)this.getFilePath(), (CacheConfig)new CacheConfig(conf), (Configuration)conf);
        Assertions.assertEquals((Object)SchemaTestUtil.getSchemaFromResource(TestHoodieHFileReaderWriter.class, (String)schemaPath), (Object)new Schema.Parser().parse(new String(hfileReader.getHFileInfo().get((Object)"schema".getBytes()))));
    }

    private static Stream<Arguments> populateMetaFieldsAndTestAvroWithMeta() {
        return Arrays.stream(new Boolean[][]{{true, true}, {false, true}, {true, false}, {false, false}}).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"populateMetaFieldsAndTestAvroWithMeta"})
    public void testWriteReadHFileWithMetaFields(boolean populateMetaFields, boolean testAvroWithMeta) throws Exception {
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieOrcReaderWriter.class, (String)"/exampleSchemaWithMetaFields.avsc");
        HoodieFileWriter<GenericRecord> writer = this.createWriter(avroSchema, populateMetaFields);
        ArrayList<String> keys = new ArrayList<String>();
        TreeMap<String, GenericData.Record> recordMap = new TreeMap<String, GenericData.Record>();
        for (int i = 0; i < 100; ++i) {
            GenericData.Record record = new GenericData.Record(avroSchema);
            String key = String.format("%s%04d", "key", i);
            record.put("_row_key", (Object)key);
            keys.add(key);
            record.put("time", (Object)Integer.toString(FileSystemTestUtils.RANDOM.nextInt()));
            record.put("number", (Object)i);
            if (testAvroWithMeta) {
                writer.writeAvroWithMetadata(new HoodieAvroRecord(new HoodieKey((String)record.get("_row_key"), Integer.toString((Integer)record.get("number"))), (HoodieRecordPayload)new EmptyHoodieRecordPayload()).getKey(), (IndexedRecord)record);
            } else {
                writer.writeAvro(key, (IndexedRecord)record);
            }
            recordMap.put(key, record);
        }
        writer.close();
        Configuration conf = new Configuration();
        HoodieHFileReader hoodieHFileReader = (HoodieHFileReader)this.createReader(conf);
        List records = HoodieHFileReader.readAllRecords((HoodieHFileReader)hoodieHFileReader);
        Assertions.assertEquals(new ArrayList(recordMap.values()), (Object)records);
        hoodieHFileReader.close();
        for (int i = 0; i < 2; ++i) {
            int randomRowstoFetch = 5 + FileSystemTestUtils.RANDOM.nextInt(10);
            Set<String> rowsToFetch = this.getRandomKeys(randomRowstoFetch, keys);
            ArrayList<String> rowsList = new ArrayList<String>(rowsToFetch);
            Collections.sort(rowsList);
            List expectedRecords = rowsList.stream().map(recordMap::get).collect(Collectors.toList());
            hoodieHFileReader = (HoodieHFileReader)this.createReader(conf);
            List result = HoodieHFileReader.readRecords((HoodieHFileReader)hoodieHFileReader, rowsList);
            Assertions.assertEquals(expectedRecords, (Object)result);
            result.forEach(entry -> {
                if (populateMetaFields && testAvroWithMeta) {
                    Assertions.assertNotNull((Object)entry.get("_hoodie_record_key"));
                } else {
                    Assertions.assertNull((Object)entry.get("_hoodie_record_key"));
                }
            });
            hoodieHFileReader.close();
        }
    }

    @Override
    @Test
    public void testWriteReadWithEvolvedSchema() throws Exception {
    }

    @Test
    public void testReadHFileFormatRecords() throws Exception {
        this.writeFileWithSimpleSchema();
        FileSystem fs = FSUtils.getFs((String)this.getFilePath().toString(), (Configuration)new Configuration());
        byte[] content = FileIOUtils.readAsByteArray((InputStream)fs.open(this.getFilePath()), (int)((int)fs.getFileStatus(this.getFilePath()).getLen()));
        HoodieHFileReader hfileReader = new HoodieHFileReader(fs, new Path(DUMMY_BASE_PATH), content, Option.empty());
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
        Assertions.assertEquals((long)50L, (long)hfileReader.getTotalRecords());
        this.verifySimpleRecords((Iterator<GenericRecord>)hfileReader.getRecordIterator(avroSchema));
    }

    @Test
    public void testReaderGetRecordIterator() throws Exception {
        this.writeFileWithSimpleSchema();
        HoodieHFileReader hfileReader = (HoodieHFileReader)this.createReader(new Configuration());
        List keys = IntStream.concat(IntStream.range(40, 100), IntStream.range(10, 20)).mapToObj(i -> "key" + String.format("%02d", i)).collect(Collectors.toList());
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
        ClosableIterator iterator = hfileReader.getRecordsByKeysIterator(keys, avroSchema);
        List expectedIds = IntStream.concat(IntStream.range(40, 50), IntStream.range(10, 20)).boxed().collect(Collectors.toList());
        int index = 0;
        while (iterator.hasNext()) {
            GenericRecord record = (GenericRecord)iterator.next();
            String key = "key" + String.format("%02d", expectedIds.get(index));
            Assertions.assertEquals((Object)key, (Object)record.get("_row_key").toString());
            Assertions.assertEquals((Object)Integer.toString((Integer)expectedIds.get(index)), (Object)record.get("time").toString());
            Assertions.assertEquals(expectedIds.get(index), (Object)record.get("number"));
            ++index;
        }
    }

    @Test
    public void testReaderGetRecordIteratorByKeyPrefixes() throws Exception {
        this.writeFileWithSimpleSchema();
        HoodieHFileReader hfileReader = (HoodieHFileReader)this.createReader(new Configuration());
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
        List<String> keyPrefixes = Collections.singletonList("key");
        ClosableIterator iterator = hfileReader.getRecordsByKeyPrefixIterator(keyPrefixes, avroSchema);
        List recordsByPrefix = CollectionUtils.toStream((Iterator)iterator).collect(Collectors.toList());
        List allRecords = CollectionUtils.toStream((Iterator)hfileReader.getRecordIterator()).collect(Collectors.toList());
        Assertions.assertEquals(allRecords, recordsByPrefix);
        List expectedKey1s = allRecords.stream().filter(entry -> entry.get("_row_key").toString().contains("key1")).collect(Collectors.toList());
        iterator = hfileReader.getRecordsByKeyPrefixIterator(Collections.singletonList("key1"), avroSchema);
        recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).collect(Collectors.toList());
        Assertions.assertEquals(expectedKey1s, recordsByPrefix);
        List expectedKey25 = allRecords.stream().filter(entry -> entry.get("_row_key").toString().contains("key25")).collect(Collectors.toList());
        iterator = hfileReader.getRecordsByKeyPrefixIterator(Collections.singletonList("key25"), avroSchema);
        recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).collect(Collectors.toList());
        Assertions.assertEquals(expectedKey25, recordsByPrefix);
        iterator = hfileReader.getRecordsByKeyPrefixIterator(Collections.singletonList("key99"), avroSchema);
        recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).collect(Collectors.toList());
        Assertions.assertEquals(Collections.emptyList(), recordsByPrefix);
        iterator = hfileReader.getRecordsByKeyPrefixIterator(Collections.singletonList("key1234"), avroSchema);
        recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).collect(Collectors.toList());
        Assertions.assertEquals(Collections.emptyList(), recordsByPrefix);
        List expectedKey50and1s = allRecords.stream().filter(entry -> entry.get("_row_key").toString().contains("key1") || entry.get("_row_key").toString().contains("key50")).collect(Collectors.toList());
        iterator = hfileReader.getRecordsByKeyPrefixIterator(Arrays.asList("key50", "key1"), avroSchema);
        recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).collect(Collectors.toList());
        Assertions.assertEquals(expectedKey50and1s, recordsByPrefix);
        List expectedKey50and0s = allRecords.stream().filter(entry -> entry.get("_row_key").toString().contains("key0") || entry.get("_row_key").toString().contains("key50")).collect(Collectors.toList());
        iterator = hfileReader.getRecordsByKeyPrefixIterator(Arrays.asList("key50", "key0"), avroSchema);
        recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).collect(Collectors.toList());
        Assertions.assertEquals(expectedKey50and0s, recordsByPrefix);
        List expectedKey1sand0s = allRecords.stream().filter(entry -> entry.get("_row_key").toString().contains("key1") || entry.get("_row_key").toString().contains("key0")).collect(Collectors.toList());
        iterator = hfileReader.getRecordsByKeyPrefixIterator(Arrays.asList("key1", "key0"), avroSchema);
        recordsByPrefix = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).collect(Collectors.toList());
        Collections.sort(recordsByPrefix, new Comparator<GenericRecord>(){

            @Override
            public int compare(GenericRecord o1, GenericRecord o2) {
                return o1.get("_row_key").toString().compareTo(o2.get("_row_key").toString());
            }
        });
        Assertions.assertEquals(expectedKey1sand0s, recordsByPrefix);
    }

    @ParameterizedTest
    @ValueSource(strings={"/hudi_0_9_hbase_1_2_3", "/hudi_0_10_hbase_1_2_3", "/hudi_0_11_hbase_2_4_9"})
    public void testHoodieHFileCompatibility(String hfilePrefix) throws IOException {
        String simpleHFile = hfilePrefix + SIMPLE_SCHEMA_HFILE_SUFFIX;
        String complexHFile = hfilePrefix + COMPLEX_SCHEMA_HFILE_SUFFIX;
        String bootstrapIndexFile = hfilePrefix + BOOTSTRAP_INDEX_HFILE_SUFFIX;
        FileSystem fs = FSUtils.getFs((String)this.getFilePath().toString(), (Configuration)new Configuration());
        byte[] content = this.readHFileFromResources(simpleHFile);
        this.verifyHFileReader(HoodieHFileUtils.createHFileReader((FileSystem)fs, (Path)new Path(DUMMY_BASE_PATH), (byte[])content), hfilePrefix, true, HoodieHFileConfig.HFILE_COMPARATOR.getClass(), 50);
        HoodieHFileReader hfileReader = new HoodieHFileReader(fs, new Path(DUMMY_BASE_PATH), content, Option.empty());
        Schema avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchema.avsc");
        Assertions.assertEquals((long)50L, (long)hfileReader.getTotalRecords());
        this.verifySimpleRecords((Iterator<GenericRecord>)hfileReader.getRecordIterator(avroSchema));
        content = this.readHFileFromResources(complexHFile);
        this.verifyHFileReader(HoodieHFileUtils.createHFileReader((FileSystem)fs, (Path)new Path(DUMMY_BASE_PATH), (byte[])content), hfilePrefix, true, HoodieHFileConfig.HFILE_COMPARATOR.getClass(), 50);
        hfileReader = new HoodieHFileReader(fs, new Path(DUMMY_BASE_PATH), content, Option.empty());
        avroSchema = SchemaTestUtil.getSchemaFromResource(TestHoodieReaderWriterBase.class, (String)"/exampleSchemaWithUDT.avsc");
        Assertions.assertEquals((long)50L, (long)hfileReader.getTotalRecords());
        this.verifySimpleRecords((Iterator<GenericRecord>)hfileReader.getRecordIterator(avroSchema));
        content = this.readHFileFromResources(bootstrapIndexFile);
        this.verifyHFileReader(HoodieHFileUtils.createHFileReader((FileSystem)fs, (Path)new Path(DUMMY_BASE_PATH), (byte[])content), hfilePrefix, false, HFileBootstrapIndex.HoodieKVComparator.class, 4);
    }

    private Set<String> getRandomKeys(int count, List<String> keys) {
        HashSet<String> rowKeys = new HashSet<String>();
        int totalKeys = keys.size();
        while (rowKeys.size() < count) {
            int index = FileSystemTestUtils.RANDOM.nextInt(totalKeys);
            if (rowKeys.contains(index)) continue;
            rowKeys.add(keys.get(index));
        }
        return rowKeys;
    }

    private byte[] readHFileFromResources(String filename) throws IOException {
        long size = TestHoodieHFileReaderWriter.class.getResource(filename).openConnection().getContentLength();
        return FileIOUtils.readAsByteArray((InputStream)TestHoodieHFileReaderWriter.class.getResourceAsStream(filename), (int)((int)size));
    }

    private void verifyHFileReader(HFile.Reader reader, String hfileName, boolean mayUseDefaultComparator, Class<?> clazz, int count) {
        Assertions.assertEquals((int)3, (int)reader.getTrailer().getMajorVersion());
        if (mayUseDefaultComparator && hfileName.contains("hudi_0_9")) {
            Assertions.assertEquals(CellComparatorImpl.class, reader.getComparator().getClass());
        } else {
            Assertions.assertEquals(clazz, reader.getComparator().getClass());
        }
        Assertions.assertEquals((long)count, (long)reader.getEntries());
    }
}

