/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieSliceInfo;
import org.apache.hudi.client.transaction.ConcurrentOperation;
import org.apache.hudi.client.transaction.SimpleConcurrentFileWritesConflictResolutionStrategy;
import org.apache.hudi.client.utils.TransactionUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSimpleConcurrentFileWritesConflictResolutionStrategy
extends HoodieCommonTestHarness {
    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void testNoConcurrentWrites() throws Exception {
        String newInstantTime = HoodieTestTable.makeNewCommitTime();
        this.createCommit(newInstantTime);
        Option lastSuccessfulInstant = this.metaClient.getCommitsTimeline().filterCompletedInstants().lastInstant();
        newInstantTime = HoodieTestTable.makeNewCommitTime();
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", newInstantTime));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        Stream candidateInstants = strategy.getCandidateInstants(this.metaClient.getActiveTimeline(), (HoodieInstant)currentInstant.get(), lastSuccessfulInstant);
        Assertions.assertTrue((candidateInstants.count() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentWrites() throws Exception {
        String newInstantTime = HoodieTestTable.makeNewCommitTime();
        this.createCommit(newInstantTime);
        this.createInflightCommit(HoodieTestTable.makeNewCommitTime());
        this.createInflightCommit(HoodieTestTable.makeNewCommitTime());
        Option lastSuccessfulInstant = this.metaClient.getCommitsTimeline().filterCompletedInstants().lastInstant();
        newInstantTime = HoodieTestTable.makeNewCommitTime();
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", newInstantTime));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        Stream candidateInstants = strategy.getCandidateInstants(this.metaClient.getActiveTimeline(), (HoodieInstant)currentInstant.get(), lastSuccessfulInstant);
        Assertions.assertTrue((candidateInstants.count() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccesssfulCommit() throws Exception {
        this.createCommit(HoodieActiveTimeline.createNewInstantTime());
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = HoodieActiveTimeline.createNewInstantTime();
        this.createInflightCommit(currentWriterInstant);
        String newInstantTime = HoodieActiveTimeline.createNewInstantTime();
        this.createCommit(newInstantTime);
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = this.createCommitMetadata(currentWriterInstant);
        timeline = timeline.reload();
        List candidateInstants = strategy.getCandidateInstants(timeline, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 1 ? 1 : 0) != 0);
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, writer 1 and writer 2 should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWritesWithReplaceInflightCommit() throws Exception {
        this.createReplaceInflight(HoodieActiveTimeline.createNewInstantTime());
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = Option.empty();
        String currentWriterInstant = HoodieActiveTimeline.createNewInstantTime();
        this.createInflightCommit(currentWriterInstant);
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        String newInstantTime = HoodieActiveTimeline.createNewInstantTime();
        this.createReplaceInflight(newInstantTime);
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = this.createCommitMetadata(currentWriterInstant);
        timeline = timeline.reload();
        List candidateInstants = strategy.getCandidateInstants(timeline, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 1 ? 1 : 0) != 0);
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, writer 1 and writer 2 should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWritesWithInterleavingScheduledCompaction() throws Exception {
        this.createCommit(HoodieActiveTimeline.createNewInstantTime());
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = HoodieActiveTimeline.createNewInstantTime();
        this.createInflightCommit(currentWriterInstant);
        String newInstantTime = HoodieActiveTimeline.createNewInstantTime();
        this.createCompactionRequested(newInstantTime);
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = this.createCommitMetadata(currentWriterInstant);
        timeline = timeline.reload();
        List candidateInstants = strategy.getCandidateInstants(timeline, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 1 ? 1 : 0) != 0);
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccessfulCompaction() throws Exception {
        this.createCommit(HoodieActiveTimeline.createNewInstantTime());
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = HoodieActiveTimeline.createNewInstantTime();
        this.createInflightCommit(currentWriterInstant);
        String newInstantTime = HoodieActiveTimeline.createNewInstantTime();
        this.createCompaction(newInstantTime);
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = this.createCommitMetadata(currentWriterInstant);
        timeline = timeline.reload();
        List candidateInstants = strategy.getCandidateInstants(timeline, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 1 ? 1 : 0) != 0);
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWriteAndCompactionScheduledEarlier() throws Exception {
        this.createCommit(HoodieActiveTimeline.createNewInstantTime());
        String newInstantTime = HoodieActiveTimeline.createNewInstantTime();
        this.createCompaction(newInstantTime);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = HoodieActiveTimeline.createNewInstantTime();
        this.createInflightCommit(currentWriterInstant);
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = this.createCommitMetadata(currentWriterInstant);
        timeline = timeline.reload();
        List candidateInstants = strategy.getCandidateInstants(timeline, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentWritesWithInterleavingScheduledCluster() throws Exception {
        this.createCommit(HoodieActiveTimeline.createNewInstantTime());
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = HoodieActiveTimeline.createNewInstantTime();
        this.createInflightCommit(currentWriterInstant);
        String newInstantTime = HoodieActiveTimeline.createNewInstantTime();
        this.createReplaceRequested(newInstantTime);
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = this.createCommitMetadata(currentWriterInstant);
        timeline = timeline.reload();
        List candidateInstants = strategy.getCandidateInstants(timeline, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 1 ? 1 : 0) != 0);
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccessfulCluster() throws Exception {
        this.createCommit(HoodieActiveTimeline.createNewInstantTime());
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = HoodieActiveTimeline.createNewInstantTime();
        this.createInflightCommit(currentWriterInstant);
        String newInstantTime = HoodieActiveTimeline.createNewInstantTime();
        this.createReplace(newInstantTime, WriteOperationType.CLUSTER);
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = this.createCommitMetadata(currentWriterInstant);
        timeline = timeline.reload();
        List candidateInstants = strategy.getCandidateInstants(timeline, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 1 ? 1 : 0) != 0);
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccessfulReplace() throws Exception {
        this.createCommit(HoodieActiveTimeline.createNewInstantTime());
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = HoodieActiveTimeline.createNewInstantTime();
        this.createInflightCommit(currentWriterInstant);
        String newInstantTime = HoodieActiveTimeline.createNewInstantTime();
        this.createReplace(newInstantTime, WriteOperationType.INSERT_OVERWRITE);
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = this.createCommitMetadata(currentWriterInstant);
        timeline = timeline.reload();
        List candidateInstants = strategy.getCandidateInstants(timeline, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 1 ? 1 : 0) != 0);
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    private void createCommit(String instantTime) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-1");
        commitMetadata.addWriteStat("2016/03/15", writeStat);
        commitMetadata.setOperationType(WriteOperationType.INSERT);
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addCommit(instantTime, Option.of((Object)commitMetadata)).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    private HoodieCommitMetadata createCommitMetadata(String instantTime, String writeFileName) {
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId(writeFileName);
        commitMetadata.addWriteStat("2016/03/15", writeStat);
        commitMetadata.setOperationType(WriteOperationType.INSERT);
        return commitMetadata;
    }

    private HoodieCommitMetadata createCommitMetadata(String instantTime) {
        return this.createCommitMetadata(instantTime, "file-1");
    }

    private void createInflightCommit(String instantTime) throws Exception {
        String fileId1 = "file-" + instantTime + "-1";
        String fileId2 = "file-" + instantTime + "-2";
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addInflightCommit(instantTime).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    private void createCompactionRequested(String instantTime) throws Exception {
        String fileId1 = "file-1";
        HoodieCompactionPlan compactionPlan = new HoodieCompactionPlan();
        compactionPlan.setVersion(TimelineLayoutVersion.CURR_VERSION);
        HoodieCompactionOperation operation = new HoodieCompactionOperation();
        operation.setFileId(fileId1);
        operation.setPartitionPath("2016/03/15");
        operation.setDataFilePath("/file-1");
        operation.setDeltaFilePaths(Arrays.asList("/file-1"));
        compactionPlan.setOperations(Arrays.asList(operation));
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addRequestedCompaction(instantTime, compactionPlan);
    }

    private void createCompaction(String instantTime) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        commitMetadata.setOperationType(WriteOperationType.COMPACT);
        commitMetadata.setCompacted(Boolean.valueOf(true));
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-1");
        commitMetadata.addWriteStat("2016/03/15", writeStat);
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addCommit(instantTime, Option.of((Object)commitMetadata)).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    private void createReplaceRequested(String instantTime) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = new HoodieRequestedReplaceMetadata();
        requestedReplaceMetadata.setOperationType(WriteOperationType.CLUSTER.name());
        HoodieClusteringPlan clusteringPlan = new HoodieClusteringPlan();
        HoodieClusteringGroup clusteringGroup = new HoodieClusteringGroup();
        HoodieSliceInfo sliceInfo = new HoodieSliceInfo();
        sliceInfo.setFileId(fileId1);
        sliceInfo.setPartitionPath("2016/03/15");
        clusteringGroup.setSlices(Arrays.asList(sliceInfo));
        clusteringPlan.setInputGroups(Arrays.asList(clusteringGroup));
        requestedReplaceMetadata.setClusteringPlan(clusteringPlan);
        requestedReplaceMetadata.setVersion(TimelineLayoutVersion.CURR_VERSION);
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addRequestedReplace(instantTime, Option.of((Object)requestedReplaceMetadata)).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    private void createReplaceInflight(String instantTime) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieCommitMetadata inflightReplaceMetadata = new HoodieCommitMetadata();
        inflightReplaceMetadata.setOperationType(WriteOperationType.INSERT_OVERWRITE);
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-1");
        inflightReplaceMetadata.addWriteStat("2016/03/15", writeStat);
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addInflightReplace(instantTime, Option.of((Object)inflightReplaceMetadata)).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    private void createReplace(String instantTime, WriteOperationType writeOperationType) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieReplaceCommitMetadata replaceMetadata = new HoodieReplaceCommitMetadata();
        HashMap<String, List<String>> partitionFileIds = new HashMap<String, List<String>>();
        partitionFileIds.put("2016/03/15", Arrays.asList(fileId2));
        replaceMetadata.setPartitionToReplaceFileIds(partitionFileIds);
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-1");
        replaceMetadata.addWriteStat("2016/03/15", writeStat);
        replaceMetadata.setOperationType(writeOperationType);
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = new HoodieRequestedReplaceMetadata();
        requestedReplaceMetadata.setOperationType(WriteOperationType.CLUSTER.name());
        HoodieClusteringPlan clusteringPlan = new HoodieClusteringPlan();
        HoodieClusteringGroup clusteringGroup = new HoodieClusteringGroup();
        HoodieSliceInfo sliceInfo = new HoodieSliceInfo();
        sliceInfo.setFileId(fileId1);
        sliceInfo.setPartitionPath("2016/03/15");
        clusteringGroup.setSlices(Arrays.asList(sliceInfo));
        clusteringPlan.setInputGroups(Arrays.asList(clusteringGroup));
        requestedReplaceMetadata.setClusteringPlan(clusteringPlan);
        requestedReplaceMetadata.setVersion(TimelineLayoutVersion.CURR_VERSION);
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addReplaceCommit(instantTime, Option.of((Object)requestedReplaceMetadata), Option.empty(), replaceMetadata).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    @Test
    public void testConcurrentWritesWithPendingInstants() throws Exception {
        String newInstantTimeC1 = HoodieActiveTimeline.createNewInstantTime();
        this.createPendingReplace(newInstantTimeC1, WriteOperationType.CLUSTER);
        String newCompactionInstantTimeC11 = HoodieActiveTimeline.createNewInstantTime();
        this.createPendingCompaction(newCompactionInstantTimeC11);
        String newCommitInstantTimeC12 = HoodieActiveTimeline.createNewInstantTime();
        this.createInflightCommit(newCommitInstantTimeC12);
        this.createCommit(HoodieActiveTimeline.createNewInstantTime());
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = HoodieActiveTimeline.createNewInstantTime();
        this.createInflightCommit(currentWriterInstant);
        String commitC4 = HoodieActiveTimeline.createNewInstantTime();
        this.createRequestedCommit(commitC4);
        this.metaClient.reloadActiveTimeline();
        Set pendingInstant = TransactionUtils.getInflightAndRequestedInstants((HoodieTableMetaClient)this.metaClient);
        pendingInstant.remove(currentWriterInstant);
        this.createCompleteReplace(newInstantTimeC1, WriteOperationType.CLUSTER);
        this.createCompleteCompaction(newCompactionInstantTimeC11);
        this.createCompleteCommit(newCommitInstantTimeC12);
        this.createCompleteCommit(commitC4);
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = this.createCommitMetadata(currentWriterInstant, "file-2");
        timeline.reload();
        List completedInstantsDuringCurrentWriteOperation = TransactionUtils.getCompletedInstantsDuringCurrentWriteOperation((HoodieTableMetaClient)this.metaClient, (Set)pendingInstant).collect(Collectors.toList());
        Assertions.assertTrue((completedInstantsDuringCurrentWriteOperation.size() == 4 ? 1 : 0) != 0);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        for (HoodieInstant instant : completedInstantsDuringCurrentWriteOperation) {
            ConcurrentOperation thatCommitOperation = new ConcurrentOperation(instant, this.metaClient);
            Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
            try {
                strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            }
            catch (HoodieWriteConflictException hoodieWriteConflictException) {}
        }
    }

    private void createPendingReplace(String instantTime, WriteOperationType writeOperationType) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = new HoodieRequestedReplaceMetadata();
        requestedReplaceMetadata.setOperationType(WriteOperationType.CLUSTER.name());
        HoodieClusteringPlan clusteringPlan = new HoodieClusteringPlan();
        HoodieClusteringGroup clusteringGroup = new HoodieClusteringGroup();
        HoodieSliceInfo sliceInfo = new HoodieSliceInfo();
        sliceInfo.setFileId(fileId2);
        sliceInfo.setPartitionPath("2016/03/15");
        clusteringGroup.setSlices(Arrays.asList(sliceInfo));
        clusteringPlan.setInputGroups(Arrays.asList(clusteringGroup));
        requestedReplaceMetadata.setClusteringPlan(clusteringPlan);
        requestedReplaceMetadata.setVersion(TimelineLayoutVersion.CURR_VERSION);
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addPendingReplace(instantTime, Option.of((Object)requestedReplaceMetadata), Option.empty()).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    private void createCompleteReplace(String instantTime, WriteOperationType writeOperationType) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieReplaceCommitMetadata replaceMetadata = new HoodieReplaceCommitMetadata();
        HashMap<String, List<String>> partitionFileIds = new HashMap<String, List<String>>();
        partitionFileIds.put("2016/03/15", Arrays.asList(fileId2));
        replaceMetadata.setPartitionToReplaceFileIds(partitionFileIds);
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-2");
        replaceMetadata.addWriteStat("2016/03/15", writeStat);
        replaceMetadata.setOperationType(writeOperationType);
        FileCreateUtils.createReplaceCommit((String)this.metaClient.getBasePath(), (String)instantTime, (HoodieReplaceCommitMetadata)replaceMetadata);
    }

    private void createPendingCompaction(String instantTime) throws Exception {
        String fileId1 = "file-2";
        HoodieCompactionPlan compactionPlan = new HoodieCompactionPlan();
        compactionPlan.setVersion(TimelineLayoutVersion.CURR_VERSION);
        HoodieCompactionOperation operation = new HoodieCompactionOperation();
        operation.setFileId(fileId1);
        operation.setPartitionPath("2016/03/15");
        operation.setDataFilePath("/file-2");
        operation.setDeltaFilePaths(Arrays.asList("/file-2"));
        compactionPlan.setOperations(Arrays.asList(operation));
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addRequestedCompaction(instantTime, compactionPlan);
        FileCreateUtils.createPendingInflightCompaction((String)this.metaClient.getBasePath(), (String)instantTime);
    }

    private void createCompleteCompaction(String instantTime) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        commitMetadata.setOperationType(WriteOperationType.COMPACT);
        commitMetadata.setCompacted(Boolean.valueOf(true));
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-2");
        commitMetadata.addWriteStat("2016/03/15", writeStat);
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addCommit(instantTime, Option.of((Object)commitMetadata)).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    private void createRequestedCommit(String instantTime) throws Exception {
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addInflightCommit(instantTime);
    }

    private void createCompleteCommit(String instantTime) throws Exception {
        String fileId1 = "file-1";
        String fileId2 = "file-2";
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId("file-2");
        commitMetadata.addWriteStat("2016/03/15", writeStat);
        commitMetadata.setOperationType(WriteOperationType.INSERT);
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addCommit(instantTime, Option.of((Object)commitMetadata)).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }
}

