/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.async;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.hudi.async.AsyncArchiveService;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.config.HoodieWriteConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TestAsyncArchiveService {
    @Mock
    BaseHoodieWriteClient writeClient;
    @Mock
    HoodieWriteConfig config;

    TestAsyncArchiveService() {
    }

    @Test
    void startAsyncArchiveReturnsNullWhenAutoArchiveDisabled() {
        Mockito.when((Object)this.config.isAutoArchive()).thenReturn((Object)false);
        Mockito.when((Object)this.writeClient.getConfig()).thenReturn((Object)this.config);
        Assertions.assertNull((Object)AsyncArchiveService.startAsyncArchiveIfEnabled((BaseHoodieWriteClient)this.writeClient));
    }

    @Test
    void startAsyncArchiveReturnsNullWhenAsyncArchiveDisabled() {
        Mockito.when((Object)this.config.isAutoArchive()).thenReturn((Object)true);
        Mockito.when((Object)this.config.isAsyncArchive()).thenReturn((Object)false);
        Mockito.when((Object)this.writeClient.getConfig()).thenReturn((Object)this.config);
        Assertions.assertNull((Object)AsyncArchiveService.startAsyncArchiveIfEnabled((BaseHoodieWriteClient)this.writeClient));
    }

    @Test
    void startAsyncArchiveIfEnabled() {
        Mockito.when((Object)this.config.isAutoArchive()).thenReturn((Object)true);
        Mockito.when((Object)this.config.isAsyncArchive()).thenReturn((Object)true);
        Mockito.when((Object)this.writeClient.getConfig()).thenReturn((Object)this.config);
        Assertions.assertNotNull((Object)AsyncArchiveService.startAsyncArchiveIfEnabled((BaseHoodieWriteClient)this.writeClient));
    }

    @Test
    void startServiceShouldInvokeCallArchiveMethod() throws ExecutionException, InterruptedException {
        AsyncArchiveService service = new AsyncArchiveService(this.writeClient);
        Assertions.assertEquals((Object)true, ((CompletableFuture)service.startService().getLeft()).get());
        ((BaseHoodieWriteClient)Mockito.verify((Object)this.writeClient)).archive();
    }
}

