/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Collections;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;

public class SimpleAvroKeyGenerator
extends BaseKeyGenerator {
    public SimpleAvroKeyGenerator(TypedProperties props) {
        this(props, props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()), props.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
    }

    SimpleAvroKeyGenerator(TypedProperties props, String partitionPathField) {
        this(props, null, partitionPathField);
    }

    SimpleAvroKeyGenerator(TypedProperties props, String recordKeyField, String partitionPathField) {
        super(props);
        this.recordKeyFields = recordKeyField == null ? Collections.emptyList() : Collections.singletonList(recordKeyField);
        this.partitionPathFields = Collections.singletonList(partitionPathField);
    }

    public String getRecordKey(GenericRecord record) {
        return KeyGenUtils.getRecordKey(record, (String)this.getRecordKeyFieldNames().get(0), this.isConsistentLogicalTimestampEnabled());
    }

    public String getPartitionPath(GenericRecord record) {
        return KeyGenUtils.getPartitionPath(record, (String)this.getPartitionPathFields().get(0), this.hiveStylePartitioning, this.encodePartitionPath, this.isConsistentLogicalTimestampEnabled());
    }
}

